package org.gcube.social_networking.socialnetworking.model.beans;

public enum WorkspaceNotificationType {

	/**
	 * use to notify a user she got a workspace item new in some of her workspace shared folder
	 */
	ITEM_NEW(WorkspaceNotificationAddedItem.class),
	/**
	 * use to notify a user he got a workspace folder shared
	 */
	FOLDER_SHARE(WorkspaceNotificationSharedFolder.class),
	/**
	 * use to notify a user he got a workspace folder Unshared
	 */
	FOLDER_UNSHARE(WorkspaceNotificationUnsharedFolder.class);
	
	
	
	Class<? extends WorkspaceNotification> beanClass;
	
	WorkspaceNotificationType(Class<? extends WorkspaceNotification> beanClass){
		this.beanClass = beanClass;
	}

	
	public Class<? extends WorkspaceNotification> getNotificationClass(){
		return this.beanClass;
	}
	
}
