/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.social_networking_client_library;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.Validate;
import org.gcube.portal.databook.shared.Like;
import org.gcube.social_networking.social_networking_client_library.BaseClient;
import org.gcube.social_networking.social_networking_client_library.utils.HttpClient;
import org.gcube.social_networking.socialnetworking.model.output.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikeClient
extends BaseClient {
    private static final String SUB_SERVICE_PATH = "2/likes/";
    private static Logger logger = LoggerFactory.getLogger(LikeClient.class);

    public LikeClient() throws Exception {
        super(SUB_SERVICE_PATH);
    }

    public boolean likeLib(Like like) {
        Validate.isTrue((like != null ? 1 : 0) != 0, (String)"like to write cannot be null");
        logger.debug("Request for liking post");
        String thisMethodSignature = "like-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, like);
    }

    public boolean unlikeLib(String userid, String likeid, String feedid) {
        Validate.isTrue((likeid != null ? 1 : 0) != 0, (String)"likeid to unlike cannot be null");
        logger.debug("Request for unliking post");
        String thisMethodSignature = "unlike-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?userid=" + userid + "&likeid=" + likeid + "&feedid=" + feedid;
        return HttpClient.post(new GenericType<ResponseBean<Boolean>>(){}, request, likeid);
    }

    public List<String> getAllLikedPostIdsByUserLib(String userid) {
        Validate.isTrue((userid != null ? 1 : 0) != 0, (String)"userid to read likes cannot be null");
        logger.debug("Request for reading likes of user");
        String thisMethodSignature = "get-all-liked-posts-by-user-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?userid=" + userid;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<String>>>(){}, request);
    }

    public List<Like> getAllLikesByPostLib(String postid) {
        Validate.isTrue((postid != null ? 1 : 0) != 0, (String)"postid to read likes cannot be null");
        logger.debug("Request for reading likes of post");
        String thisMethodSignature = "get-all-likes-by-post-lib";
        String request = String.valueOf(this.getServiceEndpoint()) + thisMethodSignature + "?postid=" + postid;
        return HttpClient.get(new GenericType<ResponseBean<ArrayList<Like>>>(){}, request);
    }
}

