/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social_networking_client_library;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.JobStatusType;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.social_networking.social_networking_client_library.FullTextSearchClient;
import org.gcube.social_networking.social_networking_client_library.HashTagClient;
import org.gcube.social_networking.social_networking_client_library.MessageClient;
import org.gcube.social_networking.social_networking_client_library.NotificationClient;
import org.gcube.social_networking.social_networking_client_library.PeopleClient;
import org.gcube.social_networking.social_networking_client_library.PostClient;
import org.gcube.social_networking.social_networking_client_library.TokenClient;
import org.gcube.social_networking.social_networking_client_library.UserClient;
import org.gcube.social_networking.social_networking_client_library.VREClient;
import org.gcube.social_networking.socialnetworking.model.beans.ApplicationId;
import org.gcube.social_networking.socialnetworking.model.beans.JobNotificationBean;
import org.gcube.social_networking.socialnetworking.model.beans.Message;
import org.gcube.social_networking.socialnetworking.model.beans.MessageInbox;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.beans.Recipient;
import org.gcube.social_networking.socialnetworking.model.beans.UserProfile;
import org.gcube.social_networking.socialnetworking.model.beans.UserProfileExtended;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientServices {
    private static Logger logger = LoggerFactory.getLogger(TestClientServices.class);

    @Before
    public void setContextAndToken() {
        ScopeProvider.instance.set("/gcube/devsec/devVRE");
        AccessTokenProvider.instance.set("eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICJSSklZNEpoNF9qdDdvNmREY0NlUDFfS1l0akcxVExXVW9oMkQ2Tzk1bFNBIn0.eyJleHAiOjE2NDkyMzQ3NDksImlhdCI6MTY0OTIzNDQ0OSwiYXV0aF90aW1lIjoxNjQ5MjM0NDQ0LCJqdGkiOiJhMzI3NmY4Ny05NmZjLTRmZTQtYjIyZC1jNzFmZTQ1MjM3ZmMiLCJpc3MiOiJodHRwczovL2FjY291bnRzLmRldi5kNHNjaWVuY2Uub3JnL2F1dGgvcmVhbG1zL2Q0c2NpZW5jZSIsImF1ZCI6IiUyRmdjdWJlJTJGZGV2c2VjJTJGZGV2VlJFIiwic3ViIjoiNmE4MmY1ODctYzgwZS00OWUzLTg4YzYtYzExN2U5ZDhkM2Y3IiwidHlwIjoiQmVhcmVyIiwiYXpwIjoibmV4dC5kNHNjaWVuY2Uub3JnIiwic2Vzc2lvbl9zdGF0ZSI6IjRlODhiYjBjLWJkYzItNGQzOC05NTUzLTRjMDUwYWVjODk1MCIsImFjciI6IjEiLCJhbGxvd2VkLW9yaWdpbnMiOlsiLyoiXSwicmVzb3VyY2VfYWNjZXNzIjp7IiUyRmdjdWJlJTJGZGV2c2VjJTJGZGV2VlJFIjp7InJvbGVzIjpbIkRhdGEtTWFuYWdlciIsIlZSRS1NYW5hZ2VyIiwiTWVtYmVyIl19fSwiYXV0aG9yaXphdGlvbiI6eyJwZXJtaXNzaW9ucyI6W3sicnNpZCI6IjU3Mjg1NTEwLTM5MzktNGRlNy04ZmMxLWUzYTlkM2NjZTI4MSIsInJzbmFtZSI6IkRlZmF1bHQgUmVzb3VyY2UifV19LCJzY29wZSI6ImVtYWlsIHByb2ZpbGUiLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwibmFtZSI6Ik1hc3NpbWlsaWFuIEFzc2FudGUiLCJwcmVmZXJyZWRfdXNlcm5hbWUiOiJtYXNzaW1pbGlhbm8uYXNzYW50ZSIsImdpdmVuX25hbWUiOiJNYXNzaW1pbGlhbiIsImxvY2FsZSI6ImVuIiwiZmFtaWx5X25hbWUiOiJBc3NhbnRlIiwiZW1haWwiOiJtYXNzaW1pbGlhbm8uYXNzYW50ZUBpc3RpLmNuci5pdCJ9.MFee4w8XAgchOHGiqMYnmYCpclNOmC8xiZMkoqeg3UnaN9iEslwJJtAjeZiEdCBlnypw9Y1a8Fisc5p6f2IBBMaDtbE_omYTStBSDT84ZJMrspHIjstAinax0sY0h2tG-DBhdK6AI0D-MFiOL07FW4iQgizXh4qnpzVNL0vxIUQMYo99R4DYsZzcsrxnUL0qzhNHfN4PqdMRWpt-eRyKO15FvA7_HExAemOzYEFbRrw8JSpsXj6BNcRg9ZwRV7815WhbqhV-Cq3_PDjyiSw3mVGjeh1QmNTOSbBKniGYJo2nWBng3tP_HS0yoS1xRCS9d0PrjBEVdbRn-HlM4M43DA");
    }

    @Test
    public void testSearch() throws Exception {
        FullTextSearchClient search = new FullTextSearchClient();
        ArrayList result = search.search("looking for test", 0, 10);
        for (EnhancedFeed enhancedPost : result) {
            logger.debug("Returned post " + enhancedPost);
        }
    }

    public void testSearchEmptyList() throws Exception {
        FullTextSearchClient search = new FullTextSearchClient();
        ArrayList result = search.search("tipiterotipir\u00e8", 0, 10);
        for (EnhancedFeed enhancedFeed : result) {
            logger.debug("Returned feed " + enhancedFeed);
        }
    }

    @Test
    public void testHashTags() throws Exception {
        HashTagClient hashtags = new HashTagClient();
        Map hashtagsCount = hashtags.getHashtagsCount();
        logger.debug("Returned tags " + hashtagsCount);
    }

    @Test
    public void testMessagesReceived() throws Exception {
        MessageClient messagesClient = new MessageClient();
        List receivedMessages = messagesClient.getReceivedMessages();
        System.out.println("Messages found # " + receivedMessages.size());
        for (MessageInbox workspaceMessage : receivedMessages) {
            logger.debug("Received message  " + workspaceMessage.toString());
        }
    }

    @Test
    public void testMessagesSent() throws Exception {
        MessageClient messagesClient = new MessageClient();
        List sentMessages = messagesClient.getSentMessages();
        for (MessageInbox workspaceMessage : sentMessages) {
            logger.debug("Sent message was " + workspaceMessage);
        }
    }

    @Test
    public void sendMessage() throws Exception {
        logger.debug("Sending message ");
        MessageClient messagesClient = new MessageClient();
        List<Recipient> rec = Arrays.asList(new Recipient("andrea.rossi"));
        Message message = new Message("Test message", "Sending message via client " + System.currentTimeMillis(), new ArrayList<Recipient>(rec));
        String idMessage = messagesClient.writeMessage(message);
        assert (idMessage != null);
    }

    public void testNotifications() throws Exception {
        NotificationClient notificationsClient = new NotificationClient();
        List latestNotifications = notificationsClient.getNotifications(1, 2);
        for (Notification notification : latestNotifications) {
            logger.debug("Notification is " + notification);
        }
    }

    @Test
    public void sendJobNotification() throws Exception {
        NotificationClient notificationsClient = new NotificationClient();
        JobNotificationBean notification = new JobNotificationBean("massimiliano.assante", UUID.randomUUID().toString(), "SmartExecutor Social Indexer", "Workspace Application", JobStatusType.SUCCEEDED, "all ok");
        notificationsClient.sendJobNotification(notification);
        logger.debug("Sent job notification ");
    }

    @Test
    public void getProfile() throws Exception {
        PeopleClient getProfile = new PeopleClient();
        UserProfile profile = getProfile.getProfile();
        logger.debug("Profile retrieved is " + profile);
    }

    public void generateAppToken() throws Exception {
        TokenClient tokenClient = new TokenClient();
        String token = tokenClient.generateApplicationToken(new ApplicationId("org.gcube.datacatalogue.GRSFNotifier"));
        logger.debug("Generated token is  " + token);
    }

    public void getMyVres() throws Exception {
        VREClient myVresClient = new VREClient();
        List myVres = myVresClient.getMyVRES(false);
        logger.debug("My Vres  " + myVres);
    }

    public void UsersClientTests() throws Exception {
        UserClient userClient = new UserClient();
        List vreManagers = userClient.getAllUsernamesByLocalRole("vre-manager");
        assert (vreManagers != null && !vreManagers.isEmpty());
        logger.debug("Vre Managers are " + vreManagers);
        String myEmail = userClient.getEmail();
        assert (myEmail != null && !myEmail.isEmpty());
        logger.debug("My email is " + myEmail);
        String fullname = userClient.getFullName();
        assert (fullname != null && !fullname.isEmpty());
        logger.debug("My fullname is " + fullname);
        String industry = userClient.getCustomAttribute("Industry");
        assert (industry != null && !industry.isEmpty());
        logger.debug("My Industry is " + industry);
        List usernamesInThisContext = userClient.getAllUsernamesContext();
        assert (usernamesInThisContext != null && !usernamesInThisContext.isEmpty());
        logger.debug("List of usernames in this context is  " + usernamesInThisContext);
        Map usernamesFullnameInThisContext = userClient.getAllUsernamesFullnamesContext();
        assert (usernamesFullnameInThisContext != null && !usernamesFullnameInThisContext.isEmpty());
        logger.debug("List of tuples usernames/fullnames in this context is  " + usernamesFullnameInThisContext);
        UserProfileExtended profile = userClient.getProfile();
        assert (profile != null);
        logger.debug("My wonderful profile is " + profile);
    }

    public void getUserPostsSinceDate() throws Exception {
        PostClient postClient = new PostClient();
        List sinceLastYearPost = postClient.getUserPostsSinceDate(System.currentTimeMillis() - 1036800000L);
        logger.debug("Posts are " + sinceLastYearPost);
    }

    public void getAllUserPosts() throws Exception {
        PostClient postClient = new PostClient();
        List allposts = postClient.getAllUserPosts();
        logger.debug("All posts are " + allposts);
    }

    public void getUserPostsQuantity() throws Exception {
        PostClient postClient = new PostClient();
        List quantityPosts = postClient.getUserPostsQuantity(3);
        logger.debug("Some posts are " + quantityPosts);
    }

    public void writeUserPost() throws Exception {
        PostClient postClient = new PostClient();
        PostInputBean toWrite = new PostInputBean("Testing social networking rest client", null, null, null, null, null, false, null);
        Feed written = postClient.writeUserPost(toWrite);
        logger.debug("Written post is " + written);
    }

    public void getAllApplicationPosts() throws Exception {
        TokenClient tokenClient = new TokenClient();
        String token = tokenClient.generateApplicationToken(new ApplicationId("org.gcube.datacatalogue.GRSFNotifier"));
        logger.debug("Generated token is  " + token);
        String currentToken = SecurityTokenProvider.instance.get();
        SecurityTokenProvider.instance.set(token);
        PostClient postClient = new PostClient();
        List applicationPosts = postClient.getAllApplicationPosts();
        logger.debug("Application posts are " + applicationPosts);
        SecurityTokenProvider.instance.set(currentToken);
    }

    public void writeApplicationPost() throws Exception {
        TokenClient tokenClient = new TokenClient();
        String token = tokenClient.generateApplicationToken(new ApplicationId("org.gcube.datacatalogue.GRSFNotifier"));
        logger.debug("Generated token is  " + token);
        String currentToken = SecurityTokenProvider.instance.get();
        SecurityTokenProvider.instance.set(token);
        PostClient postClient = new PostClient();
        PostInputBean toWrite = new PostInputBean("Testing social networking rest client [via application token] #apptoken #rest #client #java", null, null, null, null, null, false, null);
        Feed written = postClient.writeApplicationPost(toWrite);
        logger.debug("Written post is " + written);
        SecurityTokenProvider.instance.set(currentToken);
    }

    public void getPostsVRE() throws Exception {
        PostClient postClient = new PostClient();
        List vrePosts = postClient.getPostsVRE();
        logger.debug("VRE posts are " + vrePosts);
    }

    public void getHashtagPosts() throws Exception {
        PostClient postClient = new PostClient();
        List postsWithHashtag = postClient.getHashtagPosts("#connect");
        logger.debug("Posts with hashtag #connect are " + postsWithHashtag);
    }

    public void getUserLikedPost() throws Exception {
        PostClient postClient = new PostClient();
        List postsLiked = postClient.getUserLikedPost();
        logger.debug("Posts liked are " + postsLiked);
    }

    public void getUserLikedPostIds() throws Exception {
        PostClient postClient = new PostClient();
        List postsLikedIds = postClient.getUserLikedPostIds();
        logger.debug("Posts liked's ids are " + postsLikedIds);
    }

    public void reset() {
        ScopeProvider.instance.reset();
        SecurityTokenProvider.instance.reset();
    }
}

