/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRegistration;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.events.Observes;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.resourcemanagement.model.impl.entities.facets.AccessPointFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.ServiceStateFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.EServiceImpl;
import org.gcube.resourcemanagement.model.impl.properties.ValueSchemaImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.ActivatesImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ServiceStateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.HostingNode;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Activates;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="resource-management")
public class EServiceManager
extends ApplicationLifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(EServiceManager.class);
    private ApplicationContext applicationContext;
    private AuthorizationProxy authorizationProxy = ProviderFactory.provider().authorizationProxy();
    private ScheduledFuture<?> periodicUpdates;
    private static List<String> servletExcludes = Arrays.asList("default", "jsp");

    private void setContextFromToken(String token) {
        if (token == null || token.compareTo("") == 0) {
            SecurityTokenProvider.instance.reset();
            ScopeProvider.instance.reset();
        } else {
            SecurityTokenProvider.instance.set(token);
            String scope = this.getContextName(token);
            ScopeProvider.instance.set(scope);
        }
    }

    public void onStart(ApplicationLifecycleEvent.Start e) {
        try {
            logger.info("onStart started");
            this.applicationContext = (ApplicationContext)e.context();
            this.init();
            this.registerObservers();
            this.schedulePeriodicUpdates();
            logger.info("onStart finished");
        }
        catch (Throwable re) {
            logger.error("onStart failed", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
            EService eService = null;
            Set startTokens = this.applicationContext.configuration().startTokens();
            for (String token : startTokens) {
                this.setContextFromToken(token);
                if (eService != null) {
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    this.addToContext(resourceRegistryPublisher);
                }
                eService = this.getEService();
                this.share(eService);
            }
        }
        catch (Throwable e) {
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        logger.info("init for EService executed");
    }

    private void share(EService eService) {
        logger.trace("sharing EService for {}", (Object)this.applicationContext.name());
        this.applicationContext.properties().add(new Property[]{new Property("EService", (Object)eService)});
    }

    private void registerObservers() {
        this.applicationContext.events().subscribe(new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"activation", "stop", "failure"})
            void onChanged(ApplicationLifecycle lc) {
                String state = EServiceManager.this.getState(lc);
                logger.debug("Moving app {} to {}", (Object)EServiceManager.this.applicationContext.name(), (Object)state);
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                if (previousToken == null) {
                    previousToken = (String)EServiceManager.this.applicationContext.configuration().startTokens().iterator().next();
                }
                EServiceManager.this.setContextFromToken(previousToken);
                try {
                    Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
                    EServiceManager.this.createOrUpdateServiceStateFacet(state);
                }
                catch (Exception e) {
                    logger.error("Failed to update Service State", (Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"addToContext"})
            void addTo(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                try {
                    Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
                    EServiceManager.this.setContextFromToken(token);
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    EServiceManager.this.addToContext(resourceRegistryPublisher);
                }
                catch (Exception e) {
                    logger.error("Failed to add HostingNode to current context ({})", (Object)EServiceManager.this.getCurrentContextName(), (Object)e);
                }
                finally {
                    EServiceManager.this.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                try {
                    Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
                    EServiceManager.this.setContextFromToken(token);
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    EServiceManager.this.removeFromContext(resourceRegistryPublisher);
                }
                catch (Exception e) {
                    logger.error("Failed to remove HostingNode from current context ({})", (Object)EServiceManager.this.getCurrentContextName(), (Object)e);
                }
                finally {
                    EServiceManager.this.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }
        });
    }

    private String getState(ApplicationLifecycle lc) {
        return ((ApplicationState)lc.state()).remoteForm().toLowerCase();
    }

    private void schedulePeriodicUpdates() {
        this.applicationContext.events().subscribe(new Object(){

            @Observes(value={"activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(final ApplicationLifecycle lc) {
                if (EServiceManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ApplicationState.active) {
                    logger.info("scheduling periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                } else {
                    logger.info("resuming periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String state = EServiceManager.this.getState(lc);
                            EServiceManager.this.createOrUpdateServiceStateFacet(state);
                        }
                        catch (Exception e) {
                            logger.error("Cannot complete periodic update of EService", (Throwable)e);
                        }
                    }
                };
                EServiceManager.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 20L, 20L, TimeUnit.MINUTES);
            }

            @Observes(value={"stop", "failure"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (EServiceManager.this.periodicUpdates != null) {
                    logger.trace("stopping periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                    try {
                        EServiceManager.this.periodicUpdates.cancel(true);
                        EServiceManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        logger.warn("could not stop periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name(), (Object)e);
                    }
                }
            }
        });
    }

    private Activates<HostingNode, EService> createActivatesRelation(EService eService, ResourceRegistryPublisher resourceRegistryPublisher) throws ResourceRegistryException {
        HostingNode hostingNode = (HostingNode)this.applicationContext.container().properties().lookup("HostingNode").value(HostingNode.class);
        this.addToContext(resourceRegistryPublisher);
        PropagationConstraintImpl propagationConstraint = new PropagationConstraintImpl();
        propagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
        propagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
        ActivatesImpl activates = new ActivatesImpl((Service)hostingNode, (Service)eService, (PropagationConstraint)propagationConstraint);
        try {
            activates = (Activates)resourceRegistryPublisher.createIsRelatedTo((IsRelatedTo)activates);
        }
        catch (NotFoundException e) {
            logger.error("THIS IS REALLY STRANGE. YOU SHOULD NE BE HERE. Error while creating {}.", (Object)activates, (Object)e);
            throw e;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while creating {}", (Object)activates, (Object)e);
            throw e;
        }
        hostingNode.attachResource((IsRelatedTo)activates);
        this.shareHostingNode(hostingNode);
        return activates;
    }

    private EService getEService() throws ResourceRegistryException {
        EService eService = null;
        ResourceRegistryClient resourceRegistryClient = ResourceRegistryClientFactory.create();
        ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
        UUID eServiceUUID = UUID.fromString(this.applicationContext.id());
        try {
            resourceRegistryClient.exists(EService.class, eServiceUUID);
            eService = (EService)resourceRegistryClient.getInstance(EService.class, eServiceUUID);
        }
        catch (NotFoundException e) {
            eService = this.instantiateEService(eServiceUUID);
            eService = (EService)this.createActivatesRelation(eService, resourceRegistryPublisher).getTarget();
        }
        catch (AvailableInAnotherContextException e) {
            this.addToContext(resourceRegistryPublisher);
            eService = (EService)resourceRegistryClient.getInstance(EService.class, eServiceUUID);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        return eService;
    }

    private void shareHostingNode(HostingNode hostingNode) {
        logger.trace("sharing {} {}", (Object)"HostingNode", (Object)"Resource");
        this.applicationContext.container().properties().add(new Property[]{new Property("HostingNode", (Object)hostingNode)});
    }

    private String getCurrentContextName() {
        String token = SecurityTokenProvider.instance.get();
        return this.getContextName(token);
    }

    private String getContextName(String token) {
        try {
            return this.authorizationProxy.get(token).getContext();
        }
        catch (Exception e) {
            logger.error("Error retrieving token {}, it should never happen", (Object)token);
            return null;
        }
    }

    private void addToContext(ResourceRegistryPublisher resourceRegistryPublisher) throws ResourceRegistryException {
        HostingNode hostingNode = (HostingNode)this.applicationContext.container().properties().lookup("HostingNode").value(HostingNode.class);
        resourceRegistryPublisher.addResourceToCurrentContext((Resource)hostingNode);
        logger.info("{} successfully added to current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName());
        this.shareHostingNode(hostingNode);
    }

    private void removeFromContext(ResourceRegistryPublisher resourceRegistryPublisher) throws ResourceRegistryException {
        HostingNode hostingNode = (HostingNode)this.applicationContext.container().properties().lookup("HostingNode").value(HostingNode.class);
        resourceRegistryPublisher.removeResourceFromCurrentContext((Resource)hostingNode);
        logger.info("{} successfully removed from current context ({})", (Object)hostingNode, (Object)this.getCurrentContextName());
        this.shareHostingNode(hostingNode);
    }

    private void createOrUpdateServiceStateFacet(String state) throws ResourceRegistryException {
        ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
        String selectedToken = this.applicationContext.configuration().startTokens().toArray(new String[0])[0];
        this.setContextFromToken(selectedToken);
        EService eService = this.getEService();
        ServiceStateFacetImpl serviceStateFacet = null;
        List serviceStateFacets = eService.getFacets(ServiceStateFacet.class);
        if (serviceStateFacets != null && serviceStateFacets.size() >= 1) {
            serviceStateFacet = (ServiceStateFacet)serviceStateFacets.get(0);
            serviceStateFacet.setValue(state);
            serviceStateFacet = (ServiceStateFacet)resourceRegistryPublisher.updateFacet((Facet)serviceStateFacet);
            for (int i = 1; i < serviceStateFacets.size(); ++i) {
                try {
                    logger.warn("You should not be here. There are more than one {}. Anyway deleting it : {}", (Object)ServiceStateFacet.class.getSimpleName(), serviceStateFacets.get(i));
                    resourceRegistryPublisher.deleteFacet((Facet)serviceStateFacets.get(i));
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Unable to delete {}  which should not exists : {}", (Object)ServiceStateFacet.class.getSimpleName(), serviceStateFacets.get(i));
                }
            }
        } else {
            serviceStateFacet = new ServiceStateFacetImpl();
            serviceStateFacet.setValue(state);
            serviceStateFacet = (ServiceStateFacet)resourceRegistryPublisher.createFacet((Facet)serviceStateFacet);
            ConsistsOfImpl consistsOf = new ConsistsOfImpl((Resource)eService, (Facet)serviceStateFacet, null);
            consistsOf = resourceRegistryPublisher.createConsistsOf((ConsistsOf)consistsOf);
        }
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
            Set startTokens = this.applicationContext.configuration().startTokens();
            for (String token : startTokens) {
                this.setContextFromToken(token);
                this.addToContext(resourceRegistryPublisher);
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        finally {
            this.setContextFromToken(null);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        this.share(eService);
    }

    private static String getBaseAddress(ApplicationContext context) {
        String baseAddress;
        ApplicationConfiguration configuration = context.configuration();
        ContainerConfiguration container = context.container().configuration();
        if (configuration.proxied()) {
            String protocol = configuration.proxyAddress().protocol();
            String port = configuration.proxyAddress().port() != null ? ":" + configuration.proxyAddress().port() : "";
            baseAddress = String.format("%s://%s%s%s", protocol, configuration.proxyAddress().hostname(), port, context.application().getContextPath());
        } else {
            String protocol = container.protocol();
            int port = container.port();
            baseAddress = String.format("%s://%s:%d%s", protocol, container.hostname(), port, context.application().getContextPath());
        }
        return baseAddress;
    }

    private EService instantiateEService(UUID uuid) {
        logger.info("Creating EService for {}", (Object)this.applicationContext.name());
        ApplicationConfiguration applicationConfiguration = this.applicationContext.configuration();
        EServiceImpl eService = new EServiceImpl();
        HeaderImpl header = new HeaderImpl(uuid);
        eService.setHeader((Header)header);
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        softwareFacet.setDescription(applicationConfiguration.description());
        softwareFacet.setGroup(applicationConfiguration.serviceClass());
        softwareFacet.setName(applicationConfiguration.name());
        softwareFacet.setVersion(applicationConfiguration.version());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)eService, (Facet)softwareFacet, null);
        eService.addFacet((ConsistsOf)isIdentifiedBy);
        String baseAddress = EServiceManager.getBaseAddress(this.applicationContext);
        for (ServletRegistration servlet : this.applicationContext.application().getServletRegistrations().values()) {
            if (servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
                AccessPointFacetImpl accessPointFacet = new AccessPointFacetImpl();
                accessPointFacet.setEntryName(servlet.getName());
                accessPointFacet.setEndpoint(URI.create(address));
                ValueSchemaImpl valueSchema = new ValueSchemaImpl();
                valueSchema.setValue("gcube-token");
                accessPointFacet.setAuthorization((org.gcube.informationsystem.model.reference.properties.Property)valueSchema);
                eService.addFacet((Facet)accessPointFacet);
            }
        }
        ServiceStateFacetImpl serviceStateFacet = new ServiceStateFacetImpl();
        String state = this.getState(this.applicationContext.lifecycle());
        serviceStateFacet.setValue(state.toLowerCase());
        eService.addFacet((Facet)serviceStateFacet);
        return eService;
    }

    public String toString() {
        return "resource-management";
    }
}

