/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model;

import java.util.Arrays;
import org.gcube.informationsystem.impl.embedded.DummyEmbedded;
import org.gcube.informationsystem.impl.embedded.EmbeddedImpl;
import org.gcube.informationsystem.impl.entity.ContextImpl;
import org.gcube.informationsystem.impl.entity.DummyFacet;
import org.gcube.informationsystem.impl.entity.DummyResource;
import org.gcube.informationsystem.impl.entity.EntityImpl;
import org.gcube.informationsystem.impl.entity.FacetImpl;
import org.gcube.informationsystem.impl.entity.ResourceImpl;
import org.gcube.informationsystem.impl.relation.ConsistsOfImpl;
import org.gcube.informationsystem.impl.relation.DummyConsistsOf;
import org.gcube.informationsystem.impl.relation.DummyIsRelatedTo;
import org.gcube.informationsystem.impl.relation.IsParentOfImpl;
import org.gcube.informationsystem.impl.relation.IsRelatedToImpl;
import org.gcube.informationsystem.impl.relation.RelationImpl;
import org.gcube.informationsystem.model.ISManageable;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsParentOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AccessType {
    EMBEDDED(Embedded.class, "Embedded", EmbeddedImpl.class, DummyEmbedded.class),
    CONTEXT(Context.class, "Context", ContextImpl.class, null),
    IS_PARENT_OF(IsParentOf.class, "IsParentOf", IsParentOfImpl.class, null),
    ENTITY(Entity.class, "Entity", EntityImpl.class, null),
    RESOURCE(Resource.class, "Resource", ResourceImpl.class, DummyResource.class),
    FACET(Facet.class, "Facet", FacetImpl.class, DummyFacet.class),
    RELATION(Relation.class, "Relation", RelationImpl.class, null),
    IS_RELATED_TO(IsRelatedTo.class, "IsRelatedTo", IsRelatedToImpl.class, DummyIsRelatedTo.class),
    CONSISTS_OF(ConsistsOf.class, "ConsistsOf", ConsistsOfImpl.class, DummyConsistsOf.class);

    private static Logger logger;
    private final Class<? extends ISManageable> clz;
    private final Class<? extends ISManageable> implementationClass;
    private final Class<? extends ISManageable> dummyImplementationClass;
    private final String name;
    private final String lowerCaseFirstCharacter;

    private <ISM extends ISManageable, ISMC extends ISM, ISMD extends ISMC> AccessType(Class<ISM> clz, String name, Class<ISMC> implementationClass, Class<ISMD> dummyImplementationClass) {
        this.clz = clz;
        this.implementationClass = implementationClass;
        this.dummyImplementationClass = dummyImplementationClass;
        this.name = name;
        this.lowerCaseFirstCharacter = name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public <ISM extends ISManageable> Class<ISM> getTypeClass() {
        return this.clz;
    }

    public <ISM extends ISManageable, ISMC extends ISM> Class<ISMC> getImplementationClass() {
        return this.implementationClass;
    }

    public <ISM extends ISManageable, ISMC extends ISM, ISMD extends ISMC> Class<ISMD> getDummyImplementationClass() {
        return this.dummyImplementationClass;
    }

    public String getName() {
        return this.name;
    }

    public String lowerCaseFirstCharacter() {
        return this.lowerCaseFirstCharacter;
    }

    public String toString() {
        return this.name;
    }

    public static AccessType getAccessType(Class<?> clz) {
        AccessType[] accessTypes;
        AccessType ret = null;
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class typeClass = accessType.getTypeClass();
            if (!typeClass.isAssignableFrom(clz) || ret != null && !ret.getTypeClass().isAssignableFrom(typeClass)) continue;
            ret = accessType;
        }
        if (ret != null) {
            return ret;
        }
        String error = String.format("The provided class %s does not belong to any of defined AccessTypes %s", clz.getSimpleName(), Arrays.toString((Object[])accessTypes));
        logger.trace(error);
        throw new RuntimeException(error);
    }

    static {
        logger = LoggerFactory.getLogger(AccessType.class);
    }
}

