/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.api;

import gr.forth.ics.isl.xsearch.api.processdocument;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class getsupportedcategories
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParserConfigurationException, TransformerConfigurationException {
        PrintWriter out = response.getWriter();
        String format = request.getParameter("format");
        if (format == null) {
            format = "";
        }
        if (!(format = format.trim()).equals("")) {
            if (!(format.toLowerCase().equals("json") || format.toLowerCase().equals("xml") || format.toLowerCase().equals("csv"))) {
                response.sendError(400, "The value of the parameter 'format' is not valid. Valid values: {json, xml, csv}.");
                return;
            }
        } else {
            format = "json";
        }
        try {
            if (format.toLowerCase().equals("csv")) {
                response.setContentType("text/plain;charset=UTF-8");
                out.println("\"CATEGORY_NAME\"\t\"SPARQL_ENDPOINT\"\t\"SPARQL_LINKING_TEMPLATE_QUERY\"");
                for (String category : Resources.MINING_ALL_POSSIBLE_CATEGORIES) {
                    String endpoint = (String)Resources.SPARQL_ENDPOINTS.get(category);
                    if (endpoint == null) {
                        endpoint = "-";
                    }
                    String templateQueryPath = (String)Resources.SPARQL_TEMPLATES.get(category);
                    String templateQuery = "";
                    if (templateQueryPath == null) {
                        templateQuery = "-";
                    } else {
                        templateQuery = Util.readSPARQLQuery((String)templateQueryPath);
                        templateQuery = Util.removeLinesAndMultipleSpaces((String)templateQuery);
                    }
                    out.println(category + "\t" + endpoint + "\t" + templateQuery);
                }
            } else if (format.toLowerCase().equals("xml")) {
                response.setContentType("application/xml;charset=UTF-8");
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("supportedCategories");
                doc.appendChild(rootElement);
                for (String category : Resources.MINING_ALL_POSSIBLE_CATEGORIES) {
                    String endpoint = (String)Resources.SPARQL_ENDPOINTS.get(category);
                    if (endpoint == null) {
                        endpoint = "";
                    }
                    String templateQueryPath = (String)Resources.SPARQL_TEMPLATES.get(category);
                    String templateQuery = "";
                    if (templateQueryPath == null) {
                        templateQuery = "";
                    } else {
                        templateQuery = Util.readSPARQLQuery((String)templateQueryPath);
                        templateQuery = Util.removeLinesAndMultipleSpaces((String)templateQuery);
                    }
                    Element cat = doc.createElement("category");
                    Element name = doc.createElement("categoryName");
                    name.appendChild(doc.createTextNode(category));
                    Element ep = doc.createElement("endpoint");
                    ep.appendChild(doc.createTextNode(endpoint));
                    Element tq = doc.createElement("templateQuery");
                    tq.appendChild(doc.createTextNode(templateQuery));
                    cat.appendChild(name);
                    cat.appendChild(ep);
                    cat.appendChild(tq);
                    rootElement.appendChild(cat);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(out);
                try {
                    transformer.transform(source, result);
                }
                catch (TransformerException ex) {
                    Logger.getLogger(processdocument.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                response.setContentType("application/json;charset=UTF-8");
                JSONObject json = new JSONObject();
                JSONArray categories = new JSONArray();
                for (String category : Resources.MINING_ALL_POSSIBLE_CATEGORIES) {
                    String endpoint = (String)Resources.SPARQL_ENDPOINTS.get(category);
                    if (endpoint == null) {
                        endpoint = "";
                    }
                    String templateQueryPath = (String)Resources.SPARQL_TEMPLATES.get(category);
                    String templateQuery = "";
                    if (templateQueryPath == null) {
                        templateQuery = "";
                    } else {
                        templateQuery = Util.readSPARQLQuery((String)templateQueryPath);
                        templateQuery = Util.removeLinesAndMultipleSpaces((String)templateQuery);
                    }
                    JSONObject result = new JSONObject();
                    result.put((Object)"categoryName", (Object)category);
                    result.put((Object)"endpoint", (Object)endpoint);
                    result.put((Object)"templateQuery", (Object)templateQuery);
                    categories.add((Object)result);
                }
                json.put((Object)"supportedCategories", (Object)categories);
                out.print(json);
                out.close();
            }
        }
        finally {
            out.close();
        }
        System.out.println("# GET SUPPORTED CATEGORIES - FINISHED!");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(getsupportedcategories.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(getsupportedcategories.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(getsupportedcategories.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(getsupportedcategories.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

