/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch;

import com.thoughtworks.xstream.XStream;
import gr.forth.ics.isl.stellaclustering.CLT_Creator;
import gr.forth.ics.isl.stellaclustering.util.TreeNode;
import gr.forth.ics.isl.textentitymining.Category;
import gr.forth.ics.isl.textentitymining.Entity;
import gr.forth.ics.isl.xsearch.AllResults;
import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.clustering.Clustering;
import gr.forth.ics.isl.xsearch.ecoscope.EcoscopeRetriever;
import gr.forth.ics.isl.xsearch.fao.FigisRetriever;
import gr.forth.ics.isl.xsearch.mining.Mining;
import gr.forth.ics.isl.xsearch.opensearch.DescriptionDocument;
import gr.forth.ics.isl.xsearch.opensearch.OpenSearchRetriever;
import gr.forth.ics.isl.xsearch.pagesretriever.PagesRetriever;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import gr.forth.ics.isl.xsearch.util.MD5;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Bean_Search {
    private String query;
    private boolean only_snippets;
    private ArrayList<SearchResult> wseResults;
    private ArrayList<Category> entities;
    private String results_first_page;
    private String statistics;
    private int max_num_of_results_from_wse;
    private String clustersContent;
    private int numOfClusters;
    private boolean clustering;
    private boolean mining;
    private String exampleQuery;
    private String jsonResults;
    private String jsonMiningResults;
    private String jsonClusteringResults;
    private Clustering clusteringComponent;

    public Bean_Search(boolean only_snippets, int max_num_of_results_from_wse) {
        this.only_snippets = only_snippets;
        this.max_num_of_results_from_wse = max_num_of_results_from_wse;
        this.wseResults = new ArrayList();
        this.entities = new ArrayList();
        this.results_first_page = "";
    }

    public Bean_Search(String query, int max_num_of_results_from_wse, boolean clustering, int numOfClusters, boolean mining, boolean only_snippets, String descrDoc, int clusteringAlgorithm, boolean mineQuery, HashSet<String> acceptedCategories, HashMap<String, String> endpoints, HashMap<String, String> templateQueries) throws MalformedURLException, FileNotFoundException, UnsupportedEncodingException, IOException {
        long end;
        EcoscopeRetriever retriever;
        String[] mapping;
        String pair;
        int j;
        String[] pairs;
        String parametersString;
        HashMap<String, String> parameters;
        this.statistics = "";
        this.exampleQuery = "";
        System.out.println("--------");
        System.out.println("# Initializing query parameters...");
        this.query = query;
        System.out.println("=> Query: " + query);
        this.statistics = this.statistics + "=> Query: " + query + "\n";
        this.max_num_of_results_from_wse = max_num_of_results_from_wse;
        System.out.println("=> Number of results to mine/cluster: " + max_num_of_results_from_wse);
        this.statistics = this.statistics + "=> Number of results to mine/cluster: " + max_num_of_results_from_wse + "\n";
        this.mining = mining;
        System.out.println("=> Do mining: " + mining);
        this.statistics = this.statistics + "=> Do mining: " + mining + "\n";
        this.clustering = clustering;
        System.out.println("=> Do clustering: " + clustering);
        this.statistics = this.statistics + "=> Do clustering: " + clustering + "\n";
        this.numOfClusters = numOfClusters;
        System.out.println("=> Number of desired clusters: " + numOfClusters);
        this.statistics = this.statistics + "=> Number of desired clusters: " + numOfClusters + "\n";
        this.only_snippets = only_snippets;
        System.out.println("=> Do only snippets: " + only_snippets);
        this.statistics = this.statistics + "=> Do only snippets: " + only_snippets + "\n";
        long start = System.currentTimeMillis();
        if (descrDoc.toLowerCase().startsWith("figis")) {
            parameters = new HashMap<String, String>();
            int ind = descrDoc.indexOf("?");
            if (ind == -1) {
                parameters.put("owner", "fi");
                parameters.put("xml", "y");
                parameters.put("xml_no_subject", "");
                parameters.put("FORM_C", "AND");
                parameters.put("sortorder", "3");
                parameters.put("pub_year", "2011");
            } else {
                parametersString = descrDoc.substring(ind + 1);
                System.out.println("# Parameters string: " + parametersString);
                pairs = parametersString.split("&");
                for (j = 0; j < pairs.length; ++j) {
                    pair = pairs[j];
                    mapping = pair.split("=");
                    if (mapping.length == 2) {
                        parameters.put(mapping[0], mapping[1]);
                    }
                    if (mapping.length != 1) continue;
                    parameters.put(mapping[0], "");
                }
                System.out.println("# Parameters: " + parameters);
            }
            retriever = new FigisRetriever(query, max_num_of_results_from_wse);
            retriever.setParameters(parameters);
            retriever.retrieveResults();
            this.wseResults = retriever.getResults();
        } else if (descrDoc.toLowerCase().startsWith("ecoscope")) {
            parameters = new HashMap();
            int ind = descrDoc.indexOf("?");
            if (ind != -1) {
                parametersString = descrDoc.substring(ind + 1);
                System.out.println("# Parameters string: " + parametersString);
                pairs = parametersString.split("&");
                for (j = 0; j < pairs.length; ++j) {
                    pair = pairs[j];
                    mapping = pair.split("=");
                    if (mapping.length == 2) {
                        parameters.put(mapping[0], mapping[1]);
                    }
                    if (mapping.length != 1) continue;
                    parameters.put(mapping[0], "");
                }
                System.out.println("# Parameters: " + parameters);
            }
            retriever = new EcoscopeRetriever(query, max_num_of_results_from_wse);
            retriever.setParameters(parameters);
            retriever.retrieveResults();
            this.wseResults = retriever.getResults();
        } else {
            String template;
            DescriptionDocument descrDocument = new DescriptionDocument(descrDoc);
            System.out.println("# OpenSearch Provider: " + descrDocument.getShortName() + " (" + descrDocument.getDescription() + ")");
            HashMap urlTemplates = descrDocument.getUrlTemplates();
            this.exampleQuery = descrDocument.getExampleQuery();
            end = System.currentTimeMillis() - start;
            System.out.println("# Reading OpenSearch description document in: " + end + " ms.");
            this.statistics = this.statistics + "# Reading OpenSearch description document in: " + end + " ms.\n";
            start = System.currentTimeMillis();
            this.wseResults = new ArrayList();
            retriever = null;
            if (urlTemplates.containsKey("application/rss+xml")) {
                template = (String)urlTemplates.get("application/rss+xml");
                System.out.println("# Using 'application/rss+xml' template: " + template);
                retriever = new OpenSearchRetriever(template, "application/rss+xml", query);
            } else if (urlTemplates.containsKey("application/atom+xml")) {
                template = (String)urlTemplates.get("application/atom+xml");
                System.out.println("# Using 'application/atom+xml' template: " + template);
                retriever = new OpenSearchRetriever(template, "application/atom+xml", query);
            } else {
                System.out.println("# NO SUPPORTED TEMPLATE TYPES: " + urlTemplates.keySet().toString());
            }
            if (retriever != null) {
                retriever.setDesiredNumber(max_num_of_results_from_wse);
                retriever.retrieveResults();
                this.wseResults = retriever.getResults();
            }
        }
        for (int i = 0; i < this.wseResults.size(); ++i) {
            ((SearchResult)this.wseResults.get(i)).setRank(i + 1);
        }
        System.out.println("=> Number of retrieved results: " + this.wseResults.size());
        this.statistics = this.statistics + "=> Number of retrieved results: " + this.wseResults.size() + "\n";
        end = System.currentTimeMillis() - start;
        System.out.println("# Retrieving results from search engine in: " + end + " ms.");
        this.statistics = this.statistics + "# Retrieving results from search engine in: " + end + " ms.\n";
        if (!only_snippets) {
            start = System.currentTimeMillis();
            PagesRetriever pageRetriever = new PagesRetriever(this.wseResults, max_num_of_results_from_wse);
            this.wseResults = pageRetriever.getWseResults();
            end = System.currentTimeMillis() - start;
            System.out.println("# Retrieving content of all results in: " + end + " ms.");
            this.statistics = this.statistics + "# Retrieving content of all results in: " + end + " ms.\n";
        }
        if (clustering) {
            start = System.currentTimeMillis();
            Clustering clusteringComp = new Clustering(this.wseResults, query, only_snippets, numOfClusters, clusteringAlgorithm);
            this.clustersContent = clusteringComp.getClustersContent();
            end = System.currentTimeMillis() - start;
            System.out.println("# Clustering results in: " + end + " ms.");
            this.statistics = this.statistics + "# Clustering results in: " + end + " ms.\n";
        }
        if (mining) {
            System.out.println("# Finding entities in results...");
            start = System.currentTimeMillis();
            Mining miningComp = new Mining(this.wseResults, query, acceptedCategories, endpoints, templateQueries);
            end = System.currentTimeMillis() - start;
            System.out.println("# Finding entities in: " + end + " ms.");
            this.statistics = this.statistics + "# Finding entities in: " + end + " ms.\n";
            if (mineQuery) {
                start = System.currentTimeMillis();
                System.out.println("# Mining query...");
                miningComp.mineQuery();
                end = System.currentTimeMillis() - start;
                System.out.println("# Mining query in: " + end + " ms.");
                this.statistics = this.statistics + "# Mining query in: " + end + " ms.\n";
            }
            start = System.currentTimeMillis();
            miningComp.giveRankToElements(max_num_of_results_from_wse);
            end = System.currentTimeMillis() - start;
            System.out.println("# Giving score to elements in: " + end + " ms.");
            this.statistics = this.statistics + "# Giving score to elements in: " + end + " ms.\n";
            start = System.currentTimeMillis();
            miningComp.createEntitiesHTMLFormat();
            end = System.currentTimeMillis() - start;
            this.statistics = this.statistics + miningComp.getStatistics();
            System.out.println("# Creating string representations of all entities in: " + end + " ms.");
            this.statistics = this.statistics + "# Creating string representations of all entities in: " + end + " ms.\n";
            this.entities = miningComp.getEntities();
            start = System.currentTimeMillis();
            Collections.sort(this.entities);
            end = System.currentTimeMillis() - start;
            System.out.println("# Sorting entities and elements in: " + end + " ms.");
            this.statistics = this.statistics + "# Sorting entities and elements in: " + end + " ms.\n";
        }
        start = System.currentTimeMillis();
        this.createResultsPage();
        end = System.currentTimeMillis() - start;
        System.out.println("# Creating string of first page of results in: " + end + " ms.");
        this.statistics = this.statistics + "# Creating string of first page of results in: " + end + " ms.\n";
        if (!only_snippets) {
            try {
                AllResults all = new AllResults(query.trim(), this.statistics, this.results_first_page, this.entities);
                String md5 = MD5.getMD5((String)query.trim());
                String file = Resources.MINING_RESULTS + md5 + ".em";
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                out.writeObject(all);
                out.flush();
                out.close();
                System.out.println("=> File " + file + " succesfully saved.");
            }
            catch (IOException ex) {
                IOSLog.writeErrorToLog((Exception)ex, (String)"Bean_Search");
                System.out.println("*** ERROR TRYING TO SAVE THA FILE.");
            }
        }
    }

    public Map<String, String> createJsonObjects(Clustering clusteringComp, ArrayList<Category> categories) {
        System.out.println("------------Clustering----------------");
        XStream xstreamCluster = new XStream();
        xstreamCluster.alias("TreeNode", TreeNode.class);
        xstreamCluster.alias("DefaultMutableTreeNode", DefaultMutableTreeNode.class);
        String clusterignXML = "";
        if (clusteringComp == null) {
            clusterignXML = xstreamCluster.toXML((Object)clusteringComp.getClusterer().getClusterTree());
        } else {
            System.out.println("Attention the clustering object (cluseringComp) is null!!!");
        }
        System.out.println("Clustering results in xml format: " + clusterignXML);
        System.out.println("-----------Mining---------------------");
        XStream xstream = new XStream();
        xstream.alias("Category", Category.class);
        xstream.alias("Entity", Entity.class);
        xstream.aliasField("entities", Category.class, "Entities");
        xstream.aliasField("id", Entity.class, "int");
        String miningXML = xstream.toXML(categories);
        System.out.println("Entity mining results in xml format: \n" + miningXML);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("clusterignXML", clusterignXML);
        map.put("miningXML", miningXML);
        return map;
    }

    public Bean_Search(String results) {
        this.results_first_page = results;
        this.wseResults = new ArrayList();
        int num = 0;
        HTMLTag tagger = new HTMLTag(results);
        int i = tagger.getFirstTagIndex("div");
        while (i != -1) {
            String div_data = tagger.getFirstTagData("div", i - 1);
            HTMLTag tagger2 = new HTMLTag(div_data);
            String title = tagger2.getFirstTagDataContains("span", "one_result_title");
            title = HTMLTag.removeTags((String)title).trim();
            String descr = tagger2.getFirstTagDataContains("span", "one_result_descr");
            if (descr == null) {
                descr = "";
            }
            descr = HTMLTag.removeTags((String)descr).trim();
            String url = tagger2.getFirstTagDataContains("span", "one_result_url");
            url = HTMLTag.removeTags((String)url).trim();
            SearchResult result = new SearchResult(title, url, descr, num);
            this.wseResults.add(result);
            ++num;
            i = tagger.getFirstTagIndex("div", i + 2);
        }
    }

    public Bean_Search(String query, int resultsStartOffset, boolean clustering, int numOfClusters, boolean mining, boolean only_snippets, String locator) throws GRS2ReaderException, URISyntaxException, GRS2BufferException, GRS2RecordDefinitionException {
        System.out.println("===========================");
        System.out.println("# Initializing query parameters...");
        this.query = query;
        System.out.println("=> Query: " + query);
        this.statistics = this.statistics + "=> Query: " + query + "\n";
        this.mining = mining;
        System.out.println("=> Do mining: " + mining);
        this.statistics = this.statistics + "=> Do mining: " + mining + "\n";
        this.clustering = clustering;
        System.out.println("=> Do clustering: " + clustering);
        this.statistics = this.statistics + "=> Do clustering: " + clustering + "\n";
        this.numOfClusters = numOfClusters;
        System.out.println("=> Number of desired clusters: " + numOfClusters);
        this.statistics = this.statistics + "=> Number of desired clusters: " + numOfClusters + "\n";
        this.only_snippets = only_snippets;
        System.out.println("=> Do only snippets: " + only_snippets);
        this.statistics = this.statistics + "=> Do only snippets: " + only_snippets + "\n";
        System.out.println("=> StartOffset is: " + resultsStartOffset);
        System.out.println("=> Locator: " + locator);
        long start = System.currentTimeMillis();
        this.wseResults = new ArrayList();
        System.out.println("\n# Start reading the result set...");
        System.out.println("  - Locator: " + locator);
        URI locURI = new URI(locator);
        ForwardReader reader = new ForwardReader(locURI);
        int numOfRecords = 0;
        for (GenericRecord rec : reader) {
            String title = "";
            String snippet = "";
            String url = "";
            if (rec != null) {
                if ((StringField)rec.getField("title") != null) {
                    title = ((StringField)rec.getField("title")).getPayload();
                }
                if ((StringField)rec.getField("snippet") != null) {
                    snippet = ((StringField)rec.getField("snippet")).getPayload();
                }
                url = "";
            } else {
                System.out.println("  - Attention the record " + numOfRecords + " is null!!");
            }
            SearchResult searchresult = new SearchResult(title, url, snippet, numOfRecords);
            this.wseResults.add(searchresult);
            ++numOfRecords;
        }
        reader.close();
        System.out.println("  - Total Number of Records in the Result Set: " + numOfRecords);
        long end = System.currentTimeMillis() - start;
        System.out.println("# Reading the result set in: " + end + " ms.");
        if (clustering) {
            start = System.currentTimeMillis();
            Clustering clusteringComp = new Clustering(this.wseResults, query, only_snippets, numOfClusters, Resources.CLUSTERING_ALGORITHM);
            this.clustersContent = clusteringComp.getClustersContent();
            this.jsonClusteringResults = this.createClusterJsonString(query, clusteringComp.getClusterer(), resultsStartOffset);
            end = System.currentTimeMillis() - start;
            System.out.println("# Clustering results in: " + end + " ms.");
            this.statistics = this.statistics + "# Clustering results in: " + end + " ms.\n";
        }
        if (mining) {
            System.out.println("# Finding entities in results...");
            start = System.currentTimeMillis();
            Mining miningComp = new Mining(this.wseResults, query, Resources.MINING_ACCEPTED_CATEGORIES, Resources.SPARQL_ENDPOINTS, Resources.SPARQL_TEMPLATES);
            end = System.currentTimeMillis() - start;
            System.out.println("# Finding entities in: " + end + " ms.");
            this.statistics = this.statistics + "# Finding entities in: " + end + " ms.\n";
            if (Resources.MINE_QUERY) {
                start = System.currentTimeMillis();
                System.out.println("# Mining query...");
                miningComp.mineQuery();
                end = System.currentTimeMillis() - start;
                System.out.println("# Mining query in: " + end + " ms.");
                this.statistics = this.statistics + "# Mining query in: " + end + " ms.\n";
            }
            start = System.currentTimeMillis();
            miningComp.giveRankToElements(this.max_num_of_results_from_wse);
            end = System.currentTimeMillis() - start;
            System.out.println("# Giving score to elements in: " + end + " ms.");
            this.statistics = this.statistics + "# Giving score to elements in: " + end + " ms.\n";
            this.entities = miningComp.getEntities();
            start = System.currentTimeMillis();
            Collections.sort(this.entities);
            end = System.currentTimeMillis() - start;
            System.out.println("# Sorting entities and elements in: " + end + " ms.");
            this.statistics = this.statistics + "# Sorting entities and elements in: " + end + " ms.\n";
            start = System.currentTimeMillis();
            System.out.println("# Creating the JSON mining String...");
            this.jsonMiningResults = this.createMiningJSONString(this.entities, query, resultsStartOffset);
            end = System.currentTimeMillis() - start;
            System.out.println("# Creating the JSON mining String: " + end + " ms.");
        }
        this.jsonResults = clustering && mining ? "{ \"MiningResults\":" + this.jsonMiningResults + ", \"ClusteringResults\":" + this.jsonClusteringResults + "}" : (clustering && !mining ? "{ \"MiningResults\":{}, \"ClusteringResults\":" + this.jsonClusteringResults + "}" : (!clustering && mining ? "{ \"MiningResults\":" + this.jsonMiningResults + ", \"ClusteringResults\":{}}" : "{}"));
    }

    public Bean_Search(String searchSystem, String query, String descrDoc, String locator, int numOfResults, boolean mining, HashSet<String> categories, boolean clustering, int numOfClusters, String clusteringAlg, String typeOfResuls) throws GRS2RecordDefinitionException, GRS2RecordDefinitionException, GRS2BufferException, GRS2ReaderException, MalformedURLException, FileNotFoundException, UnsupportedEncodingException, IOException, URISyntaxException {
        long end;
        EcoscopeRetriever retriever;
        HashMap<String, String> parameters;
        this.statistics = "";
        this.exampleQuery = "";
        this.query = query;
        System.out.println("=> Query: " + query);
        this.max_num_of_results_from_wse = numOfResults;
        System.out.println("=> Number of results to mine/cluster: " + this.max_num_of_results_from_wse);
        this.mining = mining;
        System.out.println("=> Do mining: " + mining);
        this.clustering = clustering;
        System.out.println("=> Do clustering: " + clustering);
        this.numOfClusters = numOfClusters;
        System.out.println("=> Number of desired clusters: " + numOfClusters);
        this.statistics = this.statistics + "=> Number of desired clusters: " + numOfClusters + "\n";
        this.only_snippets = !typeOfResuls.equals("contents");
        System.out.println("=> Do only snippets: " + this.only_snippets);
        long start = System.currentTimeMillis();
        if (searchSystem.toLowerCase().equals("figis")) {
            parameters = new HashMap<String, String>();
            parameters.put("owner", "fi");
            parameters.put("xml", "y");
            parameters.put("xml_no_subject", "");
            parameters.put("FORM_C", "AND");
            parameters.put("sortorder", "3");
            parameters.put("pub_year", "2011");
            retriever = new FigisRetriever(query, this.max_num_of_results_from_wse);
            retriever.setParameters(parameters);
            retriever.retrieveResults();
            this.wseResults = retriever.getResults();
        } else if (searchSystem.toLowerCase().equals("ecoscope")) {
            parameters = new HashMap();
            retriever = new EcoscopeRetriever(query, this.max_num_of_results_from_wse);
            retriever.setParameters(parameters);
            retriever.retrieveResults();
            this.wseResults = retriever.getResults();
        } else if (searchSystem.toLowerCase().equals("gcube")) {
            start = System.currentTimeMillis();
            this.wseResults = new ArrayList();
            System.out.println("\n# Start reading the result set...");
            System.out.println("  - Locator: " + locator);
            URI locURI = new URI(locator);
            ForwardReader reader = new ForwardReader(locURI);
            int numOfRecords = 0;
            for (GenericRecord rec : reader) {
                String title = "";
                String snippet = "";
                String url = "";
                if (rec != null) {
                    if ((StringField)rec.getField("title") != null) {
                        title = ((StringField)rec.getField("title")).getPayload();
                    }
                    if ((StringField)rec.getField("snippet") != null) {
                        snippet = ((StringField)rec.getField("snippet")).getPayload();
                    }
                    url = "";
                } else {
                    System.out.println("  - Attention the record " + numOfRecords + " is null!!");
                }
                SearchResult searchresult = new SearchResult(title, url, snippet, numOfRecords);
                this.wseResults.add(searchresult);
                ++numOfRecords;
            }
            reader.close();
            System.out.println("  - Total Number of Records in the Result Set: " + numOfRecords);
            end = System.currentTimeMillis() - start;
            System.out.println("# Reading the result set in: " + end + " ms.");
        } else {
            String template;
            DescriptionDocument descrDocument = new DescriptionDocument(descrDoc);
            System.out.println("# OpenSearch Provider: " + descrDocument.getShortName() + " (" + descrDocument.getDescription() + ")");
            HashMap urlTemplates = descrDocument.getUrlTemplates();
            end = System.currentTimeMillis() - start;
            System.out.println("# Reading OpenSearch description document in: " + end + " ms.");
            start = System.currentTimeMillis();
            this.wseResults = new ArrayList();
            OpenSearchRetriever retriever2 = null;
            if (urlTemplates.containsKey("application/rss+xml")) {
                template = (String)urlTemplates.get("application/rss+xml");
                System.out.println("# Using 'application/rss+xml' template: " + template);
                retriever2 = new OpenSearchRetriever(template, "application/rss+xml", query);
            } else if (urlTemplates.containsKey("application/atom+xml")) {
                template = (String)urlTemplates.get("application/atom+xml");
                System.out.println("# Using 'application/atom+xml' template: " + template);
                retriever2 = new OpenSearchRetriever(template, "application/atom+xml", query);
            } else {
                System.out.println("# NO SUPPORTED TEMPLATE TYPES: " + urlTemplates.keySet().toString());
            }
            if (retriever2 != null) {
                retriever2.setDesiredNumber(this.max_num_of_results_from_wse);
                retriever2.retrieveResults();
                this.wseResults = retriever2.getResults();
            }
        }
        for (int i = 0; i < this.wseResults.size(); ++i) {
            ((SearchResult)this.wseResults.get(i)).setRank(i + 1);
        }
        System.out.println("=> Number of retrieved results: " + this.wseResults.size());
        end = System.currentTimeMillis() - start;
        System.out.println("# Retrieving results from search engine in: " + end + " ms.");
        if (!this.only_snippets) {
            start = System.currentTimeMillis();
            PagesRetriever pageRetriever = new PagesRetriever(this.wseResults, this.max_num_of_results_from_wse);
            this.wseResults = pageRetriever.getWseResults();
            end = System.currentTimeMillis() - start;
            System.out.println("# Retrieving content of all results in: " + end + " ms.");
        }
        if (clustering) {
            start = System.currentTimeMillis();
            int clusteringAlgorithm = 3;
            if (clusteringAlg.equals("cl1")) {
                clusteringAlgorithm = 1;
            }
            if (clusteringAlg.equals("cl2")) {
                clusteringAlgorithm = 2;
            }
            if (clusteringAlg.equals("cl4")) {
                clusteringAlgorithm = 4;
            }
            if (clusteringAlg.equals("cl5")) {
                clusteringAlgorithm = 5;
            }
            this.clusteringComponent = new Clustering(this.wseResults, query, this.only_snippets, numOfClusters, clusteringAlgorithm);
            end = System.currentTimeMillis() - start;
            System.out.println("# Clustering results in: " + end + " ms.");
        }
        if (mining) {
            System.out.println("# Finding entities in results...");
            start = System.currentTimeMillis();
            Mining miningComp = new Mining(this.wseResults, query, categories, Resources.SPARQL_ENDPOINTS, Resources.SPARQL_TEMPLATES);
            end = System.currentTimeMillis() - start;
            System.out.println("# Finding entities in: " + end + " ms.");
            start = System.currentTimeMillis();
            miningComp.giveRankToElements(this.max_num_of_results_from_wse);
            end = System.currentTimeMillis() - start;
            System.out.println("# Giving score to elements in: " + end + " ms.");
            this.entities = miningComp.getEntities();
            start = System.currentTimeMillis();
            Collections.sort(this.entities);
            end = System.currentTimeMillis() - start;
            System.out.println("# Sorting entities and elements in: " + end + " ms.");
        }
    }

    private void createResultsPage() {
        this.results_first_page = "";
        if (this.wseResults.isEmpty()) {
            this.results_first_page = this.results_first_page + "<h1>Sorry, no results! Try something else!</h1>";
            if (!this.exampleQuery.equals("")) {
                this.results_first_page = this.results_first_page + "Example query: <i><a onClick='document.getElementById(\"suggestion\").value = \"" + this.exampleQuery + "\"' href='Servlet_Search?query=" + this.exampleQuery + "&start=0&n=50&type=onlySnippets&mining=true&clustering=true&clnum=15'>" + this.exampleQuery + "</a></i>";
            }
        } else {
            for (int i = 0; i < this.wseResults.size(); ++i) {
                SearchResult one = (SearchResult)this.wseResults.get(i);
                String title = one.getTitle();
                String url = one.getUrl();
                String description = one.getDescription();
                String titleToShow = title;
                String hiddenTitle = "";
                String idTitle = "resultTitle" + i;
                String showTitleId = "resultShowTitle" + i;
                String script1 = "javascript:showAllText('" + idTitle + "', '" + showTitleId + "');";
                String showAllText = "";
                if (title.length() > 124) {
                    hiddenTitle = "<span id=\"" + idTitle + "\" style=\"display:none\">" + title.substring(124) + "</span>";
                    titleToShow = title.substring(0, 124) + hiddenTitle;
                    showAllText = "<span id=\"" + showTitleId + "\"><a href=\"" + script1 + "\" class=\"em_show_name_a\">...show all</a></span>";
                }
                String descrToShow = description;
                String hiddenDescr = "";
                String idDescr = "resultDescr" + i;
                String showDescrId = "resultShowDescr" + i;
                String script2 = "javascript:showAllText('" + idDescr + "', '" + showDescrId + "');";
                if (description.length() > 330) {
                    hiddenDescr = "<span id=\"" + idDescr + "\" style=\"display:none\">" + description.substring(328) + "</span>";
                    descrToShow = description.substring(0, 328) + "<span id=\"" + showDescrId + "\" align=\"right\" class=\"em_showAllText\"><a href=\"" + script2 + "\" class=\"em_show_name_a\">...show all</a></span>" + hiddenDescr;
                }
                this.results_first_page = url.toLowerCase().startsWith("http") || url.toLowerCase().startsWith("ftp") ? this.results_first_page + "<div class='one_result'><span class='one_result_title'><a href='Servlet_OpenResult?doc=" + i + "&doc_url=" + url + "'>" + titleToShow + "</a></span>" + showAllText : this.results_first_page + "<div class='one_result'><span class='one_result_title'>" + titleToShow + "</span>" + showAllText;
                if (!descrToShow.trim().equals("")) {
                    this.results_first_page = this.results_first_page + "<br />";
                    this.results_first_page = this.results_first_page + "<span class='one_result_descr'>" + descrToShow + "</span>";
                }
                this.results_first_page = this.results_first_page + "<br />";
                this.results_first_page = this.results_first_page + "<span class='em_url'>" + url.replace("#", "-") + "</span>";
                if (!(!url.toLowerCase().startsWith("http") && !url.toLowerCase().startsWith("ftp") || url.toLowerCase().endsWith(".jpg") || url.toLowerCase().endsWith(".png") || url.toLowerCase().endsWith(".gif") || url.toLowerCase().endsWith(".jpeg"))) {
                    this.results_first_page = this.results_first_page + " - <font><a class='em_minepage' href=javascript:minePage(" + i + ")>find its entities</a></font>";
                }
                if (url.toLowerCase().endsWith(".jpg") || url.toLowerCase().endsWith(".png") || url.toLowerCase().endsWith(".gif") || url.toLowerCase().endsWith(".jpeg")) {
                    this.results_first_page = this.results_first_page + "<br /><img  border='0' src='" + url + "' class='imgOfDesc' />";
                }
                this.results_first_page = this.results_first_page + "</div><br />";
            }
        }
        this.results_first_page = this.results_first_page.replace("\n", " ").replace("\r", " ").replace("\t", " ");
    }

    private String createMiningJSONString(ArrayList<Category> categories, String query, int resultsStartOffset) {
        JSONArray jsonCategories = new JSONArray();
        for (int i = 0; i < categories.size(); ++i) {
            JSONArray jsonEntitiesArray = new JSONArray();
            JSONObject jsonCategory = new JSONObject();
            for (int j = 0; j < categories.get(i).getEntities().size(); ++j) {
                JSONObject jsonEntity = new JSONObject();
                jsonEntity.put((Object)"EntityName", (Object)((Entity)categories.get(i).getEntities().get(j)).getName());
                JSONArray jsonDocArray = new JSONArray();
                for (int k = 0; k < ((Entity)categories.get(i).getEntities().get(j)).getDocIds().size(); ++k) {
                    jsonDocArray.add((Object)((Integer)((Entity)categories.get(i).getEntities().get(j)).getDocIds().get(k) + resultsStartOffset));
                }
                jsonEntity.put((Object)"DocList", (Object)jsonDocArray);
                jsonEntity.put((Object)"Rank", (Object)((Entity)categories.get(i).getEntities().get(j)).getRank());
                jsonEntitiesArray.add((Object)jsonEntity);
            }
            jsonCategory.put((Object)"Entities", (Object)jsonEntitiesArray);
            jsonCategory.put((Object)"CategoryName", (Object)categories.get(i).getName());
            jsonCategory.put((Object)"NumOfDiffDocs", (Object)categories.get(i).getNum_of_different_docs());
            jsonCategory.put((Object)"Rank", (Object)categories.get(i).getRank());
            jsonCategories.add((Object)jsonCategory);
        }
        JSONObject MinedCategories = new JSONObject();
        MinedCategories.put((Object)"MinedCategories", (Object)jsonCategories);
        MinedCategories.put((Object)"Query", (Object)query);
        StringWriter out = new StringWriter();
        try {
            MinedCategories.writeJSONString((Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String jsonText = out.toString();
        return jsonText;
    }

    private String createClusterJsonString(String query, CLT_Creator clt, int resultsStartOffset) {
        JSONArray jsonClustersArray = new JSONArray();
        Enumeration enumer = clt.getClusterTree().preorderEnumeration();
        while (enumer.hasMoreElements()) {
            TreeNode node = (TreeNode)enumer.nextElement();
            if (node.getLevel() > 1) continue;
            JSONObject jsonCluster = new JSONObject();
            jsonCluster.put((Object)"ClusterName", (Object)node.getTitle());
            JSONArray jsonDocArray = new JSONArray();
            for (int i = 0; i < node.getDocumentsList().size(); ++i) {
                jsonDocArray.add((Object)((Integer)node.getDocumentsList().get(i) + resultsStartOffset));
            }
            jsonCluster.put((Object)"DocList", (Object)jsonDocArray);
            jsonClustersArray.add((Object)jsonCluster);
        }
        System.out.println();
        JSONObject clusters = new JSONObject();
        clusters.put((Object)"Clusters", (Object)jsonClustersArray);
        clusters.put((Object)"Query", (Object)query);
        StringWriter out = new StringWriter();
        try {
            clusters.writeJSONString((Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String jsonText = out.toString();
        return jsonText;
    }

    public void printClusterTreeRecursive(TreeNode subTree, int spaces) throws Exception {
        if (subTree == null) {
            throw new NullPointerException("The tree is empty.");
        }
        for (int i = 0; i < spaces; ++i) {
            System.out.print("  ");
        }
        Enumeration en = subTree.breadthFirstEnumeration();
        TreeNode enNode = (TreeNode)en.nextElement();
        System.out.print(" *Title: \"" + enNode.getTitle() + "\" Id=" + enNode.getId());
        System.out.println(".Files:" + enNode.getUserObject());
        en = subTree.children();
        while (en.hasMoreElements()) {
            TreeNode leftChild = (TreeNode)en.nextElement();
            this.printClusterTreeRecursive(leftChild, spaces + 2);
        }
    }

    public boolean isOnly_snippets() {
        return this.only_snippets;
    }

    public void setOnly_snippets(boolean only_snippets) {
        this.only_snippets = only_snippets;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getResults_first_page() {
        return this.results_first_page;
    }

    public void setResults_first_page(String results_first_page) {
        this.results_first_page = results_first_page;
    }

    public int getMax_num_of_results_from_wse() {
        return this.max_num_of_results_from_wse;
    }

    public void setMax_num_of_results_from_wse(int max_num_of_results_from_wse) {
        this.max_num_of_results_from_wse = max_num_of_results_from_wse;
    }

    public String getClustersContent() {
        return this.clustersContent;
    }

    public void setClustersContent(String clustersContent) {
        this.clustersContent = clustersContent;
    }

    public int getNumOfClusters() {
        return this.numOfClusters;
    }

    public void setNumOfClusters(int numOfClusters) {
        this.numOfClusters = numOfClusters;
    }

    public boolean isClustering() {
        return this.clustering;
    }

    public void setClustering(boolean clustering) {
        this.clustering = clustering;
    }

    public boolean isMining() {
        return this.mining;
    }

    public void setMining(boolean mining) {
        this.mining = mining;
    }

    public ArrayList<Category> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<Category> entities) {
        this.entities = entities;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public String getExampleQuery() {
        return this.exampleQuery;
    }

    public void setExampleQuery(String exampleQuery) {
        this.exampleQuery = exampleQuery;
    }

    public ArrayList<SearchResult> getWseResults() {
        return this.wseResults;
    }

    public void setWseResults(ArrayList<SearchResult> wseResults) {
        this.wseResults = wseResults;
    }

    public String getJsonClusteringResults() {
        return this.jsonClusteringResults;
    }

    public void setJsonClusteringResults(String jsonClusteringResults) {
        this.jsonClusteringResults = jsonClusteringResults;
    }

    public String getJsonMiningResults() {
        return this.jsonMiningResults;
    }

    public void setJsonMiningResults(String jsonMiningResults) {
        this.jsonMiningResults = jsonMiningResults;
    }

    public String getJsonResults() {
        return this.jsonResults;
    }

    public void setJsonResults(String jsonResults) {
        this.jsonResults = jsonResults;
    }

    public Clustering getClusteringComponent() {
        return this.clusteringComponent;
    }

    public void setClusteringComponent(Clustering clusteringComponent) {
        this.clusteringComponent = clusteringComponent;
    }
}

