/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.api;

import gr.forth.ics.isl.xsearch.api.processdocument;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import gr.forth.ics.isl.xsearch.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class link
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ParserConfigurationException, TransformerConfigurationException {
        String entityName = request.getParameter("name");
        if (entityName == null) {
            entityName = "";
        }
        if ((entityName = entityName.trim()).equals("")) {
            response.sendError(400, "The value of the parameter 'name' is null or empty.");
            return;
        }
        String categoryName = request.getParameter("category");
        if (categoryName == null) {
            categoryName = "";
        }
        if ((categoryName = categoryName.trim()).trim().equals("")) {
            response.sendError(400, "The value of the parameter 'category' is null or empty.");
            return;
        }
        if (!Resources.MINING_ALL_POSSIBLE_CATEGORIES.contains(categoryName)) {
            response.sendError(400, "The category '" + categoryName + "' is not supported by X-Search.");
            return;
        }
        String endpoint = request.getParameter("endpoint");
        if (endpoint == null) {
            endpoint = "";
        }
        endpoint = endpoint.trim();
        String tquery = request.getParameter("tquery");
        if (tquery == null) {
            tquery = "";
        }
        tquery = tquery.trim();
        if (endpoint.equals("") && !tquery.equals("") || !endpoint.equals("") && tquery.equals("")) {
            response.sendError(400, "The value of the parameter 'endpoint' or of the parameter 'tquery' is null or empty.");
            return;
        }
        if (!tquery.equals("") && !tquery.toLowerCase().contains("<entity>")) {
            response.sendError(400, "The SPARQL template query must contain the template parameter <ENTITY>.");
            return;
        }
        String format = request.getParameter("format");
        if (format == null) {
            format = "";
        }
        if (!(format = format.trim()).equals("")) {
            if (!(format.toLowerCase().equals("json") || format.toLowerCase().equals("xml") || format.toLowerCase().equals("csv"))) {
                response.sendError(400, "The value of the parameter 'format' is not valid. Valid values: {json, xml, csv}.");
                return;
            }
        } else {
            format = "json";
        }
        if (endpoint.equals("")) {
            endpoint = (String)Resources.SPARQL_ENDPOINTS.get(categoryName);
            if (endpoint == null) {
                endpoint = "";
            }
            if ((endpoint = endpoint.trim()).equals("")) {
                System.out.println("# NO 'SPARQL ENDPOINT' IN THE CURRENT CONFIGURATION!");
                response.sendError(400, "The current configuration of X-Search does not provide a SPARQL endpoint for the category '" + categoryName + "'. Please provide a SPARQL endpoint (&endpoint=...) and a SPARQL template query (&tquery=...).");
                return;
            }
        }
        System.out.println("# Endpoint = " + endpoint);
        if (tquery.equals("")) {
            tquery = (String)Resources.SPARQL_TEMPLATES.get(categoryName);
            if (tquery == null) {
                tquery = "";
            }
            if ((tquery = tquery.trim()).equals("")) {
                System.out.println("# NO 'TEMPLATE QUERY' IN THE CURRENT CONFIGURATION!");
                response.sendError(400, "The current configuration of X-Search does not provide a SPARQL template query for the category '" + categoryName + "'. Please provide a SPARQL endpoint (&endpoint=...) and a SPARQL template query (&tquery=...).");
                return;
            }
            tquery = Util.readSPARQLQuery((String)tquery);
        }
        System.out.println("# Template Query = " + tquery);
        String resultString = this.runQuery(entityName, endpoint, tquery);
        ArrayList resultsData = this.handleXMLresult(resultString);
        if (format.toLowerCase().equals("csv")) {
            response.setContentType("text/plain;charset=UTF-8");
            try (PrintWriter out = response.getWriter();){
                System.out.print("# Results: ");
                if (resultsData.isEmpty()) {
                    System.out.println("-");
                }
                System.out.println("");
                for (HashMap resultSet : resultsData) {
                    String resultToPrint = resultSet.toString().replace("{", "").replace("}", "").replace(", ", "\t");
                    out.println(resultToPrint);
                }
            }
        } else if (format.toLowerCase().equals("xml")) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("results");
            doc.appendChild(rootElement);
            for (HashMap resultSet : resultsData) {
                Element resultEl = doc.createElement("result");
                for (Object k : resultSet.keySet()) {
                    String key = (String)k;
                    String value = (String)resultSet.get(key);
                    Element keyEl = doc.createElement(key);
                    keyEl.appendChild(doc.createTextNode(value));
                    resultEl.appendChild(keyEl);
                }
                rootElement.appendChild(resultEl);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            response.setContentType("application/xml;charset=UTF-8");
            PrintWriter out = response.getWriter();
            StreamResult result = new StreamResult(out);
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException ex) {
                Logger.getLogger(processdocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            out.close();
        } else {
            JSONObject json = new JSONObject();
            JSONArray results = new JSONArray();
            for (HashMap resultSet : resultsData) {
                JSONObject result = new JSONObject();
                for (Object k : resultSet.keySet()) {
                    String key = (String)k;
                    String value = (String)resultSet.get(key);
                    result.put((Object)key, (Object)value);
                }
                results.add((Object)result);
            }
            json.put((Object)"results", (Object)results);
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(json);
            out.close();
        }
        System.out.println("# LINK - FINISHED!");
    }

    private String runQuery(String entityName, String endpoint, String tquery) throws UnsupportedEncodingException, MalformedURLException, IOException {
        String input;
        String query = tquery.replace("<ENTITY>", entityName);
        if (!endpoint.toLowerCase().endsWith("?query=")) {
            endpoint = endpoint + "?query=";
        }
        String sparqlQueryPath = endpoint + URLEncoder.encode(query, "utf8");
        System.out.println("# SPARQL Query Path = " + sparqlQueryPath);
        URL url = new URL(sparqlQueryPath);
        URLConnection con = url.openConnection();
        con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
        String xml_content = "application/sparql-results+xml";
        con.setRequestProperty("ACCEPT", xml_content);
        if (Resources.SPARQL_ENPOINTS_USERNAMES.containsKey(endpoint) && Resources.SPARQL_ENPOINTS_PASSWORDS.containsKey(endpoint)) {
            String username = (String)Resources.SPARQL_ENPOINTS_USERNAMES.get(endpoint);
            String password = (String)Resources.SPARQL_ENPOINTS_PASSWORDS.get(endpoint);
            Authenticator.setDefault((Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        }
        InputStream is = con.getInputStream();
        InputStreamReader isr = new InputStreamReader(is, "utf8");
        BufferedReader in = new BufferedReader(isr);
        String resultString = "";
        while ((input = in.readLine()) != null) {
            resultString = resultString + input + "\n";
        }
        in.close();
        isr.close();
        is.close();
        System.out.println("# SPARQL query was executed successfully!");
        return resultString;
    }

    private ArrayList<LinkedHashMap<String, String>> handleXMLresult(String resultsString) {
        HTMLTag tagger = new HTMLTag(resultsString);
        String headStr = tagger.getFirstTagData("head");
        String resultsStr = tagger.getFirstTagData("results");
        ArrayList<String> resultsVariables = new ArrayList<String>();
        HTMLTag headTagger = new HTMLTag(headStr);
        int i = headTagger.getFirstTagIndex("variable");
        while (i != -1) {
            String variableCont = headTagger.getFirstTagContent("variable", i);
            String variable = HTMLTag.getContentAttribute((String)"name", (String)variableCont);
            resultsVariables.add(variable);
            i = headTagger.getFirstTagIndex("variable", i + 1);
        }
        ArrayList<LinkedHashMap<String, String>> resultsData = new ArrayList<LinkedHashMap<String, String>>();
        HTMLTag resultsTagger = new HTMLTag(resultsStr);
        i = resultsTagger.getFirstTagIndex("result");
        while (i != -1) {
            String resultData = resultsTagger.getFirstTagData("result", i);
            HTMLTag resTagger = new HTMLTag(resultData);
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
            for (String variable : resultsVariables) {
                String bindingData = resTagger.getFirstTagDataContains("binding", "\"" + variable + "\"");
                if (bindingData == null) {
                    bindingData = resTagger.getFirstTagDataContains("binding", "'" + variable + "'");
                }
                if (bindingData == null) continue;
                bindingData = HTMLTag.removeTags((String)bindingData).trim();
                resultMap.put(variable, bindingData);
            }
            resultsData.add(resultMap);
            i = resultsTagger.getFirstTagIndex("result", i + 1);
        }
        return resultsData;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(link.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(link.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(link.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(link.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

