/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.inspecting;

import gr.forth.ics.isl.xsearch.IOSLog;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class SparqlRunner
extends Thread {
    private String category;
    private String element;
    private String sparqlEndpoint;
    private String sparqlQueryTemplate;
    private String sparqlQueryPath;
    private String resultsString;
    private ArrayList<String> resultsVariables;
    private ArrayList<LinkedHashMap<String, String>> resultsData;
    public boolean finish = false;
    private HashSet<String> acceptedCategories;
    private HashMap<String, String> endpoints;
    private HashMap<String, String> templateQueries;

    public SparqlRunner(String category, String element, HashSet<String> acceptedCategories, HashMap<String, String> endpoints, HashMap<String, String> templateQueries) {
        this.category = category;
        this.element = element;
        this.acceptedCategories = acceptedCategories;
        this.endpoints = endpoints;
        this.templateQueries = templateQueries;
    }

    @Override
    public void run() {
        this.sparqlEndpoint = (String)this.endpoints.get(this.category);
        this.sparqlQueryTemplate = SparqlRunner.readTemplate((String)((String)this.templateQueries.get(this.category)));
        this.createSparqlQueryPath();
        System.out.println("- - - - - - - - - - -");
        System.out.println("# Category: " + this.category);
        System.out.println("# Element: " + this.element);
        System.out.println("# SPARQL Endpoint: " + this.sparqlEndpoint);
        System.out.println("# SPARQL Template: " + this.sparqlQueryTemplate);
        System.out.println("# SPARQL QUERY PATH: " + this.sparqlQueryPath);
        this.runSparqlQuery();
        this.handleXMLresult();
        System.out.print("# Results: ");
        if (this.resultsData.isEmpty()) {
            System.out.println("-");
        } else {
            System.out.println("");
            int num = 1;
            for (LinkedHashMap resultSet : this.resultsData) {
                System.out.println(num++ + ". " + resultSet);
            }
        }
        System.out.println("- - - - - - - - - - -");
        this.finish = true;
    }

    private void handleXMLresult() {
        HTMLTag tagger = new HTMLTag(this.resultsString);
        String headStr = tagger.getFirstTagData("head");
        String resultsStr = tagger.getFirstTagData("results");
        this.resultsVariables = new ArrayList();
        HTMLTag headTagger = new HTMLTag(headStr);
        int i = headTagger.getFirstTagIndex("variable");
        while (i != -1) {
            String variableCont = headTagger.getFirstTagContent("variable", i);
            String variable = HTMLTag.getContentAttribute((String)"name", (String)variableCont);
            this.resultsVariables.add(variable);
            i = headTagger.getFirstTagIndex("variable", i + 1);
        }
        this.resultsData = new ArrayList();
        HTMLTag resultsTagger = new HTMLTag(resultsStr);
        i = resultsTagger.getFirstTagIndex("result");
        while (i != -1) {
            String resultData = resultsTagger.getFirstTagData("result", i);
            HTMLTag resTagger = new HTMLTag(resultData);
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
            for (String variable : this.resultsVariables) {
                String bindingData = resTagger.getFirstTagDataContains("binding", "\"" + variable + "\"");
                if (bindingData == null) {
                    bindingData = resTagger.getFirstTagDataContains("binding", "'" + variable + "'");
                }
                if (bindingData == null) continue;
                bindingData = HTMLTag.removeTags((String)bindingData).trim();
                resultMap.put(variable, bindingData);
            }
            this.resultsData.add(resultMap);
            i = resultsTagger.getFirstTagIndex("result", i + 1);
        }
    }

    private void createSparqlQueryPath() {
        try {
            String sparqlQuery = this.sparqlQueryTemplate.replace("<ENTITY>", this.element);
            sparqlQuery = URLEncoder.encode(sparqlQuery, "utf8");
            this.sparqlQueryPath = this.sparqlEndpoint + sparqlQuery;
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("*** ERROR ENCODING SPARQL QUERY: ");
            Logger.getLogger(SparqlRunner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static String readTemplate(String templatePath) {
        String templ = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(templatePath), "UTF8"));
            while ((line = in.readLine()) != null) {
                templ = templ + line + " ";
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("ERROR READING TEMPLATE FILE '" + templatePath + "'\n: " + ex.getMessage());
        }
        return templ;
    }

    private void runSparqlQuery() {
        try {
            try {
                String input;
                URL url = new URL(this.sparqlQueryPath);
                URLConnection con = url.openConnection();
                con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
                String xml_content = "application/sparql-results+xml";
                con.setRequestProperty("ACCEPT", xml_content);
                if (Resources.SPARQL_ENPOINTS_USERNAMES.containsKey(this.sparqlEndpoint) && Resources.SPARQL_ENPOINTS_PASSWORDS.containsKey(this.sparqlEndpoint)) {
                    Authenticator.setDefault((Authenticator)new /* Unavailable Anonymous Inner Class!! */);
                }
                InputStream is = con.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, "utf8");
                BufferedReader in = new BufferedReader(isr);
                this.resultsString = "";
                while ((input = in.readLine()) != null) {
                    this.resultsString = this.resultsString + input + "\n";
                }
                in.close();
                isr.close();
                is.close();
                System.out.println("# SPARQL query was executed successfully!");
            }
            catch (Exception ex) {
                IOSLog.writeErrorToLog((Exception)ex, (String)"SparqlRunner 1");
                System.out.println("# PROBLEM EXECUTING THE SPARQL QUERY! ERROR:" + ex.getMessage());
                Logger.getLogger(SparqlRunner.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception ex) {
            IOSLog.writeErrorToLog((Exception)ex, (String)"SparqlRunner 2");
            Logger.getLogger(SparqlRunner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static LinkedHashMap<String, HashSet<String>> getProperties(String category, String uri, HashMap<String, String> endpoints) throws UnsupportedEncodingException {
        String endpoint = endpoints.get(category);
        String propertiesQuery = SparqlRunner.readTemplate((String)Resources.GET_PROPERTIES_TEMPLATE_QUERY);
        propertiesQuery = propertiesQuery.replace("THE_URI", uri);
        String sparqlQPath = endpoint + URLEncoder.encode(propertiesQuery, "utf8");
        System.out.println("# Query path: " + sparqlQPath);
        String results = SparqlRunner.runQuery((String)endpoint, (String)sparqlQPath);
        HTMLTag tagger = new HTMLTag(results);
        String resultsStr = tagger.getFirstTagData("results");
        LinkedHashMap<String, HashSet<String>> resultsMap = new LinkedHashMap<String, HashSet<String>>();
        HTMLTag resultsTagger = new HTMLTag(resultsStr);
        int i1 = resultsTagger.getFirstTagIndex("result");
        while (i1 != -1) {
            String propValData;
            String resultData = resultsTagger.getFirstTagData("result", i1);
            HTMLTag resTagger = new HTMLTag(resultData);
            String propNameData = resTagger.getFirstTagDataContains("binding", "name='propertyName'");
            if (propNameData == null) {
                propNameData = resTagger.getFirstTagDataContains("binding", "name=\"propertyName\"");
            }
            if (propNameData != null) {
                propNameData = HTMLTag.removeTags((String)propNameData).trim();
            }
            if ((propValData = resTagger.getFirstTagDataContains("binding", "name='propertyValue'")) == null) {
                propValData = resTagger.getFirstTagDataContains("binding", "name=\"propertyValue\"");
            }
            if (propValData != null) {
                propValData = HTMLTag.removeTags((String)propValData).trim();
            }
            if (resultsMap.containsKey(propNameData)) {
                HashSet<String> existingSet = resultsMap.get(propNameData);
                existingSet.add(propValData);
                resultsMap.put(propNameData, existingSet);
            } else {
                HashSet<String> newSet = new HashSet<String>();
                newSet.add(propValData);
                resultsMap.put(propNameData, newSet);
            }
            i1 = resultsTagger.getFirstTagIndex("result", i1 + 1);
        }
        return resultsMap;
    }

    public static String runQuery(String sparqlEndpoint, String queryPath) {
        String results = "";
        try {
            String input;
            URL url = new URL(queryPath);
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
            String xml_content = "application/sparql-results+xml";
            con.setRequestProperty("ACCEPT", xml_content);
            if (Resources.SPARQL_ENPOINTS_USERNAMES.containsKey(sparqlEndpoint) && Resources.SPARQL_ENPOINTS_PASSWORDS.containsKey(sparqlEndpoint)) {
                Authenticator.setDefault((Authenticator)new /* Unavailable Anonymous Inner Class!! */);
            }
            InputStream is = con.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, "utf8");
            BufferedReader in = new BufferedReader(isr);
            while ((input = in.readLine()) != null) {
                results = results + input + "\n";
            }
            in.close();
            isr.close();
            is.close();
            System.out.println("# SPARQL query was executed successfully!");
        }
        catch (Exception ex) {
            IOSLog.writeErrorToLog((Exception)ex, (String)"SparqlRunner 3");
            System.out.println("# PROBLEM EXECUTING THE SPARQL QUERY! ERROR:" + ex.getMessage());
            Logger.getLogger(SparqlRunner.class.getName()).log(Level.SEVERE, null, ex);
        }
        return results;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public ArrayList<LinkedHashMap<String, String>> getResultsData() {
        return this.resultsData;
    }

    public void setResultsData(ArrayList<LinkedHashMap<String, String>> resultsData) {
        this.resultsData = resultsData;
    }

    public String getResultsString() {
        return this.resultsString;
    }

    public void setResultsString(String resultsString) {
        this.resultsString = resultsString;
    }

    public ArrayList<String> getResultsVariables() {
        return this.resultsVariables;
    }

    public void setResultsVariables(ArrayList<String> resultsVariables) {
        this.resultsVariables = resultsVariables;
    }

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public void setSparqlEndpoint(String sparqlEndpoint) {
        this.sparqlEndpoint = sparqlEndpoint;
    }

    public String getSparqlQueryPath() {
        return this.sparqlQueryPath;
    }

    public void setSparqlQueryPath(String sparqlQueryPath) {
        this.sparqlQueryPath = sparqlQueryPath;
    }

    public String getSparqlQueryTemplate() {
        return this.sparqlQueryTemplate;
    }

    public void setSparqlQueryTemplate(String sparqlQueryTemplate) {
        this.sparqlQueryTemplate = sparqlQueryTemplate;
    }

    static /* synthetic */ String access$000(SparqlRunner x0) {
        return x0.sparqlEndpoint;
    }
}

