/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.opensearch;

import gr.forth.ics.isl.xsearch.SearchResult;
import gr.forth.ics.isl.xsearch.resources.Resources;
import gr.forth.ics.isl.xsearch.retriever.AtomRetriever;
import gr.forth.ics.isl.xsearch.retriever.RSSRetriever;
import gr.forth.ics.isl.xsearch.retriever.ResultsRetriever;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

public class OpenSearchRetriever
implements ResultsRetriever {
    private String template;
    private String searchTerms;
    private String type;
    private int count;
    private ArrayList<SearchResult> results;
    private HashMap<String, String> parameters;
    private boolean supportsPaging;

    public OpenSearchRetriever(String template, String type, String searchTerms) {
        this.template = template.replace("&amp;", "&");
        this.type = type;
        this.searchTerms = searchTerms;
        this.count = -1;
        this.results = new ArrayList();
        this.parameters = new HashMap();
        this.supportsPaging = false;
        try {
            int ind = template.indexOf("{");
            while (ind != -1) {
                int ind2 = template.indexOf("}", ind);
                String parameter = template.substring(ind + 1, ind2);
                if (parameter.toLowerCase().contains("startindex")) {
                    this.supportsPaging = true;
                }
                this.parameters.put(parameter, "");
                ind = template.indexOf("{", ind + 1);
            }
        }
        catch (Exception e) {
            System.out.println("*** ERROR FINDING TEMPLATE PARAMETERS! PLEASE CHECK THE OPEN SEARCH DESCRIPTION DOCUMENT! ");
        }
    }

    public void retrieveResults() {
        if (this.count <= 0) {
            this.count = Resources.MAX_NUM_OF_RESULTS_FROM_WSE;
        }
        if (this.supportsPaging) {
            int numOfPages = 1;
            if (this.count > 50) {
                numOfPages = this.count / 50;
                if (this.count % 50 != 0) {
                    ++numOfPages;
                }
            }
            for (int i = 0; i < numOfPages; ++i) {
                RSSRetriever retriever;
                String template_temp = this.template;
                for (String parameter : this.parameters.keySet()) {
                    if (parameter.toLowerCase().contains("searchterms")) {
                        String encodedSearchTerms = this.searchTerms;
                        try {
                            encodedSearchTerms = URLEncoder.encode(this.searchTerms, "utf-8");
                        }
                        catch (UnsupportedEncodingException ex) {
                            System.out.println("*** ERROR ENCODING QUERY TERMS: " + ex.getMessage());
                        }
                        template_temp = template_temp.replace("{" + parameter + "}", encodedSearchTerms);
                        continue;
                    }
                    if (parameter.toLowerCase().contains("count")) {
                        template_temp = template_temp.replace("{" + parameter + "}", "50");
                        continue;
                    }
                    if (parameter.toLowerCase().contains("startindex")) {
                        template_temp = template_temp.replace("{" + parameter + "}", "" + i * 50);
                        continue;
                    }
                    template_temp = template_temp.replace("{" + parameter + "}", "");
                }
                if (i > 0) {
                    retriever = null;
                    if (this.type.toLowerCase().equals("application/rss+xml")) {
                        retriever = new RSSRetriever(template_temp);
                    } else if (this.type.toLowerCase().equals("application/atom+xml")) {
                        retriever = new AtomRetriever(template_temp);
                    } else {
                        System.out.println("*** NO SUPPORTED TEMPLATE TYPE: " + this.type);
                    }
                    if (retriever == null) continue;
                    retriever.setDesiredNumber(this.count);
                    retriever.retrieveResults();
                    ArrayList resultsTemp = retriever.getResults();
                    for (SearchResult res : resultsTemp) {
                        boolean cont = false;
                        for (SearchResult res2 : this.results) {
                            if (!res.getUrl().toLowerCase().equals(res2.getUrl().toLowerCase())) continue;
                            cont = true;
                            break;
                        }
                        if (cont) continue;
                        this.results.add(res);
                    }
                    continue;
                }
                retriever = null;
                if (this.type.toLowerCase().equals("application/rss+xml")) {
                    retriever = new RSSRetriever(template_temp);
                } else if (this.type.toLowerCase().equals("application/atom+xml")) {
                    retriever = new AtomRetriever(template_temp);
                } else {
                    System.out.println("*** NO SUPPORTED TEMPLATE TYPE: " + this.type);
                }
                if (retriever == null) continue;
                retriever.setDesiredNumber(this.count);
                retriever.retrieveResults();
                this.results.addAll(retriever.getResults());
            }
        } else {
            for (String parameter : this.parameters.keySet()) {
                if (parameter.toLowerCase().contains("searchterms")) {
                    String encodedSearchTerms = this.searchTerms;
                    try {
                        encodedSearchTerms = URLEncoder.encode(this.searchTerms, "utf-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        System.out.println("*** ERROR ENCODING QUERY TERMS: " + ex.getMessage());
                    }
                    this.template = this.template.replace("{" + parameter + "}", encodedSearchTerms);
                    continue;
                }
                if (parameter.toLowerCase().contains("count")) {
                    this.template = this.template.replace("{" + parameter + "}", "" + this.count);
                    continue;
                }
                this.template = this.template.replace("{" + parameter + "}", "");
            }
            RSSRetriever retriever = null;
            if (this.type.toLowerCase().equals("application/rss+xml")) {
                retriever = new RSSRetriever(this.template);
            } else if (this.type.toLowerCase().equals("application/atom+xml")) {
                retriever = new AtomRetriever(this.template);
            } else {
                System.out.println("*** NO SUPPORTED TEMPLATE TYPE: " + this.type);
            }
            if (retriever != null) {
                retriever.setDesiredNumber(this.count);
                retriever.retrieveResults();
                this.results.addAll(retriever.getResults());
            }
        }
    }

    public ArrayList<SearchResult> getResults() {
        return this.results;
    }

    public void setQuery(String query) {
        this.searchTerms = query;
    }

    public String getQuery() {
        return this.searchTerms;
    }

    public void setDesiredNumber(int desiredNumber) {
        this.count = desiredNumber;
    }

    public int getDesiredNumber() {
        return this.count;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }
}

