/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.xsearch.admin;

import gr.forth.ics.isl.xsearch.util.HTMLTag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoadList
extends HttpServlet {
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        HttpSession session = request.getSession();
        String loggedin = (String)session.getAttribute("loggedin");
        if (loggedin == null) {
            loggedin = "no";
            session.setAttribute("loggedin", (Object)loggedin);
            RequestDispatcher dispatcher = request.getRequestDispatcher("login.jsp");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        PrintWriter out = response.getWriter();
        out.print("");
        try {
            String input;
            String endpoint = request.getParameter("endpoint");
            if (endpoint == null) {
                endpoint = "";
            }
            endpoint = URLDecoder.decode(endpoint, "utf-8");
            String query = request.getParameter("query");
            if (query == null) {
                query = "";
            }
            query = URLDecoder.decode(query, "utf-8");
            if (endpoint.trim().equals("")) {
                out.print("ATTENTION!! Empty SPARQL endpoint!");
                out.close();
                return;
            }
            if (query.trim().equals("")) {
                out.print("ATTENTION!! Empty SPARQL query!");
                out.close();
                return;
            }
            if (!(query.toLowerCase().contains("select") && query.toLowerCase().contains("where") && query.contains("?") && query.contains("{") && query.contains("}"))) {
                out.print("ATTENTION!! The SPARQL template query is not valid!");
                out.close();
                return;
            }
            String encodedQuery = URLEncoder.encode(query, "utf8");
            String encodedQuerypath = endpoint + encodedQuery;
            System.out.println("# Query path: " + encodedQuerypath);
            URL url = new URL(encodedQuerypath);
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
            String xml_content = "application/sparql-results+xml";
            con.setRequestProperty("ACCEPT", xml_content);
            InputStream is = con.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, "utf8");
            BufferedReader in = new BufferedReader(isr);
            String resultsString = "";
            while ((input = in.readLine()) != null) {
                resultsString = resultsString + input + "\n";
            }
            in.close();
            isr.close();
            is.close();
            TreeSet<String> values = new TreeSet<String>();
            ArrayList results = this.handleXMLresult(resultsString);
            for (LinkedHashMap map : results) {
                for (String key : map.keySet()) {
                    String value = (String)map.get(key);
                    values.add(value);
                }
            }
            for (String value : values) {
                out.print(value);
                out.println();
            }
        }
        catch (Exception e) {
            out.print("ATTENTION!! " + e.getMessage().replace("\n", " "));
        }
        out.close();
    }

    private ArrayList<LinkedHashMap<String, String>> handleXMLresult(String resultsString) {
        HTMLTag tagger = new HTMLTag(resultsString);
        String headStr = tagger.getFirstTagData("head");
        String resultsStr = tagger.getFirstTagData("results");
        ArrayList<String> resultsVariables = new ArrayList<String>();
        HTMLTag headTagger = new HTMLTag(headStr);
        int i = headTagger.getFirstTagIndex("variable");
        while (i != -1) {
            String variableCont = headTagger.getFirstTagContent("variable", i);
            String variable = HTMLTag.getContentAttribute((String)"name", (String)variableCont);
            resultsVariables.add(variable);
            i = headTagger.getFirstTagIndex("variable", i + 1);
        }
        ArrayList<LinkedHashMap<String, String>> resultsData = new ArrayList<LinkedHashMap<String, String>>();
        HTMLTag resultsTagger = new HTMLTag(resultsStr);
        i = resultsTagger.getFirstTagIndex("result");
        while (i != -1) {
            String resultData = resultsTagger.getFirstTagData("result", i);
            HTMLTag resTagger = new HTMLTag(resultData);
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
            for (String variable : resultsVariables) {
                String bindingData = resTagger.getFirstTagDataContains("binding", "\"" + variable + "\"");
                if (bindingData == null) {
                    bindingData = resTagger.getFirstTagDataContains("binding", "'" + variable + "'");
                }
                if (bindingData == null) continue;
                bindingData = HTMLTag.removeTags((String)bindingData).trim();
                resultMap.put(variable, bindingData);
            }
            resultsData.add(resultMap);
            i = resultsTagger.getFirstTagIndex("result", i + 1);
        }
        return resultsData;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

