/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.search.adapter.service.helpers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryParserHelper {
    public String getQueryPart(String query) {
        List queryParts = Splitter.on((String)" project ").omitEmptyStrings().splitToList((CharSequence)query);
        String queryPart = null;
        queryPart = queryParts.size() > 2 ? Joiner.on((String)" ").join(queryParts.subList(0, queryParts.size() - 2)) : (String)queryParts.get(0);
        return queryPart;
    }

    public List<String> getProjectPart(String query, List<String> presentablesFields) {
        if (!query.contains(" project ")) {
            return Lists.newArrayList(presentablesFields);
        }
        String projectPart = (String)Iterables.getLast((Iterable)Splitter.on((String)" project ").omitEmptyStrings().splitToList((CharSequence)query));
        List projections = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().splitToList((CharSequence)projectPart);
        if (projections.size() == 1 && ((String)projections.get(0)).equals("*")) {
            return Lists.newArrayList(presentablesFields);
        }
        return projections;
    }

    public String replaceFields(String query, Map<String, String> fields) {
        String newQuery = query;
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            String fieldID = entry.getValue();
            if (fieldName.equalsIgnoreCase("gDocCollectionID") || fieldName.equalsIgnoreCase("gDocCollectionLang") || fieldName.equalsIgnoreCase("ObjectID")) continue;
            newQuery = newQuery.replace(fieldName, fieldID);
        }
        newQuery = newQuery.replace("cql.", "");
        newQuery = newQuery.replace("oai_dc.", "");
        newQuery = newQuery.replace("dc.", "");
        return newQuery;
    }

    public static void main(String[] args) {
        QueryParserHelper qh = new QueryParserHelper();
        String query = "select 1 2 from table project 1 2 3 4 ";
        HashMap fieldsMapping = Maps.newHashMap();
        fieldsMapping.put("1", "name");
        fieldsMapping.put("2", "age");
        System.out.println("query part     : " + qh.getQueryPart("select 1 2 from table project 1 2 3 4 "));
        System.out.println("project part   : " + qh.getProjectPart("select 1 2 from table project 1 2 3 4 ", (List)Lists.newArrayList(fieldsMapping.keySet())));
        System.out.println("replaced query : " + qh.replaceFields("select 1 2 from table project 1 2 3 4 ", (Map)fieldsMapping));
    }
}

