/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.service;

import com.google.common.io.Resources;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceContext {
    private static final Logger logger = LoggerFactory.getLogger(ServiceContext.class);
    public static final String PROPERTIES_FILE = "deploy.properties";
    public static final String ServiceClass = "Search";
    public static final String ServiceName = "SruConsumerDatasource";

    void initialize() throws Exception {
        Map properties = ServiceContext.readProperties();
        ServiceContext.initializeTCPManager((Map)properties);
    }

    private static String getHostName(Map<String, String> map) {
        return map.get("hostname").trim();
    }

    private static boolean getUseRandomPort(Map<String, String> map) {
        return Boolean.valueOf(map.get("useRandomPort").trim());
    }

    private static List<PortRange> getPortRanges(Map<String, String> map) {
        String portRangesObj = map.get("portRanges");
        logger.info("port ranges retrieved is " + portRangesObj);
        if (portRangesObj == null) {
            return new ArrayList<PortRange>();
        }
        String portRangesStr = portRangesObj.toString();
        String[] rangePairs = portRangesStr.trim().split("-");
        ArrayList<PortRange> ranges = new ArrayList<PortRange>();
        for (String pair : rangePairs) {
            String[] pairSplit = pair.trim().split(",");
            if (pairSplit.length != 2) {
                return new ArrayList<PortRange>();
            }
            String pairStart = pairSplit[0].trim();
            if (!pairStart.startsWith("{")) {
                return new ArrayList<PortRange>();
            }
            pairStart = pairStart.substring(1).trim();
            String pairEnd = pairSplit[1].trim();
            if (!pairEnd.endsWith("}")) {
                return new ArrayList<PortRange>();
            }
            pairEnd = pairEnd.substring(0, pairEnd.length() - 1).trim();
            int beginPair = 0;
            int endPair = 0;
            try {
                beginPair = Integer.parseInt(pairStart.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            try {
                endPair = Integer.parseInt(pairEnd.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            ranges.add(new PortRange(beginPair, endPair));
        }
        return ranges;
    }

    private static void initializeTCPManager(Map<String, String> props) {
        logger.info("Initalizing TCPManager");
        List range = ServiceContext.getPortRanges(props);
        for (PortRange r : range) {
            logger.info("port range : " + r.GetStart() + "-" + r.GetEnd());
        }
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(ServiceContext.getHostName(props), range, ServiceContext.getUseRandomPort(props)));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    private static Map<String, String> readProperties() throws FileNotFoundException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            prop.load(is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
        for (String key : prop.stringPropertyNames()) {
            String value = prop.getProperty(key);
            if (value == null) continue;
            map.put(key, value.trim());
        }
        logger.info("properties read : " + map);
        return map;
    }
}

