/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.service.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.datatransformation.DataTransformationClient;
import org.gcube.datatransformation.client.library.beans.Types;
import org.gcube.datatransformation.client.library.exceptions.EmptySourceException;
import org.gcube.search.sru.consumer.common.resources.SruConsumerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParserHelper {
    static final Logger logger = LoggerFactory.getLogger(ParserHelper.class);

    public static List<Map<String, String>> parseResponse(DataTransformationClient dtsclient, String url, SruConsumerResource resource, List<String> projections, Map<String, String> fieldsMapping, String snippetTranslatedField) throws Exception {
        List records = ParserHelper.transformSRUSource((DataTransformationClient)dtsclient, (String)url);
        ArrayList projectedRecords = Lists.newArrayList();
        for (Map record : records) {
            Map projectedRecord = ParserHelper.applyProjection((Map)record, (String)resource.getRecordIDField(), (String)resource.getCollectionID(), projections, fieldsMapping, (String)snippetTranslatedField);
            projectedRecords.add(projectedRecord);
            logger.debug("records : " + record + " projected record : " + projectedRecord);
        }
        return projectedRecords;
    }

    public static List<Map<String, String>> transformSRUSource(DataTransformationClient dtsclient, String url) throws Exception {
        Types.TransformDataWithTransformationUnit request = new Types.TransformDataWithTransformationUnit();
        request.tpID = "$XSLT_Transformer";
        request.transformationUnitID = "0";
        Types.Input input = new Types.Input();
        input.inputType = "SRUDataSource";
        input.inputValue = url;
        request.inputs = Arrays.asList(input);
        request.output = new Types.Output();
        request.output.outputType = "RS2";
        request.targetContentType = new Types.ContentType();
        request.targetContentType.mimeType = "json/application";
        Types.Parameter xsltParameter1 = new Types.Parameter("xslt:1", "$BrokerXSLT_FlattenXML");
        Types.Parameter xsltParameter2 = new Types.Parameter("finalftsxslt", "$BrokerXSLT_XML_to_JSON");
        Types.Parameter xsltParameter3 = new Types.Parameter("delimiter", " & ");
        request.tProgramUnboundParameters = Arrays.asList(xsltParameter1, xsltParameter2, xsltParameter3);
        request.filterSources = false;
        request.createReport = false;
        List maps = null;
        try {
            String resp = dtsclient.transformDataWithTransformationUnit(request, true, true);
            maps = DataTransformationClient.getMapFromResponse((String)resp);
        }
        catch (EmptySourceException e) {
            logger.debug("no records returned by dts", (Throwable)e);
            maps = Lists.newArrayList();
        }
        logger.info("dts returned " + maps.size() + " records");
        ArrayList records = Lists.newArrayList();
        for (Map map : maps) {
            String rowset = (String)map.get("Rowset");
            if (rowset == null) continue;
            Map rec = ParserHelper.transformRowsetToMap((String)rowset);
            records.add(rec);
        }
        return records;
    }

    static Map<String, String> transformRowsetToMap(String rowset) {
        Gson gson = new Gson();
        logger.debug("rowset retrieved by dts and will be parsed to Map<String, Map<String, String>>  : " + rowset);
        Map rec = (Map)gson.fromJson(rowset, new /* Unavailable Anonymous Inner Class!! */.getType());
        Map fields = (Map)rec.values().iterator().next();
        return fields;
    }

    static Map<String, String> applyProjection(Map<String, String> rec, String idField, String collectionID, List<String> projections, Map<String, String> fieldsMapping, String snippetTranslatedField) {
        ArrayList projectionFields = Lists.newArrayList(projections);
        if (idField != null && !projectionFields.contains(idField)) {
            projectionFields.add(0, idField);
        }
        HashMap projectedRecord = Maps.newHashMap();
        logger.info("will apply projection for the following fields : " + projectionFields);
        for (String projection : projectionFields) {
            String value = rec.get(projection);
            if (value == null) continue;
            if (snippetTranslatedField != null & projection.equalsIgnoreCase(snippetTranslatedField)) {
                projection = "S";
            }
            if (fieldsMapping != null && fieldsMapping.containsKey(projection)) {
                projection = fieldsMapping.get(projection);
            } else if (projection.equals(idField)) {
                projection = "ObjectID";
            }
            projectedRecord.put(projection, value);
        }
        if (projectedRecord.get("ObjectID") == null) {
            projectedRecord.put("ObjectID", "noID");
        }
        if (projectedRecord.get("gDocCollectionID") == null) {
            projectedRecord.put("gDocCollectionID", collectionID);
        }
        return projectedRecord;
    }

    public static void main(String[] args) throws Exception {
        DataTransformationClient dtsclient = new DataTransformationClient();
        dtsclient.setScope("/gcube/devNext");
        dtsclient.randomClient();
        System.out.println(ParserHelper.transformSRUSource((DataTransformationClient)dtsclient, (String)"http://www.nla.gov.au/apps/srw/search/peopleaustralia?operation=searchRetrieve&query=%28%28%28%28%28%28contributor+%3D+cacikumar%29+or+%28title+%3D+cacikumar%29%29%29+or+%28creator+%3D+cacikumar%29%29%29+or+%28%28%28%28%28contributor+%3D+fish%29+or+%28title+%3D+fish%29%29%29+or+%28creator+%3D+fish%29%29%29%29&maximumRecords=10&recordSchema=info:srw/schema/1/dc-v1.1&version=1.1"));
    }
}

