/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search;

import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.gcube.rest.search.commons.SearchServiceAPI;
import org.gcube.search.ServiceContext;
import org.gcube.searchsystem.cache.PlanCache;
import org.gcube.searchsystem.cache.PlanCacheManager;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;
import org.gcube.searchsystem.planning.Orchestrator;
import org.gcube.searchsystem.workflow.PE2ngWorkflowAdaptor;
import org.gcube.searchsystem.workflow.WorkflowEngineAdaptor;
import org.jboss.resteasy.annotations.GZIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class SearchSystemService
implements SearchServiceAPI {
    private static final Logger logger = LoggerFactory.getLogger(SearchSystemService.class);
    PlanCache pCache = null;
    ResourceRegistryAdapter rradapter = null;
    EnvHintCollection adaptorHints = null;
    String scope = null;
    boolean initialized = false;
    Map<String, String> fieldNameMap = new HashMap();

    public SearchSystemService() throws Exception {
        this.initialize();
    }

    synchronized void initialize() throws Exception {
        ServiceContext sc = new ServiceContext();
        if (!this.initialized) {
            this.scope = sc.getScope();
            this.pCache = PlanCacheManager.getCacheWithName((String)this.scope);
            this.adaptorHints = sc.getHints();
            this.adaptorHints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(this.scope)));
            this.rradapter = new ResourceRegistryAdapter(this.adaptorHints);
            this.initialized = true;
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response search(@HeaderParam(value="gcube-scope") String scope, @QueryParam(value="query") String query, @QueryParam(value="all") @DefaultValue(value="false") Boolean all, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty, @QueryParam(value="names") @DefaultValue(value="false") Boolean names) {
        logger.info("query : " + query);
        if (query.startsWith("\"") && query.endsWith("\"")) {
            query = query.substring(1, query.length() - 1);
        }
        try {
            long starttime = System.currentTimeMillis();
            PE2ngWorkflowAdaptor workflowadaptor = null;
            try {
                workflowadaptor = new PE2ngWorkflowAdaptor(this.adaptorHints);
            }
            catch (Exception e) {
                logger.error("error initializing workflow adaptor:", (Throwable)e);
                String msg = JSONConverter.convertToJSON((String)"msg", (Object)"error initializing workflow adaptor");
                Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                return Response.status((Response.Status)status).entity((Object)msg).build();
            }
            Orchestrator orchestrator = new Orchestrator();
            String rsEpr = orchestrator.search(query, (EnvironmentAdaptor)this.rradapter, (WorkflowEngineAdaptor)workflowadaptor, this.pCache);
            long endtime = System.currentTimeMillis();
            logger.info("Search completed after : " + (endtime - starttime) + " ms. grs : " + rsEpr);
            logger.info("Search completed after : " + (endtime - starttime) + " ms. grs : " + rsEpr);
            ArrayList warnings = orchestrator.getWarnings();
            if (warnings.size() > 0) {
                String msg = JSONConverter.convertToJSON((String)"msg", (Object)warnings.toString());
                Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                return Response.status((Response.Status)status).entity((Object)msg).build();
            }
            String msg = null;
            if (all.booleanValue()) {
                logger.info("reading records...");
                msg = SearchSystemService.readResults((String)rsEpr, (Boolean)pretty, (Boolean)names, (Map)this.fieldNameMap);
                logger.info("reading records...OK");
            } else {
                msg = JSONConverter.convertToJSON((String)"grslocator", (Object)rsEpr);
            }
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error while searching :", (Throwable)e);
            String msg = JSONConverter.convertToJSON((String)"msg", (Object)"error while searching");
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    @GET
    @Path(value="/searchSec")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response searchSec(@HeaderParam(value="gcube-scope") String scope, @QueryParam(value="query") String query, @QueryParam(value="all") @DefaultValue(value="false") Boolean all, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty, @QueryParam(value="names") @DefaultValue(value="false") Boolean names, @QueryParam(value="sids") Set<String> sids) {
        logger.info("query : " + query);
        logger.info("query : " + query);
        if (query.startsWith("\"") && query.endsWith("\"")) {
            query = query.substring(1, query.length() - 1);
        }
        try {
            long starttime = System.currentTimeMillis();
            PE2ngWorkflowAdaptor workflowadaptor = null;
            try {
                workflowadaptor = new PE2ngWorkflowAdaptor(this.adaptorHints);
            }
            catch (Exception e) {
                logger.error("error initializing workflow adaptor:", (Throwable)e);
                String msg = JSONConverter.convertToJSON((String)"msg", (Object)"error initializing workflow adaptor");
                Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                return Response.status((Response.Status)status).entity((Object)msg).build();
            }
            Orchestrator orchestrator = new Orchestrator();
            orchestrator.setSids(sids);
            String rsEpr = orchestrator.search(query, (EnvironmentAdaptor)this.rradapter, (WorkflowEngineAdaptor)workflowadaptor, this.pCache);
            long endtime = System.currentTimeMillis();
            logger.info("Search completed after : " + (endtime - starttime) + " ms. grs : " + rsEpr);
            logger.info("Search completed after : " + (endtime - starttime) + " ms. grs : " + rsEpr);
            ArrayList warnings = orchestrator.getWarnings();
            if (warnings.size() > 0) {
                String msg = JSONConverter.convertToJSON((String)"msg", (Object)warnings.toString());
                Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                return Response.status((Response.Status)status).entity((Object)msg).build();
            }
            String msg = null;
            msg = all != false ? SearchSystemService.readResults((String)rsEpr, (Boolean)pretty, (Boolean)names, (Map)this.fieldNameMap) : JSONConverter.convertToJSON((String)"grslocator", (Object)rsEpr);
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        catch (Exception e) {
            logger.error("error while searching :", (Throwable)e);
            String msg = JSONConverter.convertToJSON((String)"msg", (Object)"error while searching");
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    static String readResults(String rsLocator, Boolean pretty, Boolean names, Map<String, String> fieldNameMap) throws Exception {
        logger.info("Opening stream...");
        ForwardReader reader = new ForwardReader(new URI(rsLocator));
        logger.info("Opening stream...OK");
        ArrayList results = new ArrayList();
        try {
            Iterator it = reader.iterator();
            while (it.hasNext()) {
                logger.info("\tReading record from stream...");
                GenericRecord rec = (GenericRecord)it.next();
                HashMap<String, String> mapRec = new HashMap<String, String>();
                for (Field field : rec.getFields()) {
                    String fieldID = field.getFieldDefinition().getName();
                    String fieldName = null;
                    if (names.booleanValue()) {
                        if (fieldNameMap.containsKey(fieldID)) {
                            fieldName = fieldNameMap.get(fieldID);
                        } else {
                            fieldName = QueryHelper.GetFieldNameById((String)fieldID);
                            if (fieldName == null) {
                                fieldName = fieldID;
                            }
                            fieldNameMap.put(fieldID, fieldName);
                        }
                    } else {
                        fieldName = fieldID;
                    }
                    String fieldValue = ((StringField)field).getPayload();
                    mapRec.put(fieldName, fieldValue);
                }
                results.add(mapRec);
            }
            reader.close();
        }
        catch (Exception e) {
            logger.warn("error while reading results", (Throwable)e);
            reader.close();
            throw e;
        }
        logger.info("converting records to json");
        String msg = JSONConverter.convertToJSON(results, (boolean)pretty);
        logger.info("msg : " + msg);
        return msg;
    }

    @GET
    @Path(value="/collections")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response collections(@HeaderParam(value="gcube-scope") String scope) {
        try {
            Map collections = this.rradapter.getAllCollections(this.scope);
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)collections).build();
        }
        catch (Exception e) {
            String msg = JSONConverter.convertToJSON((String)"msg", (Object)"error while collections");
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    @GET
    @Path(value="/fields")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response fields(@HeaderParam(value="gcube-scope") String scope) {
        try {
            Map fields = this.rradapter.getAllFieldsPerCollection(this.scope);
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)fields).build();
        }
        catch (Exception e) {
            String msg = JSONConverter.convertToJSON((String)"msg", (Object)"error getting fields");
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    @GET
    @Path(value="/fieldsMapping")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response fieldsMapping(@HeaderParam(value="gcube-scope") String scope) {
        try {
            Map fieldsMapping = this.rradapter.getFieldsMapping(this.scope);
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)fieldsMapping).build();
        }
        catch (Exception e) {
            String msg = JSONConverter.convertToJSON((String)"msg", (Object)"error getting fields mapping");
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }
}

