package org.gcube.searchsystem.searchsystemservice;

import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;

import java.util.ArrayList;
import java.util.Calendar;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.searchsystem.cache.PlanCache;
import org.gcube.searchsystem.cache.PlanCacheManager;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;
import org.gcube.searchsystem.planning.Orchestrator;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchResponse;
import org.gcube.searchsystem.searchsystemservice.stubs.StringArray;
import org.gcube.searchsystem.workflow.PE2ngWorkflowAdaptor;

/**
 * Web Service front end to the gCube Search System
 * 
 * @author Vasilis Verroios
 */
public class SearchSystemService extends GCUBEPortType {
	/**
	 * The Logger used by this class
	 */
	private static GCUBELog logger = new GCUBELog(SearchSystemService.class);
	
	
	//get cache for this scope
	PlanCache pCache = null;
	
	ResourceRegistryAdapter rradapter = null;
	EnvHintCollection adaptorHints = null;
	/**
	 * Creates a new {@link SearchSystemService}
	 */
	public SearchSystemService(){
		
	}
	
	boolean initialized = false;
	synchronized void initialize(){
		if (!initialized){
			pCache = PlanCacheManager.getCacheWithName(ServiceContext.getContext().getScope().toString());
			adaptorHints = ServiceContext.getContext().getHints();
			adaptorHints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(ServiceContext.getContext().getScope().toString())));
			
			rradapter = new ResourceRegistryAdapter(adaptorHints);
			
			
			initialized = true;
		}
	}

	/**
	 * Entry point to the search operation
	 * 
	 * @param query - The gCQL query to be answered 
	 * @return The ResultSet end point reference (containing the results) and a list of warnings
	 * @throws GCUBEFault An unrecoverable for the operation error occurred
	 */
	
	

			
	public SearchResponse search(String query) throws GCUBEFault {
		try{
			logger.info("received query: " + query);
			
			if (!initialized)
				initialize();
			
			PE2ngWorkflowAdaptor workflowadaptor = null;
			try {
				workflowadaptor = new PE2ngWorkflowAdaptor(adaptorHints);
			} catch (Exception e) {
				logger.error("error initializing workflow adaptor:", e);
				throw new GCUBEFault(e, e.getMessage());
			}
			//for statistics
			long start=Calendar.getInstance().getTimeInMillis();
			
			Orchestrator orchestrator = new Orchestrator();
			
			
			//get the rsEpr
			String rsEpr = orchestrator.search(query, 
					rradapter,
					workflowadaptor,
					pCache);

			//get the warnings list
			ArrayList<String> warnings = orchestrator.getWarnings();
			
			long end=Calendar.getInstance().getTimeInMillis();
			
			logger.info("finished after (millisecs): " + (end-start));
			
			SearchResponse response = new SearchResponse(rsEpr, 
					new StringArray(warnings.toArray(new String[warnings.size()])));
			
			return response;
			
		}catch(Exception e){
			logger.error("Error while executing query:", e);
			throw new GCUBEFault(e, e.getMessage());
		}
	}
	
	@Override
	protected GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}
}
