/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning;

import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.PlanNode;
import java.util.ArrayList;
import java.util.Set;
import org.gcube.searchsystem.cache.PlanCache;
import org.gcube.searchsystem.cache.PlanCacheManager;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;
import org.gcube.searchsystem.planning.maxsubtree.MaxSubtreePlanner;
import org.gcube.searchsystem.planning.preprocessing.Preprocessor;
import org.gcube.searchsystem.workflow.PE2ngWorkflowAdaptor;
import org.gcube.searchsystem.workflow.WorkflowEngineAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLFuseNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLSortNode;

public class Orchestrator {
    private Logger logger = LoggerFactory.getLogger((String)Orchestrator.class.getName());
    private ArrayList<Preprocessor> preprocessors = new ArrayList();
    private ArrayList<String> priorities = new ArrayList();
    private ArrayList<String> warnings = new ArrayList();
    private Set<String> sids = null;

    public void setSids(Set<String> sids) {
        this.sids = sids;
    }

    public String search(String cqlQuery, EnvironmentAdaptor environmentAdaptor, WorkflowEngineAdaptor workflowAdaptor, PlanCache pCache) throws Exception {
        try {
            this.logger.info("Received query: " + cqlQuery);
            if (PlanCacheManager.checkInitializationError()) {
                this.logger.warn(PlanCacheManager.getInitializationError());
                throw new Exception("Search could not complete due to cache plan cache manager initialization error " + PlanCacheManager.getInitializationError());
            }
            long before = System.currentTimeMillis();
            GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)cqlQuery);
            long after = System.currentTimeMillis();
            this.logger.info("parseGCQLString returned after: " + (after - before) + " millis");
            before = System.currentTimeMillis();
            PlanNode cachedPlan = pCache.searchForCachedPlans(cqlQuery, head);
            after = System.currentTimeMillis();
            this.logger.info("searchForCachedPlans returned after: " + (after - before) + " millis");
            Exception exceptionFromCached = null;
            if (cachedPlan != null) {
                this.logger.info("Found cached plans for query: " + cqlQuery + " ---------> " + cachedPlan.toString());
                try {
                    String rsEpr = this.execute(cachedPlan, workflowAdaptor);
                    return rsEpr;
                }
                catch (Exception e) {
                    this.logger.warn("Exception while executing cached plan. We will create a new plan and try to execute it", (Throwable)e);
                    exceptionFromCached = e;
                    pCache.clear();
                }
            }
            before = System.currentTimeMillis();
            PlanNode newPlan = null;
            try {
                newPlan = this.preprocessAndPlan(head, environmentAdaptor);
            }
            catch (Exception e) {
                this.logger.error("something went wrong on plan creation. trying to clear the cache and reconstruct a new plan", (Throwable)e);
                MaxSubtreePlanner.cache.invalidateAll();
                newPlan = this.preprocessAndPlan(head, environmentAdaptor);
            }
            after = System.currentTimeMillis();
            this.logger.info("profiling: search plan created in : " + (after - before) + " millis");
            before = System.currentTimeMillis();
            if (cachedPlan != null && newPlan.equals((Object)cachedPlan)) {
                this.logger.info("newplan: " + newPlan.toString() + "---- is equal to the cached one: " + cachedPlan.toString());
                throw exceptionFromCached;
            }
            after = System.currentTimeMillis();
            this.logger.info("checking for plan equality returned after: " + (after - before) + " millis");
            before = System.currentTimeMillis();
            pCache.addPlan(cqlQuery, head, newPlan);
            after = System.currentTimeMillis();
            this.logger.info("adding plan to cache returned after: " + (after - before) + " millis");
            this.logger.info("new plan is : " + cqlQuery + " ---------> " + newPlan.toString());
            try {
                return this.execute(newPlan, workflowAdaptor);
            }
            catch (Exception e) {
                this.logger.error("something went wrong on search execution. trying to reconstruct new plan and execute again", (Throwable)e);
                return this.retryExecute(cqlQuery, head, environmentAdaptor, workflowAdaptor, pCache);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not answer query, exception: ", (Throwable)e);
            throw e;
        }
    }

    private String retryExecute(String cqlQuery, GCQLNode head, EnvironmentAdaptor environmentAdaptor, WorkflowEngineAdaptor workflowAdaptor, PlanCache pCache) throws Exception {
        MaxSubtreePlanner.cache.invalidateAll();
        PE2ngWorkflowAdaptor.planCache.invalidateAll();
        pCache.clear();
        long before = System.currentTimeMillis();
        PlanNode newPlan = this.preprocessAndPlan(head, environmentAdaptor);
        long after = System.currentTimeMillis();
        this.logger.info("profiling: search plan created in : " + (after - before) + " millis");
        before = System.currentTimeMillis();
        pCache.addPlan(cqlQuery, head, newPlan);
        after = System.currentTimeMillis();
        this.logger.info("adding plan to cache returned after: " + (after - before) + " millis");
        this.logger.info("new plan is : " + cqlQuery + " ---------> " + newPlan.toString());
        return this.execute(newPlan, workflowAdaptor);
    }

    private PlanNode preprocessAndPlan(GCQLNode head, EnvironmentAdaptor environmentAdaptor) throws Exception {
        long before = System.currentTimeMillis();
        for (Preprocessor preprocessor : this.preprocessors) {
            head = preprocessor.preprocess(head);
        }
        long after = System.currentTimeMillis();
        this.logger.info("preprocessing returned after: " + (after - before) + " millis");
        this.logger.info("After preprocessing: " + head.toCQL());
        before = System.currentTimeMillis();
        before = System.currentTimeMillis();
        MaxSubtreePlanner planner = new MaxSubtreePlanner(this.priorities, environmentAdaptor);
        after = System.currentTimeMillis();
        this.logger.info("profiling: MaxSubtreePlanner creation : " + (after - before) + " millis");
        String query = this.getRankMode(head);
        this.logger.error("Query : " + query);
        if (query != null && !query.trim().equals("") && !query.equals("default")) {
            planner.getPriorities().add("fuse");
            planner.setQuery(query);
            head = this.removeRankNode(head);
        } else {
            planner.getPriorities().add("default");
        }
        before = System.currentTimeMillis();
        PlanNode plan = planner.plan(head);
        after = System.currentTimeMillis();
        this.logger.info("profiling: planning stage. planning returned after: " + (after - before) + " millis");
        if (plan == null) {
            throw new Exception("The infrastructure resources are not enough for answering this query. A query plan could not be created. ");
        }
        this.logger.info("After planning: " + plan.toString());
        this.warnings = planner.getWarnings();
        if (this.warnings.size() > 0) {
            this.logger.info("Planner finished with warnings: ");
            for (String warning : this.warnings) {
                this.logger.info("*** " + warning);
            }
        }
        return plan;
    }

    private String execute(PlanNode plan, WorkflowEngineAdaptor workflowAdaptor) throws Exception {
        this.logger.info("Starting execution stage");
        long before = System.currentTimeMillis();
        workflowAdaptor.setSids(this.sids);
        String rsEpr = workflowAdaptor.getExecutionResult(plan);
        long after = System.currentTimeMillis();
        this.logger.info("profiling: workflowAdaptor stage. execution returned after: " + (after - before) + " millis");
        this.logger.info("Execution finished. ResultSet EPR output: " + rsEpr);
        return rsEpr;
    }

    public void setPreprocessors(ArrayList<Preprocessor> preprocessors) {
        this.preprocessors = preprocessors;
    }

    public ArrayList<Preprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    public ArrayList<String> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(ArrayList<String> priorities) {
        this.priorities = priorities;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }

    private GCQLNode removeRankNode(GCQLNode head) {
        if (head instanceof GCQLFuseNode) {
            head = ((GCQLFuseNode)head).subtree;
        }
        return head;
    }

    private String getRankMode(GCQLNode head) {
        if (head instanceof GCQLFuseNode) {
            String rankMode = ((GCQLFuseNode)head).getFuseMode().toCQL();
            head = ((GCQLFuseNode)head).subtree;
            return rankMode;
        }
        if (head instanceof GCQLProjectNode) {
            return this.getRankMode(((GCQLProjectNode)head).subtree);
        }
        if (head instanceof GCQLSortNode) {
            return this.getRankMode(((GCQLSortNode)head).subtree);
        }
        return "default";
    }
}

