/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning.maxsubtree;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Set;
import java.util.Vector;
import org.gcube.searchsystem.planning.commonvocabulary.IndexRelationCommonSemantics;
import org.gcube.searchsystem.planning.exception.CQLUnsupportedException;
import org.gcube.searchsystem.planning.maxsubtree.AndTree;
import org.gcube.searchsystem.planning.maxsubtree.TreeTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.ModifierSet;

public class MaxSubtreeRewritter {
    private Logger logger = LoggerFactory.getLogger((String)MaxSubtreeRewritter.class.getName());
    private GCQLNode root;
    private Vector<ModifierSet> projections = new Vector();

    public MaxSubtreeRewritter(GCQLNode root) {
        this.root = root;
    }

    public ArrayList<AndTree> rewrite() throws CQLUnsupportedException {
        if (this.root instanceof GCQLProjectNode) {
            this.setProjections(((GCQLProjectNode)this.root).getProjectIndexes());
            this.root = ((GCQLProjectNode)this.root).subtree;
        }
        this.logger.trace("Starting push Not Down Or Up");
        long before = Calendar.getInstance().getTimeInMillis();
        ArrayList<Set<TreeTransformer.GCQLCondition>> trees = TreeTransformer.pushNotDownOrUp(this.root, false);
        long after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("PushNotDownOrUp returned after: " + (after - before) + " millis");
        this.logger.trace("trees after push Not Down Or Up");
        for (Set<TreeTransformer.GCQLCondition> tree : trees) {
            this.logger.trace("set of conditions: ");
            for (TreeTransformer.GCQLCondition cond : tree) {
                this.logger.trace("Not: " + cond.not + ", term: " + cond.term.toCQL());
            }
        }
        this.logger.trace("check the validity of the trees");
        before = Calendar.getInstance().getTimeInMillis();
        this.checkValidityTrees(trees);
        after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("CheckValidityTrees returned after: " + (after - before) + " millis");
        ArrayList<AndTree> results = new ArrayList<AndTree>(trees.size());
        this.logger.trace("detecting languages-collections for AndTrees");
        before = Calendar.getInstance().getTimeInMillis();
        for (Set<TreeTransformer.GCQLCondition> tree : trees) {
            AndTree currentResult = this.detectCollectionLang(tree);
            if (currentResult == null) continue;
            results.add(currentResult);
        }
        after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("DetectCollectionLang returned after: " + (after - before) + " millis");
        return results;
    }

    private AndTree detectCollectionLang(Set<TreeTransformer.GCQLCondition> tree) throws CQLUnsupportedException {
        AndTree result = new AndTree();
        for (TreeTransformer.GCQLCondition condition : tree) {
            this.logger.trace("Not: " + condition.not + ", term: " + condition.term.toCQL());
            this.logger.trace("Modifiers size: " + condition.getTerm().getRelation().getModifiers().size());
            if (IndexRelationCommonSemantics.examineCondition(condition, result)) continue;
            this.logger.trace("Collections and languages are contraddicting for this tree:");
            this.logger.trace("set of conditions: ");
            for (TreeTransformer.GCQLCondition cond : tree) {
                this.logger.trace("Not: " + cond.not + ", term: " + cond.term.toCQL());
            }
            return null;
        }
        return result;
    }

    private void checkValidityTrees(ArrayList<Set<TreeTransformer.GCQLCondition>> trees) throws CQLUnsupportedException {
        block0: for (Set<TreeTransformer.GCQLCondition> andConditionSet : trees) {
            for (TreeTransformer.GCQLCondition cond : andConditionSet) {
                if (cond.not) continue;
                continue block0;
            }
            throw new CQLUnsupportedException("tree: " + this.root.toCQL() + ", indicates an pure-NOT part. pure-NOT parts are not supported");
        }
    }

    public Vector<ModifierSet> getProjections() {
        return this.projections;
    }

    public void setProjections(Vector<ModifierSet> projections) {
        boolean foundWild = false;
        for (ModifierSet current : projections) {
            if (!current.getBase().equals("*")) continue;
            foundWild = true;
            break;
        }
        if (foundWild) {
            projections.clear();
            projections.add(new ModifierSet("*"));
        }
        this.projections = projections;
    }
}

