/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.gcube.rest.commons.helpers.ResponseUtils;
import org.gcube.rest.search.commons.SearchDiscovererAPI;
import org.gcube.rest.search.commons.SearchServiceAPI;
import org.gcube.search.exceptions.SearchClientException;
import org.gcube.search.inject.SearchClientModule;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchClient2 {
    private static final Logger logger = LoggerFactory.getLogger(SearchClient2.class);
    private static Gson gson = new Gson();
    private String scope;
    private String endpoint;

    public String getScope() {
        return this.scope;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public SearchClient2(Builder builder) throws SearchClientException {
        this.endpoint = builder.endpoint;
        this.scope = builder.scope;
        SearchDiscovererAPI discoverer = builder.discoverer;
        if (discoverer == null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new SearchClientModule()});
            discoverer = (SearchDiscovererAPI)injector.getInstance(SearchDiscovererAPI.class);
        }
        this.initialize(discoverer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void initialize(SearchDiscovererAPI discoverer) throws SearchClientException {
        boolean found = false;
        try {
            Set endpoints = discoverer.discoverSearchSystemRunninInstances(this.scope);
            logger.info("running instances for searcg service : " + endpoints);
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) throw new SearchClientException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                found = true;
            } else {
                ArrayList endpointList = Lists.newArrayList((Iterable)endpoints);
                Collections.shuffle(endpointList);
                this.endpoint = (String)endpointList.get(0);
                found = true;
            }
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new SearchClientException("could not initialize random client", e);
        }
        if (!found) {
            throw new SearchClientException("could not initialize random client");
        }
        Set ris = discoverer.discoverSearchSystemRunninInstances(this.scope);
        if (ris == null || ris.size() == 0) {
            throw new SearchClientException("No search endopoints found");
        }
        ArrayList searchServices = new ArrayList(ris);
        Collections.shuffle(searchServices);
        this.endpoint = (String)searchServices.get(0);
    }

    public String query(String query, Set<String> sids, Boolean names) throws SearchClientException {
        Response response = null;
        response = sids != null ? SearchClient2.getSearchServiceProxy(this.endpoint).search(this.scope, query, Boolean.valueOf(false), Boolean.valueOf(false), names) : SearchClient2.getSearchServiceProxy(this.endpoint).searchSec(this.scope, query, Boolean.valueOf(false), Boolean.valueOf(false), names, sids);
        try {
            ResponseUtils.checkResponse((Response)response, (String)"query");
        }
        catch (Exception e) {
            throw new SearchClientException(e);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        return (String)resp.get("grslocator");
    }

    public List<Map<String, String>> queryAndRead(String query, Set<String> sids, Boolean names) throws SearchClientException {
        Response response = null;
        response = sids != null ? SearchClient2.getSearchServiceProxy(this.endpoint).searchSec(this.scope, query, Boolean.valueOf(true), Boolean.valueOf(false), names, sids) : SearchClient2.getSearchServiceProxy(this.endpoint).search(this.scope, query, Boolean.valueOf(true), Boolean.valueOf(false), names);
        try {
            ResponseUtils.checkResponse((Response)response, (String)"queryAndRead");
        }
        catch (Exception e) {
            throw new SearchClientException(e);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        List resp = null;
        try {
            resp = (List)gson.fromJson(json, new TypeToken<List<Map<String, String>>>(){}.getType());
        }
        catch (Exception e) {
            logger.error("could not convert response to map object", (Throwable)e);
            throw new SearchClientException("could not convert response to map object", e);
        }
        return resp;
    }

    public Map<String, String> getCollections() throws SearchClientException {
        Response response = SearchClient2.getSearchServiceProxy(this.endpoint).collections(this.scope);
        try {
            ResponseUtils.checkResponse((Response)response, (String)"getCollections");
        }
        catch (Exception e) {
            throw new SearchClientException(e);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        return resp;
    }

    public Map<String, Set<String>> getFields() throws SearchClientException {
        Response response = SearchClient2.getSearchServiceProxy(this.endpoint).collections(this.scope);
        try {
            ResponseUtils.checkResponse((Response)response, (String)"getCollections");
        }
        catch (Exception e) {
            throw new SearchClientException(e);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(json, new TypeToken<Map<String, Set<String>>>(){}.getType());
        return resp;
    }

    private static SearchServiceAPI getSearchServiceProxy(String endpoint) throws SearchClientException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        SearchServiceAPI simple = null;
        logger.info("getting proxy from search service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (SearchServiceAPI)target.proxy(SearchServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new SearchClientException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from sru factory service...OK");
        return simple;
    }

    public static class Builder {
        private String scope;
        private String endpoint;
        private final SearchDiscovererAPI discoverer;

        public Builder(SearchDiscovererAPI discoverer) {
            this.discoverer = discoverer;
        }

        public Builder() {
            this.discoverer = null;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public SearchClient2 build() throws SearchClientException {
            return new SearchClient2(this);
        }
    }
}

