package org.gcube.search.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.search.client.library.proxies.SearchCLDefaultProxy;
import org.gcube.search.client.library.proxies.SearchCLProxyI;
import org.gcube.search.client.library.stubs.SearchStub;
import org.gcube.search.client.library.utils.SearchCLConstants;

/**
 * Search Client Library plugin. Exposes information that allows CL Framework
 * components to act on behalf of Search CL.
 * 
 * @author rena
 * 
 */
public class SearchCLPlugin implements Plugin<SearchStub, SearchCLProxyI> {

	/**
	 * Implementation of Plugin operations. With these callbacks the library
	 * describes Search to the framework.
	 */

	@Override
	public String name() {
		return SearchCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return SearchCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return SearchCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return SearchCLConstants.gcubeName;
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public SearchStub resolve(EndpointReference reference,
			ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(SearchCLConstants.search).at(reference);
	}

	@Override
	public SearchCLDefaultProxy newProxy(ProxyDelegate<SearchStub> delegate) {
		return new SearchCLDefaultProxy(delegate);
	}

}
