/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.GarbageCollector;

import java.io.File;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.resultsetservice.stubs.ReclaimNotificationMessageType;
import org.gcube.common.searchservice.resultsetservice.stubs.ReclaimNotificationMessageWrapperType;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.Arnold;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCHelper;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCPolicy;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCProperties;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.globus.wsrf.impl.SimpleTopic;

public class GarbageCollect
implements Runnable {
    private static Logger log = Logger.getLogger(GarbageCollect.class);
    private static SimpleTopic reclaimingEprs;

    public GarbageCollect(SimpleTopic topic) {
        reclaimingEprs = topic;
    }

    public static void main(String[] args) throws Exception {
        File base = new File("/tmp/resultset/");
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize message digest for SHA-1. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize message digest for SHA-1");
        }
        HashSet<String> checked = new HashSet<String>();
        while (true) {
            Vector<String> reclaimedEprs = new Vector<String>();
            try {
                if (!base.exists() || !base.isDirectory()) {
                    log.warn((Object)"Base directory /tmp/resultset/ is not a directory");
                } else {
                    File[] dirs = base.listFiles();
                    for (int i = 0; i < dirs.length; ++i) {
                        try {
                            if (!dirs[i].isDirectory()) continue;
                            File[] files = dirs[i].listFiles();
                            for (int q = 0; q < files.length; ++q) {
                                try {
                                    log.trace((Object)("checking for file " + files[q].toString()));
                                    if (!files[q].exists()) {
                                        log.trace((Object)"doesn't exist aymore");
                                        continue;
                                    }
                                    if (GCHelper.alreadyChecked(files[q].toString(), algorithm, checked)) continue;
                                    if (files[q].isFile() && (files[q].toString().endsWith(".prs") || files[q].toString().endsWith(".tmp"))) {
                                        if (!GCPolicy.reclaim(files[q])) continue;
                                        Arnold.terminate(files[q]);
                                        continue;
                                    }
                                    if (files[q].isFile() && files[q].toString().endsWith(".rs") && !new File(RSFileHelper.contentToHeader((String)files[q].toString())).exists()) {
                                        if (!GCPolicy.reclaim(files[q])) continue;
                                        Arnold.terminate(files[q]);
                                        continue;
                                    }
                                    if (!files[q].isFile() || !files[q].toString().endsWith(".hrs")) continue;
                                    GCProperties props = new GCProperties();
                                    props.addToChain(files[q].toString());
                                    String head = GCHelper.goToHead(files[q].toString(), props);
                                    String tail = GCHelper.goToLast(files[q].toString(), props);
                                    GCHelper.headPoperties(head, props);
                                    GCHelper.tailPoperties(tail, props);
                                    if (GCPolicy.reclaim(props)) {
                                        for (int j = 0; j < props.getWSEPRs().size(); ++j) {
                                            reclaimedEprs.add(props.getWSEPRs().get(j));
                                        }
                                        Arnold.terminate(props);
                                        continue;
                                    }
                                    for (int chain = 0; chain < props.getChainOfFiles().size(); ++chain) {
                                        GCHelper.alreadyChecked(props.getChainOfFiles().get(chain), algorithm, checked);
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    log.error((Object)"Could not evaluate file. Continuing", (Throwable)e);
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)"Could not evaluate directory. Continuing", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not complete iteration. Continuing", (Throwable)e);
            }
            try {
                String[] eprArray = reclaimedEprs.toArray(new String[reclaimedEprs.size()]);
                if (eprArray != null && eprArray.length > 0) {
                    ReclaimNotificationMessageType msg = new ReclaimNotificationMessageType();
                    msg.setReclaimedEpr(eprArray);
                    ReclaimNotificationMessageWrapperType wrapper = new ReclaimNotificationMessageWrapperType(msg);
                    reclaimingEprs.notify((Object)wrapper);
                    log.info((Object)("notification sent for " + eprArray.length + " eprs: "));
                    for (int j = 0; j < eprArray.length; ++j) {
                        log.info((Object)(j + ": " + eprArray[j]));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not send Notification. Continuing", (Throwable)e);
            }
            checked.clear();
            try {
                log.info((Object)"Garbadge collector sleep");
                Thread.sleep(300000L);
                continue;
            }
            catch (Exception e) {
                log.info((Object)"Garbadge collector wake up");
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        try {
            log.info((Object)"Garbadge collector to start in 10");
            Thread.currentThread().setPriority(1);
            Thread.sleep(300000L);
            log.info((Object)"Garbadge collector is enabled");
            GarbageCollect.main(null);
        }
        catch (Exception e) {
            log.error((Object)"Garbadge collector failed to start", (Throwable)e);
        }
    }
}

