/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.security.KeyPair;
import java.util.Calendar;
import java.util.Date;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBean;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementXBean;
import org.gcube.common.searchservice.searchlibrary.resultset.security.KeyGenerator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolConfig;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolObjectConfig;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterCreationParams;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;

public class RSXMLTester {
    String inFile = null;
    String outFile = null;
    RSResourceType RSType = null;
    RSResourceType MKlocalType = null;
    int recsperpart = 20;
    int bytesperpart = 102400;
    boolean verbose = false;
    boolean makelocal = false;

    public static void main(String[] args) {
        RSXMLTester tester = new RSXMLTester();
        try {
            tester.PerformTest(args);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void printUsage() {
        System.err.println("Usage: java RSXMLTester [Options] \nOptions:\n-if <content Filename>\n-of <output Filename>\n-recsperpart <records per part>\n-partsize <bytes per part>\n-verbose \t\t Console output\n-type #id \t\t 0 for RSLocalType (default) or 1 for RSWSRFType\n-makelocal #id \t\t try make local along with the test selected\n-endpoint <service URL> \t\t in case of RSWSRFType\n-test #id \t\t Test to perform \n\t\t\t 0 for no extrafunctionality (default) \n\t\t\t 1 for new style RS creation \n\t\t\t 2 for access leasing test \n\t\t\t 3 for RS Forward test \n\t\t\t 4 for time leasing test \n\t\t\t 5 for forward+access leasing test (the last reader should remove the RS as he reads it) \n\t\t\t 6 for encryption test \n\t\t\t 7 for scope test \n\t\t\t 8 for makelocal test \n\t\t\t 9 for clone test\n\t\t\t 10 for pool test\n\t\t\t 11 for long RS test\n\t\t\t 12 for XStream Bean test\n\t\t\t 13 for Bean test\n");
    }

    private void PerformTest(String[] args) {
        try {
            String RStypeID = null;
            String MKlocaltypeID = null;
            String WSRFEndPoint = null;
            String testID = "0";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("--help")) {
                    this.printUsage();
                    System.exit(1);
                }
                if (args[i].equalsIgnoreCase("-if")) {
                    this.inFile = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-of")) {
                    this.outFile = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-type")) {
                    RStypeID = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-endpoint")) {
                    WSRFEndPoint = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-test")) {
                    testID = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-recsperpart")) {
                    this.recsperpart = Integer.parseInt(args[i + 1]);
                }
                if (args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                }
                if (args[i].equalsIgnoreCase("-makelocal")) {
                    MKlocaltypeID = args[i + 1];
                    this.makelocal = true;
                }
                if (!args[i].equalsIgnoreCase("-partsize")) continue;
                this.bytesperpart = Integer.parseInt(args[i + 1]);
            }
            this.RSType = this.CreateRSResourceType(RStypeID, WSRFEndPoint);
            this.MKlocalType = this.CreateMakeLocalRSResourceType(MKlocaltypeID, WSRFEndPoint);
            if (testID.equalsIgnoreCase("0")) {
                this.PlainTest();
            }
            if (testID.equalsIgnoreCase("1")) {
                this.NewCreationTest();
            }
            if (testID.equalsIgnoreCase("2")) {
                this.AccessTest();
            }
            if (testID.equalsIgnoreCase("3")) {
                this.ForwardTest();
            }
            if (testID.equalsIgnoreCase("4")) {
                this.TimeTest();
            }
            if (testID.equalsIgnoreCase("5")) {
                this.EraseTest();
            }
            if (testID.equalsIgnoreCase("6")) {
                this.EncryptionTest();
            }
            if (testID.equalsIgnoreCase("7")) {
                this.ScopeTest();
            }
            if (testID.equalsIgnoreCase("8")) {
                this.MakeLocalTest();
            }
            if (testID.equalsIgnoreCase("9")) {
                this.CloneTest();
            }
            if (testID.equalsIgnoreCase("10")) {
                this.PoolTest();
            }
            if (testID.equalsIgnoreCase("11")) {
                this.LongTest();
            }
            if (testID.equalsIgnoreCase("12")) {
                this.XBeanTest();
            }
            if (testID.equalsIgnoreCase("13")) {
                this.BeanTest();
            }
            System.out.println("Test Passed");
        }
        catch (Exception x) {
            System.out.println("Run with --help paametre to see the commandline options\n");
            x.printStackTrace();
        }
    }

    private void CloneTest() throws Exception {
        int i;
        ResultElementBase[] res;
        int i2;
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        writer.setRecsPerPart(this.recsperpart);
        writer.setPartSize(this.bytesperpart);
        for (int i3 = 0; i3 < 30; ++i3) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i3, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        FileWriter fww = new FileWriter(this.outFile + ".1.orig");
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            ResultElementBase[] res2 = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res2.length);
            for (int i4 = 0; i4 < res2.length; ++i4) {
                bww.write(((ResultElementGeneric)res2[i4]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        RSXMLReader newreader = reader.cloneRS();
        fww = new FileWriter(this.outFile + ".1.clone");
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            ResultElementBase[] res3 = newreader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res3.length);
            for (i2 = 0; i2 < res3.length; ++i2) {
                bww.write(((ResultElementGeneric)res3[i2]).getPayload() + "\n");
            }
        } while (newreader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setForward(true);
        writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
        }
        writer.close();
        epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        l = new RSLocator(epr);
        reader = RSXMLReader.getRSXMLReader(l);
        fww = new FileWriter(this.outFile + ".2.orig");
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        newreader = reader.cloneRS();
        fww = new FileWriter(this.outFile + ".2.clone");
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = newreader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (newreader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void MakeLocalTest() throws Exception {
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        writer.setRecsPerPart(this.recsperpart);
        writer.setPartSize(this.bytesperpart);
        for (int i = 0; i < 30; ++i) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            ResultElementBase[] res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (int i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Make local");
        RSXMLReader newreader = reader.makeLocal(this.MKlocalType);
        fww = null;
        bww = null;
        fww = new FileWriter(this.outFile + ".local");
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            ResultElementBase[] res = newreader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (int i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (newreader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Make enchanced");
        GCUBEScope OK_scope = GCUBEScope.getScope((String)"/gcube/devsec");
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setAccessReads(45);
        initParams.setForward(true);
        newreader = reader.makeLocal(this.MKlocalType, initParams, OK_scope);
        fww = null;
        bww = null;
        fww = new FileWriter(this.outFile + ".local.extra");
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            ResultElementBase[] res = newreader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (int i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (newreader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void MakeLocalTest(RSXMLReader reader) throws Exception {
        if (!this.makelocal) {
            return;
        }
        try {
            RSXMLReader newreader = reader.makeLocal(this.MKlocalType);
            FileWriter fww = null;
            BufferedWriter bww = null;
            fww = new FileWriter(this.outFile + ".local");
            bww = new BufferedWriter(fww);
            int q = 0;
            do {
                ++q;
                ResultElementBase[] res = newreader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (int i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (newreader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            this.Print("Make local test failed");
            throw x;
        }
        this.Print("Make local test was a success");
        reader.getFirstPart();
    }

    private void ScopeTest() throws Exception {
        int i;
        ResultElementBase[] res;
        GCUBEScope OK_scope = GCUBEScope.getScope((String)"/gcube/devsec");
        GCUBEScope WRONG_scope = GCUBEScope.getScope((String)"/gcube/foo");
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (int i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType, OK_scope).getLocator();
        RSLocator l = null;
        RSXMLReader reader = null;
        FileWriter fww = null;
        BufferedWriter bww = null;
        int q = 0;
        try {
            this.Print("Starting rs reader No Scope");
            l = new RSLocator(epr);
            reader = RSXMLReader.getRSXMLReader(l);
            this.MakeLocalTest(reader);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            this.Print("Read failed. This is correct!");
        }
        this.Print("Starting rs re-reader WRONG scope");
        try {
            l = new RSLocator(epr);
            l.setScope(WRONG_scope);
            reader = RSXMLReader.getRSXMLReader(l);
            this.MakeLocalTest(reader);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            this.Print("Read failed. This is correct!");
        }
        this.Print("Starting rs re-reader OK scope");
        l = new RSLocator(epr);
        l.setScope(OK_scope);
        reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        fww = new FileWriter(this.outFile);
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void EncryptionTest() throws Exception {
        int i;
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        KeyGenerator kg = new KeyGenerator();
        KeyPair pair = kg.GenKeyPair();
        initParams.setPrivKey(pair.getPrivate());
        initParams.setPubKey(pair.getPublic());
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (int i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        RSLocator l = null;
        RSXMLReader reader = null;
        FileWriter fww = null;
        BufferedWriter bww = null;
        int q = 0;
        try {
            this.Print("Starting rs reader (1)");
            l = new RSLocator(epr);
            reader = RSXMLReader.getRSXMLReader(l);
            this.MakeLocalTest(reader);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            this.Print("Read failed. This is correct!");
        }
        this.Print("Starting rs re-reader (2)");
        l = new RSLocator(epr);
        l.setPrivKey(pair.getPrivate());
        reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        fww = new FileWriter(this.outFile);
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void EraseTest() throws Exception {
        int i;
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setAccessReads(2);
        initParams.setForward(true);
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (int i2 = 0; i2 < 300; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader (1)");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs re-reader (2)");
        try {
            l = new RSLocator(epr);
            reader = RSXMLReader.getRSXMLReader(l);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            if (this.RSType instanceof RSResourceWSRFType) {
                this.Print("Read failed. This is correct!");
            }
            this.Print("Read failed ??????????????");
            throw x;
        }
        try {
            this.Print("Starting rs re-reader (3)");
            l = new RSLocator(epr);
            reader = RSXMLReader.getRSXMLReader(l);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            this.Print("Read failed. This is correct!");
        }
        System.out.println("Now check under /tmp/resultset that the newelly created RS does not have 300 records");
    }

    private void TimeTest() throws Exception {
        int i;
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setExpire_date(new Date(Calendar.getInstance().getTimeInMillis() + 60000L));
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (int i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader (1)");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        try {
            this.Print("Sleeping!");
            Thread.sleep(60000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.Print("Starting rs re-reader (2)");
            l = new RSLocator(epr);
            reader = RSXMLReader.getRSXMLReader(l);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            this.Print("Read failed. This is correct!");
        }
    }

    private void ForwardTest() throws Exception {
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setForward(true);
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (int i = 0; i < 30; ++i) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader (1)");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (int i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs re-reader (2)");
        l = new RSLocator(epr);
        reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        fww = new FileWriter(this.outFile);
        bww = new BufferedWriter(fww);
        q = 0;
        while (true) {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (int i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
            if (!reader.getNextPart()) break;
            try {
                reader.getPreviousPart();
            }
            catch (Exception x) {
                this.Print("Get previews part failed. This is orrect!");
            }
        }
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void AccessTest() throws Exception {
        int i;
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setAccessReads(2);
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (int i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader (1)");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs re-reader (2)");
        try {
            l = new RSLocator(epr);
            reader = RSXMLReader.getRSXMLReader(l);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            if (this.RSType instanceof RSResourceWSRFType) {
                this.Print("Read failed. This is correct!");
            }
            this.Print("Read failed ??????????????");
            throw x;
        }
        this.Print("Starting rs re-reader (3)");
        try {
            l = new RSLocator(epr);
            reader = RSXMLReader.getRSXMLReader(l);
            fww = new FileWriter(this.outFile);
            bww = new BufferedWriter(fww);
            q = 0;
            do {
                ++q;
                res = reader.getResults(ResultElementGeneric.class);
                this.Print("ResultLength: " + res.length);
                for (i = 0; i < res.length; ++i) {
                    bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
                }
            } while (reader.getNextPart());
            this.Print("parts=" + q);
            bww.close();
            fww.close();
        }
        catch (Exception x) {
            this.Print("Read failed. This is correct!");
        }
    }

    private void NewCreationTest() throws Exception {
        int i;
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(initParams);
        for (int i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs re-reader");
        l = new RSLocator(epr);
        reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        fww = new FileWriter(this.outFile);
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void PlainTest() throws Exception {
        int i;
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        FileWriter fw = new FileWriter(this.outFile);
        BufferedWriter bw = new BufferedWriter(fw);
        this.Print("Starting rs writer");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        writer.setRecsPerPart(this.recsperpart);
        writer.setPartSize(this.bytesperpart);
        for (int i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
            bw.write(content);
        }
        writer.close();
        bw.close();
        fw.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs re-reader");
        l = new RSLocator(epr);
        reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        fww = new FileWriter(this.outFile);
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void PoolTest() throws Exception {
        int i;
        ResultElementBase[] res;
        PoolConfig config = new PoolConfig();
        PoolObjectConfig objConf = new PoolObjectConfig();
        objConf.FlowControl = false;
        objConf.MaxSize = 4;
        objConf.MinSize = 2;
        objConf.ObjectType = RSPoolObject.PoolObjectType.WriterXML;
        objConf.ResourceType = RSPoolObject.PoolObjectResourceType.WSRFType;
        objConf.ServiceEndPoint = null;
        config.add(objConf);
        String content = this.ReadContent(this.inFile);
        FileWriter fw = new FileWriter(this.outFile);
        BufferedWriter bw = new BufferedWriter(fw);
        this.Print("Starting rs writer");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        writer.setRecsPerPart(this.recsperpart);
        writer.setPartSize(this.bytesperpart);
        for (int i2 = 0; i2 < 30; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
            bw.write(content);
        }
        writer.close();
        bw.close();
        fw.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs re-reader");
        l = new RSLocator(epr);
        reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        fww = new FileWriter(this.outFile);
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private String ReadContent(String inputFile) throws Exception {
        FileReader fr = new FileReader(inputFile);
        BufferedReader br = new BufferedReader(fr);
        StringBuilder buf = new StringBuilder();
        String line = br.readLine();
        while (line != null) {
            buf.append(line);
            line = br.readLine();
        }
        br.close();
        fr.close();
        return buf.toString();
    }

    private void LongTest() throws Exception {
        int i;
        ResultElementBase[] res;
        String content = this.ReadContent(this.inFile);
        FileWriter fw = new FileWriter(this.outFile);
        BufferedWriter bw = new BufferedWriter(fw);
        this.Print("Starting rs writer");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        writer.setRecsPerPart(this.recsperpart);
        writer.setPartSize(this.bytesperpart);
        for (int i2 = 0; i2 < 300; ++i2) {
            writer.addResults((ResultElementBase)new ResultElementGeneric("id" + i2, "foo", content));
            bw.write(content);
        }
        writer.close();
        bw.close();
        fw.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        FileWriter fww = new FileWriter(this.outFile);
        BufferedWriter bww = new BufferedWriter(fww);
        int q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
        this.Print("Starting rs slow re-reader");
        l = new RSLocator(epr);
        reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        fww = new FileWriter(this.outFile);
        bww = new BufferedWriter(fww);
        q = 0;
        do {
            ++q;
            res = reader.getResults(ResultElementGeneric.class);
            this.Print("ResultLength: " + res.length);
            for (i = 0; i < res.length; ++i) {
                if (i % this.recsperpart == 0) {
                    Thread.sleep(2000000L);
                }
                bww.write(((ResultElementGeneric)res[i]).getPayload() + "\n");
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
        bww.close();
        fww.close();
    }

    private void BeanTest() throws Exception {
        this.Print("Starting rs writer");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        writer.setRecsPerPart(this.recsperpart);
        writer.setPartSize(this.bytesperpart);
        for (int i = 0; i < 300; ++i) {
            DemoBean demo = new DemoBean();
            demo.setHello("Hello " + i);
            ResultElementBean bean = new ResultElementBean();
            bean.setBean((Object)demo);
            writer.addResults((ResultElementBase)bean);
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        int q = 0;
        do {
            ++q;
            ResultElementBase[] res = reader.getResults(ResultElementBean.class);
            this.Print("ResultLength: " + res.length);
            for (int i = 0; i < res.length; ++i) {
                ResultElementBean bean = (ResultElementBean)res[i];
                DemoBean demo = (DemoBean)bean.getBean();
                this.Print(demo.getHello());
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
    }

    private void XBeanTest() throws Exception {
        this.Print("Starting rs writer");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        writer.setRecsPerPart(this.recsperpart);
        writer.setPartSize(this.bytesperpart);
        for (int i = 0; i < 300; ++i) {
            DemoBean demo = new DemoBean();
            demo.setHello("Hello " + i);
            ResultElementXBean bean = new ResultElementXBean();
            bean.setBean((Object)demo);
            writer.addResults((ResultElementBase)bean);
        }
        writer.close();
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSXMLReader reader = RSXMLReader.getRSXMLReader(l);
        this.MakeLocalTest(reader);
        int q = 0;
        do {
            ++q;
            ResultElementBase[] res = reader.getResults(ResultElementXBean.class);
            this.Print("ResultLength: " + res.length);
            for (int i = 0; i < res.length; ++i) {
                ResultElementXBean bean = (ResultElementXBean)res[i];
                DemoBean demo = (DemoBean)bean.getBean();
                this.Print(demo.getHello());
            }
        } while (reader.getNextPart());
        this.Print("parts=" + q);
    }

    private RSResourceType CreateMakeLocalRSResourceType(String stypeID, String endPoint) throws Exception {
        if (stypeID == null) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("0")) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("1")) {
            return new RSResourceWSRFType(endPoint);
        }
        return new RSResourceLocalType();
    }

    private RSResourceType CreateRSResourceType(String stypeID, String endPoint) throws Exception {
        if (stypeID == null) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("0")) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("1")) {
            return new RSResourceWSRFType(endPoint);
        }
        return new RSResourceLocalType();
    }

    private void Print(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }
}

