/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsreader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.KeepTopThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.InitReaderThread;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.MakeLocalThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocationWrapper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.ReaderInitParams;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterCreationParams;

public class RSBLOBReader
extends RSReader {
    private static Logger log = Logger.getLogger(RSBLOBReader.class);
    RSLocationWrapper rs = null;

    public static RSBLOBReader getRSBLOBReader(RSLocator locator) throws Exception {
        try {
            return new RSBLOBReader(new RSLocationWrapper(locator));
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSBLOBReader Throwing Exception", (Throwable)e);
            throw new Exception("Could not create RSBLOBReader");
        }
    }

    public static RSBLOBReader[] getRSBLOBReader(ReaderInitParams[] params) {
        int i;
        InitReaderThread[] ts = new InitReaderThread[params.length];
        RSBLOBReader[] rs = new RSBLOBReader[params.length];
        for (i = 0; i < params.length; ++i) {
            ts[i] = new InitReaderThread(params[i], InitReaderThread.RSReaderEnum.BLOBReader);
            ts[i].start();
        }
        for (i = 0; i < params.length; ++i) {
            try {
                ts[i].join();
                rs[i] = (RSBLOBReader)ts[i].getReader();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"interrupted whil waiting for reader. setting to null");
                rs[i] = null;
            }
        }
        return rs;
    }

    protected RSBLOBReader(RSLocationWrapper rs) {
        super(rs);
        this.rs = rs;
    }

    public RSBLOBIterator getRSIterator() throws Exception {
        try {
            return new RSBLOBIterator(RSBLOBReader.getRSBLOBReader(this.getRSLocator()));
        }
        catch (Exception e) {
            log.error((Object)"could not create iterator. Throwing Exception", (Throwable)e);
            throw new Exception("could not create iterator");
        }
    }

    protected ResultElementBLOBBase getResults(Class template) {
        log.info((Object)"getResults called.");
        try {
            if (!this.getNextPart()) {
                return null;
            }
            ResultElementBLOBBase tmp = (ResultElementBLOBBase)template.newInstance();
            tmp.RS_fromXML(this.rs.getResults(0));
            if (!this.getNextPart()) {
                log.error((Object)"incomplete chain of pages. Could not retrieve content. returning null");
            }
            if (this.rs.isSecure()) {
                log.info((Object)"RS is secure.");
                tmp.setContentOfBLOB((InputStream)new ByteArrayInputStream(this.rs.getCurrentContentPartPayload().getBytes()));
            } else {
                log.info((Object)"RS is not secure.");
                tmp.setContentOfBLOB((InputStream)new FileInputStream(new File(this.getCurrentContentPart())));
            }
            return tmp;
        }
        catch (Exception e) {
            log.info((Object)("Could not get result. returning null " + e.getMessage()));
            return null;
        }
    }

    @Override
    public RSBLOBReader makeLocal(RSResourceType type) throws Exception {
        log.trace((Object)"RS makelocal called");
        return RSBLOBReader.getRSBLOBReader(super.makeLocal(type).getRSLocator());
    }

    @Override
    public RSBLOBReader makeLocal(RSResourceType type, int count) throws Exception {
        if (count < 0) {
            log.error((Object)"invalid topCount argument. Throwing Exception");
            throw new Exception("invalid topCount argument");
        }
        try {
            return this.keepTop(count).makeLocal(type);
        }
        catch (Exception e) {
            log.error((Object)"could not perform partial localization. Throwing Exception", (Throwable)e);
            throw new Exception("could not perform partial localization");
        }
    }

    public RSBLOBReader makeLocal(RSResourceType type, RSWriterCreationParams params, GCUBEScope scope) throws Exception {
        try {
            RSReader thisReader = RSReader.getRSReader(this.getRSLocator());
            RSFullWriter writer = RSFullWriter.getRSFullWriter(params);
            if (!(type instanceof RSResourceLocalType) && !(type instanceof RSResourceWSRFType)) {
                log.error((Object)"not regognized resource type.Throwing Exception");
                throw new Exception("not regognized resource type.Throwing Exception");
            }
            MakeLocalThreadGeneric worker = new MakeLocalThreadGeneric(writer, thisReader, MakeLocalThreadGeneric.CLEAR, this.rs.getStaticPort(), this.rs.getSSLsupport());
            worker.start();
            RSLocator newlocator = writer.getRSLocator(type, scope, params.getPrivKey());
            newlocator.setPrivKey(params.getPrivKey());
            newlocator.setScope(scope);
            return RSBLOBReader.getRSBLOBReader(newlocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not make local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not make local");
        }
    }

    @Override
    public RSBLOBReader keepTop(int count, PropertyElementBase[] properties) throws Exception {
        try {
            if (properties == null || properties.length == 0) {
                log.error((Object)"Cannot initialize Result Set with empty property list. Throwing Exception");
                throw new Exception("Cannot initialize Result Set with empty property list");
            }
            String[] props = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                props[i] = properties[i].RS_toXML();
            }
            String headName = this.rs.keepTop(2 * count, props, KeepTopThreadGeneric.PERPART);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSBLOBReader.getRSBLOBReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    @Override
    public RSBLOBReader keepTop(int count) throws Exception {
        try {
            String headName = this.rs.keepTop(2 * count, KeepTopThreadGeneric.PERPART);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSBLOBReader.getRSBLOBReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    @Override
    public RSBLOBReader cloneRS() throws Exception {
        try {
            return RSBLOBReader.getRSBLOBReader(super.cloneRS().getRSLocator());
        }
        catch (Exception e) {
            log.error((Object)"Could not clone rs. Throwing Exception", (Throwable)e);
            throw new Exception("Could not clone rs");
        }
    }
}

