/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.filter;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.io.StringReader;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class FilterWorker<T extends Record>
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)FilterWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    private IRecordReader<T> reader = null;
    private String payloadFieldName = null;
    private String xPath = null;
    private StatsContainer stats = null;
    private long timeout;
    private TimeUnit timeUnit;

    public FilterWorker(IRecordReader<T> reader, IRecordWriter<Record> writer, String payloadFieldName, String xPath, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this.reader = reader;
        this.writer = writer;
        this.payloadFieldName = payloadFieldName;
        this.xPath = xPath;
        this.stats = stats;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block32: {
            start = Calendar.getInstance().getTimeInMillis();
            firstInputStop = 0L;
            firstOutputStop = 0L;
            rc = 0;
            try {
                XPathExpression expr;
                XPathFactory xpf = XPathFactory.newInstance();
                try {
                    XPath xpath = xpf.newXPath();
                    expr = xpath.compile(this.xPath);
                }
                catch (Exception ee) {
                    logger.error("Could not compile XPath expression.", (Throwable)ee);
                    try {
                        this.writer.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.writer.close();
                        this.reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            String payload;
                            Record rec;
                            block33: {
                                if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                    break block32;
                                }
                                rec = this.reader.get(this.timeout, this.timeUnit);
                                if (rec == null) {
                                    if (this.reader.getStatus() == IBuffer.Status.Open) {
                                        logger.warn("Producer has timed out");
                                    }
                                    break block32;
                                }
                                if (rc == 0) {
                                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                                }
                                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                                    logger.info("Consumer side stopped consumption. Stopping.");
                                    break block32;
                                }
                                payload = null;
                                try {
                                    Field key = rec.getField(this.payloadFieldName);
                                    if (!(key instanceof StringField)) break block33;
                                    payload = ((StringField)key).getPayload();
                                }
                                catch (Exception e) {
                                    logger.warn("Could not extract payload from record #" + rc + ". Continuing");
                                    continue;
                                }
                            }
                            String filtered = null;
                            if (payload != null) {
                                filtered = expr.evaluate(new InputSource(new StringReader(payload)));
                                ((StringField)rec.getField(this.payloadFieldName)).setPayload(filtered);
                            }
                            if (!this.writer.importRecord(rec, this.timeout, this.timeUnit)) {
                                if (this.writer.getStatus() == IBuffer.Status.Open) {
                                    logger.warn("Consumer has timed out");
                                }
                                break block32;
                            }
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error during background transformation. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.writer.close();
                    this.reader.close();
                }
                catch (Exception e) {}
            }
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults(rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        logger.info("FILTER OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }
}

