/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.keeptop;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.keeptop.KeepTopWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepTopOp {
    private Logger logger = LoggerFactory.getLogger((String)KeepTopOp.class.getName());
    private URI inLocator = null;
    private StatsContainer stats = null;
    private static final long TimeoutDef = 60L;
    private static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;

    public KeepTopOp(URI locator, StatsContainer stats) {
        this.inLocator = locator;
        this.stats = stats;
    }

    public KeepTopOp(URI locator, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this(locator, stats);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public URI compute(int count) throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            ForwardReader reader = new ForwardReader(this.inLocator);
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), (IRecordReader)reader);
            KeepTopWorker worker = new KeepTopWorker(reader, writer, count, this.stats, this.timeout, this.timeUnit);
            worker.start();
            long readerstop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToInitialize(readerstop - start);
            return writer.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not start background process of keep top operator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not start background process of keep top operator");
        }
    }
}

