/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.join;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.JoinElement;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashJoin {
    private static Logger logger = LoggerFactory.getLogger((String)HashJoin.class.getName());
    private Hashtable<String, JoinElement> hash = new Hashtable();

    public JoinElement lookup(JoinElement elem) {
        try {
            return this.hash.get(elem.getValue().getKey());
        }
        catch (Exception e) {
            logger.error("Could not lookup for element. returning null", (Throwable)e);
            return null;
        }
    }

    public void add(JoinElement elem) {
        try {
            JoinElement inHash = this.lookup(elem);
            if (inHash == null) {
                this.hash.put(elem.getValue().getKey(), elem);
            } else {
                for (int i = 0; i < elem.getRecordIndices().size(); ++i) {
                    inHash.getRecordIndices().add(elem.getRecordIndices().get(i));
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not add element. Continuing", (Throwable)e);
        }
    }

    public boolean isEmpty() {
        try {
            return this.hash.size() <= 0;
        }
        catch (Exception e) {
            logger.error("Could not get hashtable size. Returing true", (Throwable)e);
            return true;
        }
    }
}

