/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.select;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.select.Binder;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.select.Evaluator;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectWorker<T extends Record>
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)SelectWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    private IRecordReader<T> reader = null;
    private String logicalExpressions = null;
    private StatsContainer stats = null;
    private Integer[] mask;
    private long timeout;
    private TimeUnit timeUnit;

    public SelectWorker(IRecordReader<T> reader, IRecordWriter<Record> writer, String logicalExpressions, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this.reader = reader;
        this.writer = writer;
        this.logicalExpressions = logicalExpressions;
        this.stats = stats;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public SelectWorker(IRecordReader<T> reader, IRecordWriter<Record> writer, String logicalExpressions, Integer[] mask, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this(reader, writer, logicalExpressions, stats, timeout, timeUnit);
        this.mask = mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block32: {
            Thread.currentThread().setName(SelectWorker.class.getName());
            start = Calendar.getInstance().getTimeInMillis();
            firstInputStop = 0L;
            firstOutputStop = start;
            rc = 0;
            HashMap<String, String> bindings = new HashMap<String, String>();
            Set<Object> refs = new HashSet();
            Binder binder = null;
            if (this.logicalExpressions != null) {
                binder = new Binder(this.logicalExpressions, "\\[(\\w+)\\]");
                refs = binder.getSubstitutions();
            }
            try {
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                break block32;
                            }
                            Record rec = this.reader.get(this.timeout, this.timeUnit);
                            if (rec == null) {
                                if (this.reader.getStatus() == IBuffer.Status.Open) {
                                    logger.warn("Producer has timed out");
                                }
                                break block32;
                            }
                            if (rc == 0) {
                                firstInputStop = Calendar.getInstance().getTimeInMillis();
                            }
                            if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                                logger.info("Consumer side stopped consumption. Stopping.");
                                break block32;
                            }
                            bindings.clear();
                            for (String string : refs) {
                                try {
                                    Field key = rec.getField(string);
                                    if (key == null) {
                                        if (string.matches("\\d+")) {
                                            key = rec.getField(Integer.parseInt(string));
                                        }
                                        if (key == null) {
                                            throw new Exception("Referenced field: " + string + " is null");
                                        }
                                    }
                                    if (key instanceof StringField) {
                                        bindings.put(string, ((StringField)key).getPayload());
                                        continue;
                                    }
                                    throw new Exception("Refence: " + key.getFieldDefinition().getName() + " is not a String field");
                                }
                                catch (Exception e) {
                                    logger.warn("Could not extract payload from record #" + rc + ". Continuing", (Throwable)e);
                                }
                            }
                            if (binder != null && !Evaluator.jsEvaluator(binder.substitute(bindings))) continue;
                            if (this.mask != null) {
                                void var13_17;
                                Field[] fields = new Field[this.mask.length];
                                boolean bl = false;
                                while (var13_17 < this.mask.length) {
                                    fields[var13_17] = rec.getField(this.mask[var13_17].intValue());
                                    ++var13_17;
                                }
                                rec.setFields(fields);
                            }
                            if (!this.writer.importRecord(rec, this.timeout, this.timeUnit)) {
                                if (this.writer.getStatus() == IBuffer.Status.Open) {
                                    logger.warn("Consumer has timed out");
                                }
                                break block32;
                            }
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Error during background transformation. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.writer.close();
                    this.reader.close();
                }
                catch (Exception e) {}
            }
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults(rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        logger.info("SELECT OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }
}

