/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge;

import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.EventEntry;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler<T extends Record> {
    private static Logger logger = LoggerFactory.getLogger((String)EventHandler.class.getName());
    private RecordWriter<T> writer = null;
    private Queue<EventEntry> eventQueue = null;
    private boolean finalReceivedFromAll = false;
    private boolean[] finalReceived = null;
    private int finalReceivedCount = 0;
    private boolean finalSent = false;
    private int[] currentResultCount = null;
    private int currentResultCountSum = 0;
    private int previousResultCountSum = 0;
    private int writerResultCount = 0;
    private int previousEmissionCheckpoint = 0;
    private int emissionStep = 0;
    private int readerCount;

    public EventHandler(RecordWriter<T> writer, Queue<EventEntry> eventQueue, int readerCount, int emissionStep) {
        this.writer = writer;
        this.eventQueue = eventQueue;
        this.readerCount = readerCount;
        this.emissionStep = emissionStep;
        this.finalReceived = new boolean[readerCount];
        this.currentResultCount = new int[readerCount];
        this.finalReceivedFromAll = false;
        for (int i = 0; i < readerCount; ++i) {
            this.currentResultCount[i] = 0;
            this.finalReceived[i] = false;
        }
    }

    private void setFinalReceived(int id) {
        if (!this.finalReceived[id]) {
            this.finalReceived[id] = true;
            if (++this.finalReceivedCount == this.readerCount) {
                this.finalReceivedFromAll = true;
            }
        }
    }

    private void setAndUpdateCurrentCount(int id, int count) {
        if (!this.finalReceived[id]) {
            int prev = this.currentResultCount[id];
            this.currentResultCount[id] = count;
            this.currentResultCountSum = this.currentResultCountSum - prev + count;
        }
    }

    private void emitEvent(BufferEvent ev) {
        try {
            this.writer.emit(ev);
        }
        catch (Exception e) {
            logger.info("Could not emit event", (Throwable)e);
        }
    }

    private void propagateNonResultEvent(BufferEvent ev) {
        if (ev instanceof KeyValueEvent) {
            if (((KeyValueEvent)ev).getKey().equals("resultsNumber") || ((KeyValueEvent)ev).getKey().equals("resultsNumberFinal")) {
                return;
            }
            this.emitEvent(ev);
        } else {
            this.emitEvent(ev);
        }
    }

    public void propagateEvents() {
        if (this.finalReceivedFromAll) {
            EventEntry ev = null;
            while ((ev = this.eventQueue.poll()) != null) {
                this.propagateNonResultEvent(ev.event);
            }
            return;
        }
        EventEntry ev = null;
        KeyValueEvent resultEvent = null;
        this.previousResultCountSum = this.currentResultCountSum;
        boolean received = false;
        while ((ev = this.eventQueue.poll()) != null) {
            if (!(ev.event instanceof KeyValueEvent)) {
                this.emitEvent(ev.event);
                continue;
            }
            resultEvent = (KeyValueEvent)ev.event;
            if (resultEvent.getKey().equals("resultsNumberFinal")) {
                this.setAndUpdateCurrentCount(ev.id, Integer.parseInt(resultEvent.getValue()));
                this.setFinalReceived(ev.id);
                received = true;
                continue;
            }
            if (resultEvent.getKey().equals("resultsNumber")) {
                this.setAndUpdateCurrentCount(ev.id, Integer.parseInt(resultEvent.getValue()));
                received = true;
                continue;
            }
            this.emitEvent(ev.event);
        }
        if (received) {
            if (this.finalReceivedFromAll) {
                this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + this.currentResultCountSum));
                this.finalSent = true;
            } else {
                int val = Math.max(this.writerResultCount, this.currentResultCountSum);
                if (val != this.currentResultCountSum) {
                    if (this.currentResultCountSum != this.previousResultCountSum) {
                        this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumber", "" + val));
                    }
                } else if (this.writerResultCount - this.previousEmissionCheckpoint >= this.emissionStep) {
                    this.previousEmissionCheckpoint = this.writerResultCount;
                    this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumber", "" + val));
                }
            }
        } else if (this.writerResultCount > this.currentResultCountSum && this.writerResultCount - this.previousEmissionCheckpoint >= this.emissionStep) {
            this.previousEmissionCheckpoint = this.writerResultCount;
            this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumber", "" + this.writerResultCount));
        }
    }

    public void increaseProducedRecordCount() {
        ++this.writerResultCount;
    }

    public void sendPendingFinalEvents(int count) {
        if (!this.finalSent) {
            this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + count));
        }
    }
}

