/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.gmerge;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.gmerge.GradualMergeOp;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderHolder;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderInit;
import java.net.URI;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradualLocatorReader
extends Thread {
    private Logger log = LoggerFactory.getLogger((String)GradualLocatorReader.class.getName());
    private URI locator;
    private String uid = null;
    ForwardReader<GenericRecord> reader = null;
    Vector<ReaderHolder> readers;
    private Vector<ReaderInit> initT;
    private Boolean hasFinished = false;
    public static final int BufferCapacityDef = 100;
    private Object synchDispatcher = null;

    public GradualLocatorReader(URI locator, Vector<ReaderHolder> readers, Vector<ReaderInit> initT, String uid, Object synchDispatcher) throws GRS2ReaderException {
        this.uid = uid;
        this.locator = locator;
        this.readers = readers;
        this.initT = initT;
        this.reader = new ForwardReader(locator);
        this.synchDispatcher = synchDispatcher;
    }

    public synchronized boolean hasFinished() {
        return this.hasFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.locator == null || this.readers == null || this.initT == null || this.reader == null) {
            this.log.error("Not initialized");
            throw new NullPointerException("not initialized");
        }
        int cntLocators = 0;
        try {
            GradualLocatorReader rec;
            while (this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0)) {
                Object object;
                rec = (GenericRecord)this.reader.get(60L, TimeUnit.SECONDS);
                if (rec == null) {
                    if (this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0)) {
                        this.log.debug("No new resultset received after 60 secs");
                        continue;
                    }
                    this.log.info("Input Locator closed");
                    break;
                }
                String loc = ((StringField)rec.getField(0)).getPayload();
                this.log.info("Got (" + (cntLocators + 1) + ") locator: " + loc + " that will be added for merge");
                this.readers.add(new ReaderHolder());
                this.initT.add(new ReaderInit(this.readers, cntLocators, URI.create(loc), GradualMergeOp.OperationModeDef, 100, this.uid));
                this.initT.get(cntLocators).start();
                if (cntLocators == 0) {
                    object = this.initT;
                    synchronized (object) {
                        this.initT.notify();
                    }
                }
                ++cntLocators;
                object = this.synchDispatcher;
                synchronized (object) {
                    this.synchDispatcher.notify();
                }
            }
            rec = this;
            synchronized (rec) {
                this.hasFinished = true;
            }
            this.reader.close();
        }
        catch (Exception ex) {
            this.log.error("Caught unxepected exception", (Throwable)ex);
        }
    }
}

