/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.JDBCConnectorProfile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBridge {
    private static Logger logger = LoggerFactory.getLogger((String)QueryBridge.class.getName());
    private String driverName;
    private String connectionString;
    private Connection conn;
    private Statement stmt;
    private ResultSet rs;

    public QueryBridge(String driverName, String connectionString, int recordsPerPart) throws Exception {
        this.driverName = driverName;
        this.connectionString = connectionString;
        this.conn = null;
        this.stmt = null;
        this.rs = null;
        try {
            Class.forName(this.driverName).newInstance();
            this.conn = DriverManager.getConnection(this.connectionString);
            this.stmt = this.conn.createStatement(JDBCConnectorProfile.ResultSetType, JDBCConnectorProfile.ResultSetConcurreny, JDBCConnectorProfile.ResultSetHoldability);
            this.stmt.setFetchDirection(JDBCConnectorProfile.FetchDirection);
            this.stmt.setFetchSize(recordsPerPart);
            if (this.conn == null) {
                logger.error("QueryBridge constructor: The connection object is null. Throwing Exception");
                throw new Exception("QueryBridge constructor: The connection object is null");
            }
            if (this.stmt == null) {
                logger.error("QueryBridge constructor: The statement object is null. Throwing Exception");
                throw new Exception("QueryBridge constructor: The statement object is null");
            }
        }
        catch (SQLException e) {
            logger.error("SQLException thrown in QueryBridge constructor. Throwing Exception", (Throwable)e);
            throw new Exception("SQLException thrown in QueryBridge constructor");
        }
        catch (Exception e) {
            logger.error("Exception thrown in QueryBridge constructor. Throwing Exception", (Throwable)e);
            throw new Exception("Exception thrown in QueryBridge constructor");
        }
    }

    public ResultSet executeQuery(String query) throws Exception {
        try {
            boolean isSelect = this.stmt.execute(query);
            if (!isSelect) {
                return null;
            }
            this.rs = this.stmt.getResultSet();
            return this.rs;
        }
        catch (Exception e) {
            logger.error("Could not execute Query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute Query");
        }
    }

    public String[] getColumnNames() throws Exception {
        try {
            ResultSetMetaData rsm = this.rs.getMetaData();
            int columncnt = rsm.getColumnCount();
            String[] columnNames = new String[columncnt];
            for (int i = 0; i < columncnt; ++i) {
                columnNames[i] = rsm.getColumnName(i + 1);
            }
            return columnNames;
        }
        catch (Exception e) {
            logger.error("Could not get column names. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get column names");
        }
    }

    public void printResults() {
        if (this.rs == null) {
            System.err.println("The result set is null");
            return;
        }
    }
}

