/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.MergeWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.OperationMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderHolder;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderInit;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.gcube.search.datafusion.DataFusion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeOp {
    public static final OperationMode OperationModeDef = OperationMode.FIFO;
    public static final long TimeoutDef = 180L;
    public static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    public static final int BufferCapacityDef = 100;
    public static final String RankFieldNameDef = "rank";
    private Logger logger = LoggerFactory.getLogger((String)MergeOp.class.getName());
    private URI[] locators = null;
    private String uid = UUID.randomUUID().toString();
    private StatsContainer stats = null;
    private long timeout = 180L;
    private TimeUnit timeUnit = TimeUnitDef;
    private String rankFieldName = "rank";
    private String query = null;
    private int bufferCapacity = 100;
    private RecordDefinition[] recordDefinitions;
    private int[] recordDefinitionOffsets = null;
    private OperationMode operationMode = OperationModeDef;

    public MergeOp(URI[] locators, StatsContainer stats) {
        this.locators = locators;
        this.stats = stats;
    }

    public MergeOp(URI[] locators, OperationMode operationMode, StatsContainer stats) {
        this.locators = locators;
        this.stats = stats;
        this.operationMode = operationMode;
    }

    public MergeOp(URI[] locators, OperationMode operationMode, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this(locators, operationMode, stats);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public MergeOp(URI[] locators, OperationMode operationMode, long timeout, TimeUnit timeUnit, int bufferCapacity, StatsContainer stats) {
        this(locators, operationMode, stats);
        this.bufferCapacity = bufferCapacity;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public void setRankFieldName(String rankFieldName) {
        this.rankFieldName = rankFieldName;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private void getDefinitions(Vector<ReaderHolder> readers) throws GRS2ReaderException {
        this.recordDefinitionOffsets = new int[readers.size()];
        ArrayList<RecordDefinition[]> definitionsList = new ArrayList<RecordDefinition[]>();
        ArrayList<RecordDefinition> definitions = new ArrayList<RecordDefinition>();
        this.recordDefinitionOffsets[0] = 0;
        for (int i = 0; i < readers.size(); ++i) {
            if (readers.get(i).getReader() == null) continue;
            this.logger.trace(this.uid + ": Reading record definitions from reader #" + i);
            RecordDefinition[] defs = readers.get(i).getReader().getRecordDefinitions();
            definitions.addAll(Arrays.asList(defs));
            definitionsList.add(defs);
            if (i == 0) continue;
            this.recordDefinitionOffsets[i] = this.recordDefinitionOffsets[i - 1] + ((RecordDefinition[])definitionsList.get(i - 1)).length;
        }
        this.recordDefinitions = definitions.toArray(new RecordDefinition[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI compute() throws Exception {
        try {
            Object synchWorker;
            long mergestart = Calendar.getInstance().getTimeInMillis();
            this.logger.info("Operational mode set : " + (Object)((Object)this.operationMode));
            this.logger.info("Operational equal fusion ? " + this.operationMode.equals((Object)OperationMode.Fusion));
            this.logger.info((Object)((Object)this.operationMode) + " = " + this.operationMode.equals((Object)OperationMode.Fusion));
            if (this.operationMode.equals((Object)OperationMode.Fusion)) {
                this.logger.info("Executing data fusion!!!");
                DataFusion df = new DataFusion(this.locators, this.query);
                URI writerLocator = df.operate();
                long mergestop = Calendar.getInstance().getTimeInMillis();
                this.stats.timeToInitialize(mergestop - mergestart);
                this.logger.info("MERGE OPERATOR " + this.uid + " TOOK " + (mergestop - mergestart));
                this.logger.trace(this.uid + ": Returning " + writerLocator);
                return writerLocator;
            }
            this.logger.info("Executing merge!!!");
            Vector<ReaderHolder> readers = new Vector<ReaderHolder>();
            readers.setSize(this.locators.length);
            ReaderInit[] initT = new ReaderInit[this.locators.length];
            long initstart = Calendar.getInstance().getTimeInMillis();
            for (int i = 0; i < this.locators.length; ++i) {
                readers.set(i, new ReaderHolder());
                initT[i] = new ReaderInit(readers, i, this.locators[i], this.operationMode, this.bufferCapacity, this.uid);
                initT[i].start();
            }
            long initstop = Calendar.getInstance().getTimeInMillis();
            MergeWorker worker = new MergeWorker(readers, this.stats, this.operationMode, this.timeout, this.timeUnit, this.uid);
            worker.start();
            for (int i = 0; i < readers.size(); ++i) {
                initT[i].join();
            }
            this.getDefinitions(readers);
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), this.recordDefinitions, this.bufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            worker.setWriter((RecordWriter<Record>)writer);
            worker.setRecordDefinitionOffsets(this.recordDefinitionOffsets);
            Object object = synchWorker = worker.getWriterInitSyncObject();
            synchronized (object) {
                synchWorker.notify();
            }
            long mergestop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToInitialize(initstop - initstart);
            this.logger.info("MERGE OPERATOR " + this.uid + " INIT TOOK " + (initstop - initstart));
            this.logger.info("MERGE OPERATOR " + this.uid + " TOOK " + (mergestop - mergestart));
            this.logger.trace(this.uid + ": Returning " + writer.getLocator());
            return writer.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not start background process of merging for operator " + this.uid + ". Throwing Exception", (Throwable)e);
            throw new Exception("Could not start background process of merging");
        }
    }
}

