/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform.TransformWorker;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformOp {
    private Logger logger = LoggerFactory.getLogger((String)TransformOp.class.getName());
    private static final long TimeoutDef = 60L;
    private static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;
    private URI inLocator = null;
    private String payloadFieldName = null;
    private StatsContainer stats = null;

    public TransformOp(URI locator, String payloadFieldName, StatsContainer stats) {
        this.inLocator = locator;
        this.payloadFieldName = payloadFieldName;
        this.stats = stats;
    }

    public TransformOp(URI inLocator, String payloadFieldName, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this.inLocator = inLocator;
        this.payloadFieldName = payloadFieldName;
        this.stats = stats;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public URI compute(String xslt) throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            ForwardReader reader = new ForwardReader(this.inLocator);
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), (IRecordReader)reader);
            TransformWorker worker = new TransformWorker(reader, (IRecordWriter<Record>)writer, this.payloadFieldName, xslt, this.stats, this.timeout, this.timeUnit);
            worker.start();
            long readerstop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToInitialize(readerstop - start);
            return writer.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not initialize transform operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize transform operation");
        }
    }
}

