/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.randomgenerator;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.http.HTTPWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.generators.FloatGenerator;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.generators.Generator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomGeneratorWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)RandomGeneratorWorker.class.getName());
    private RecordWriter<Record> writer = null;
    private URI outLocator = null;
    private int count = 0;
    private boolean RS = false;
    private boolean singleField = false;
    private boolean onlyFinalEvent = false;
    private int id;
    private long timeout;
    private TimeUnit timeUnit;
    private Float threshold;
    private Generator<? extends Object>[] fieldGenerators;
    private String[] fieldNames = null;
    private File outFile = null;
    private Object synchWriter = null;

    public RandomGeneratorWorker(int count, boolean RS, IProxy.ProxyType proxyType, String[] fieldNames, Generator<? extends Object>[] fieldGenerators, boolean singleField, boolean onlyFinalEvent, int id, long timeout, TimeUnit timeUnit, Float threshold, int bufferCapacity, File outFile, Object synchWriter) throws Exception {
        RecordWriter baseWriter;
        this.count = count;
        this.RS = RS;
        this.fieldNames = fieldNames;
        this.fieldGenerators = fieldGenerators;
        this.singleField = singleField;
        this.onlyFinalEvent = onlyFinalEvent;
        this.id = id;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.threshold = Float.valueOf(threshold != null ? threshold.floatValue() : RecordWriter.DefaultThreshold);
        this.outFile = outFile;
        if (this.threshold.floatValue() < 0.0f || this.threshold.floatValue() > 1.0f) {
            throw new Exception("Invalid threshold value");
        }
        LocalWriterProxy producerProxy = null;
        switch (proxyType) {
            case Local: {
                producerProxy = new LocalWriterProxy();
                break;
            }
            case TCP: {
                producerProxy = new TCPWriterProxy();
                break;
            }
            case HTTP: {
                producerProxy = new HTTPWriterProxy();
            }
        }
        RecordDefinition[] defs = null;
        if (!singleField) {
            StringFieldDefinition[] fieldDefs = new StringFieldDefinition[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                fieldDefs[i] = new StringFieldDefinition(fieldNames[i]);
            }
            defs = new RecordDefinition[]{new GenericRecordDefinition((FieldDefinition[])fieldDefs)};
        } else {
            defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition()})};
        }
        this.writer = threshold == null ? (baseWriter = new RecordWriter((IWriterProxy)producerProxy, defs, bufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor)) : (baseWriter = new RecordWriter((IWriterProxy)producerProxy, defs, bufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor));
        this.outLocator = producerProxy.getLocator();
        this.synchWriter = synchWriter;
    }

    public URI getLocator() {
        return this.outLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long productionTime = -1L;
        float productionRate = -1.0f;
        this.setName("RandomGeneratorWorker #" + this.id);
        FloatGenerator fg = new FloatGenerator(null);
        int rc = 0;
        int eventsEmitted = 0;
        long start = Calendar.getInstance().getTimeInMillis();
        boolean finalEmitted = false;
        BufferedWriter out = null;
        if (this.outFile != null) {
            try {
                out = new BufferedWriter(new FileWriter(this.outFile));
            }
            catch (IOException e) {
                logger.warn("Could not open output file", (Throwable)e);
            }
        }
        Object e = this.synchWriter;
        synchronized (e) {
            this.synchWriter.notify();
        }
        try {
            if (this.fieldGenerators.length != this.fieldNames.length) {
                logger.error("Field name/type length mismatch");
                this.writer.close();
                return;
            }
            while (rc < this.count) {
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Random generator #" + this.id + " stopping prematurely");
                    System.out.println("Consumer side stopped consumption. Random generator #" + this.id + " stopping prematurely");
                    break;
                }
                if (rc == 1) {
                    System.out.println("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - start));
                }
                StringBuilder record = new StringBuilder();
                Hashtable<String, String> attrs = new Hashtable<String, String>();
                attrs.put("DocID", Integer.valueOf(this.id).toString() + ":" + Integer.valueOf(rc).toString());
                attrs.put("CollID", "TestCol");
                attrs.put("RankID", fg.next().toString());
                if (this.RS) {
                    record.append("<RSRecord ");
                    record.append("DocID=\"" + (String)attrs.get("DocID") + "\" ");
                    record.append("CollID=\"" + (String)attrs.get("CollID") + "\" ");
                    record.append("RankID=\"" + (String)attrs.get("RankID") + "\" ");
                    record.append("TestAttr=\"foo\"");
                    record.append(">");
                } else {
                    record.append("<record>");
                }
                Field[] fields = null;
                if (!this.singleField) {
                    fields = new Field[this.fieldGenerators.length];
                }
                for (int f = 0; f < this.fieldNames.length; ++f) {
                    record.append("<" + this.fieldNames[f] + ">");
                    String payload = this.fieldGenerators[f].next().toString();
                    record.append(payload);
                    record.append("</" + this.fieldNames[f] + ">");
                    if (this.singleField) continue;
                    fields[f] = new StringField(payload);
                }
                if (this.RS) {
                    record.append("</RSRecord>");
                } else {
                    record.append("</record>");
                }
                GenericRecord outRec = null;
                if (!this.singleField) {
                    outRec = new GenericRecord();
                    outRec.setFields(fields);
                } else {
                    outRec = new GenericRecord();
                    outRec.setFields(new Field[]{new StringField(record.toString())});
                }
                try {
                    if (!this.onlyFinalEvent || eventsEmitted < 10) {
                        if (rc % 100 == 0 && rc > 0) {
                            this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumber", "" + rc));
                            ++eventsEmitted;
                        }
                    } else if (!finalEmitted) {
                        this.writer.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + this.count));
                        finalEmitted = true;
                    }
                    if (!this.writer.put((Record)outRec, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() == IBuffer.Status.Open) {
                            logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords());
                            ++rc;
                            continue;
                        }
                        System.out.println("Consumer side stopped consumption. Random generator #" + this.id + " stopping prematurely");
                        break;
                    }
                    ++rc;
                }
                catch (GRS2WriterException e2) {
                    logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords(), (Throwable)e2);
                    System.out.println("Could not write record " + rc + ". Skipping. Available Record = " + this.writer.availableRecords());
                    continue;
                }
                catch (Exception e3) {
                    logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords(), (Throwable)e3);
                    System.out.println("Could not write record " + rc + ". Skipping. Available Record = " + this.writer.availableRecords());
                    continue;
                }
                if (out != null && !this.singleField) {
                    try {
                        for (int f = 0; f < this.fieldNames.length; ++f) {
                            out.write(((StringField)outRec.getField(f)).getPayload() + " ");
                        }
                        out.newLine();
                    }
                    catch (Exception e4) {
                        logger.warn("Could not persist record to output file", (Throwable)e4);
                    }
                }
                if (rc != this.count) continue;
                break;
            }
        }
        catch (Exception e2) {
            logger.warn("Error while generating random records", (Throwable)e2);
        }
        finally {
            try {
                long closestop = Calendar.getInstance().getTimeInMillis();
                productionTime = closestop - start;
                productionRate = (float)rc / (float)(closestop - start) * 1000.0f;
                KeyValueEvent productionTimeEvent = new KeyValueEvent("productionTime", Long.toString(productionTime));
                KeyValueEvent productionRateEvent = new KeyValueEvent("productionRate", Float.toString(productionRate));
                this.writer.emit((BufferEvent)productionTimeEvent);
                this.writer.emit((BufferEvent)productionRateEvent);
                this.writer.close();
            }
            catch (Exception e5) {}
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e6) {
                    logger.warn("Could not close output file", (Throwable)e6);
                }
            }
        }
        logger.info("Data generation took " + productionTime);
        logger.info("Produced " + rc + " records");
        logger.info("Production rate was " + productionRate);
    }
}

