/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.duplicategenerator;

import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.http.HTTPWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.duplicategenerator.DuplicateGeneratorWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.generators.Generator;
import java.io.File;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateGeneratorOp {
    private Logger logger = LoggerFactory.getLogger((String)DuplicateGeneratorOp.class.getName());

    public URI compute(int count, String[] fieldNames, String objIdFieldName, String objRankFieldName, Generator<? extends Object>[] fieldGenerators, boolean singleField, boolean onlyFinalEvent, double duplicateProbability, Integer seed, IProxy.ProxyType proxyType, File outFile) throws Exception {
        try {
            RecordDefinition[] defs = null;
            if (!singleField) {
                StringFieldDefinition[] fieldDefs = new StringFieldDefinition[fieldNames.length];
                for (int i = 0; i < fieldNames.length; ++i) {
                    fieldDefs[i] = new StringFieldDefinition(fieldNames[i]);
                }
                defs = new RecordDefinition[]{new GenericRecordDefinition((FieldDefinition[])fieldDefs)};
            } else {
                defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition()})};
            }
            LocalWriterProxy producerProxy = null;
            switch (proxyType) {
                case Local: {
                    producerProxy = new LocalWriterProxy();
                    break;
                }
                case TCP: {
                    producerProxy = new TCPWriterProxy();
                    break;
                }
                case HTTP: {
                    producerProxy = new HTTPWriterProxy();
                }
            }
            RecordWriter writer = new RecordWriter((IWriterProxy)producerProxy, defs, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            DuplicateGeneratorWorker worker = new DuplicateGeneratorWorker((IRecordWriter<Record>)writer, count, fieldNames, objIdFieldName, objRankFieldName, fieldGenerators, singleField, onlyFinalEvent, duplicateProbability, seed, outFile);
            worker.start();
            return writer.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not start background process of keep top operator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not start background process of keep top operator");
        }
    }
}

