package org.gcube.opensearch.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.builders.StatefulBuilder;
import org.gcube.common.clients.fw.builders.StatefulBuilderImpl;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.opensearch.client.library.plugins.OpenSearchDataSourceCLPlugin;
import org.gcube.opensearch.client.library.stubs.OpenSearchDataSourceStub;
import org.gcube.opensearch.client.library.util.OpenSearchDataSourceCLConstants;

public class OpenSearchDataSourceDSL {
	
	public static final OpenSearchDataSourceCLPlugin osds_plugin = new OpenSearchDataSourceCLPlugin();
	
	
	public static StatefulQuery plugin(final String adaptorID) {
		
		StatefulQuery query = new StatefulQuery(osds_plugin);
		query.addNamespace("ns1",URI.create(OpenSearchDataSourceCLConstants.NAMESPACE))
		.addCondition("$resource/Data/ns1:AdaptorID/text() eq '"+adaptorID+"'");
		return query;
	}
	
	public static SourceQueryBuilder getSource() {

		StatefulQuery query = new StatefulQuery(osds_plugin);
		return new SourceQueryBuilder(query);
		
	}
	
	public static StatefulBuilder<OpenSearchDataSourceCLProxyI> getOpenSearchDataSourceProxyBuilder() {
		return new StatefulBuilderImpl<OpenSearchDataSourceStub,OpenSearchDataSourceCLProxyI>(osds_plugin);
	}
	
}
