package org.gcube.opensearch.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.opensearch.client.library.beans.Types.AddProvidersParams;
import org.gcube.opensearch.client.library.beans.Types.AddProvidersResponse;
import org.gcube.opensearch.client.library.beans.Types.Destroy;
import org.gcube.opensearch.client.library.beans.Types.RefreshCache;
import org.gcube.opensearch.client.library.beans.Types.RefreshCacheResponse;
import org.gcube.opensearch.client.library.exceptions.OpenSearchDataSourceException;
import org.gcube.opensearch.client.library.stubs.OpenSearchDataSourceStub;

public class OpenSearchDataSourceCLDefaultProxy implements OpenSearchDataSourceCLProxyI {

	private final ProxyDelegate<OpenSearchDataSourceStub> delegate;

	public OpenSearchDataSourceCLDefaultProxy(ProxyDelegate<OpenSearchDataSourceStub> config) {
		this.delegate = config;
	}


	@Override
	public String query(final String query) throws OpenSearchDataSourceException {
		Call<OpenSearchDataSourceStub, String> call = new Call<OpenSearchDataSourceStub, String>() {
			@Override
			public String call(OpenSearchDataSourceStub endpoint) throws Exception {
				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new OpenSearchDataSourceException(e);
		}
	}
	
	@Override
	public void refreshCache() throws OpenSearchDataSourceException {
		Call<OpenSearchDataSourceStub, RefreshCacheResponse> call = new Call<OpenSearchDataSourceStub, RefreshCacheResponse>() {
			@Override
			public RefreshCacheResponse call(OpenSearchDataSourceStub endpoint) throws Exception {
				return endpoint.refreshCache(new RefreshCache());
			}
		};
		try {
			RefreshCacheResponse response = delegate.make(call);

			return;
		} catch (Exception e) {
			throw new OpenSearchDataSourceException(e);
		}
	}
	
	@Override
	public void addProviders(final AddProvidersParams req) throws OpenSearchDataSourceException {
		Call<OpenSearchDataSourceStub, AddProvidersResponse> call = new Call<OpenSearchDataSourceStub, AddProvidersResponse>() {
			@Override
			public AddProvidersResponse call(OpenSearchDataSourceStub endpoint) throws Exception {
				return endpoint.addProviders(req);
			}
		};
		try {
			AddProvidersResponse response = delegate.make(call);

			return;
		} catch (Exception e) {
			throw new OpenSearchDataSourceException(e);
		}
	}

	@Override
	public void destroy() throws OpenSearchDataSourceException {
		Call<OpenSearchDataSourceStub, Empty> call = new Call<OpenSearchDataSourceStub, Empty>() {
			@Override
			public Empty call(OpenSearchDataSourceStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new OpenSearchDataSourceException(e);
		}
	}


}
