package org.gcube.opensearch.client.library.beans;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class Types {
	// REQUEST AND RESPONSE ELEMENTS

	public static class StringArray
	{
		@XmlElement(name = "array")
		public List<String> array;
	}
	
	public static class Provider
	{
		@XmlElement(name = "collectionID", required = true)
		public String collectionID;
		
		@XmlElement(name = "OpenSearchResourceID", required = true)
		public String OpenSearchResourceID;
		
		@XmlElement(name = "fixedParameters", required = true)
		public StringArray fixedParameters;
		
	}
	public static class CreateResourceParams
	{
		@XmlElement(name = "Fields")
		public StringArray Fields;
		
		@XmlElement(name = "Providers")
		public List<Provider> Providers;
		
		@XmlElement(name = "resourceKey")
		public String resourceKey;
		
	}

	public static class CreateResourceResponse
	{
		@XmlElement(name = "EndpointReference", namespace="http://schemas.xmlsoap.org/ws/2004/03/addressing")
		public W3CEndpointReference EndpointReference;
	}
	
	public static class AddProvidersParams
	{
		@XmlElement(name = "Fields")
		public StringArray Fields;
		
		@XmlElement(name = "OpenSearchResourceID")
		public List<Provider> Providers;
	}
	
	public static class AddProvidersResponse
	{
	}
	
	
	
	public static class RefreshCacheResponse
	{
	}
	
	public static class RefreshCache
	{
	}
	
	
	
	
	
	public static class Destroy{}
	
}
