package org.gcube.opensearch.client.library.plugins;

import static org.gcube.common.clients.stubs.jaxws.StubFactory.stubFor;

import javax.xml.ws.EndpointReference;


import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;

import org.gcube.opensearch.client.library.proxies.OpenSearchDataSourceCLDefaultProxy;

import org.gcube.opensearch.client.library.proxies.OpenSearchDataSourceCLProxyI;
import org.gcube.opensearch.client.library.stubs.OpenSearchDataSourceStub;
import org.gcube.opensearch.client.library.util.OpenSearchDataSourceCLConstants;

/**
 * FullTextIndexNode Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of FullTextIndexNode CL. 
 * 
 * @author p.liakos - DI NKUA
 * 
 */
public class OpenSearchDataSourceCLPlugin implements Plugin<OpenSearchDataSourceStub, OpenSearchDataSourceCLProxyI> {

	@Override
	public String name() {
		return OpenSearchDataSourceCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return OpenSearchDataSourceCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return OpenSearchDataSourceCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return OpenSearchDataSourceCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public OpenSearchDataSourceStub resolve(EndpointReference reference,ProxyConfig<?, ?> proxyConfig) throws Exception {
		return stubFor(OpenSearchDataSourceCLConstants.osds).at(reference);
		
	}
	
	@Override
	public OpenSearchDataSourceCLProxyI newProxy(ProxyDelegate<OpenSearchDataSourceStub> delegate) {
		return new OpenSearchDataSourceCLDefaultProxy(delegate);
	}

}
