/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.hive;

import gr.uoa.di.madgik.hive.HiveQLPlanner;
import gr.uoa.di.madgik.hive.analyzer.OperatorAnalyzer;
import gr.uoa.di.madgik.hive.plan.PlanNode;
import gr.uoa.di.madgik.hive.query.QueryType;
import gr.uoa.di.madgik.hive.utils.MaskString;
import org.antlr.runtime.tree.CommonTree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveQLParser {
    private Logger log = LoggerFactory.getLogger((String)HiveQLParser.class.getName());
    private Driver driver;
    private HiveConf conf;
    private String command;
    private ASTNode tree;

    public HiveQLParser() {
        CliSessionState ss = new CliSessionState(new HiveConf(SessionState.class));
        this.conf = ss.getConf();
        this.conf.set("javax.jdo.option.ConnectionURL", "jdbc:derby:memory:metastore_db;create=true");
        this.conf.set("hive.metastore.warehouse.dir", "/tmp/hive/warehouse");
        SessionState.start((SessionState)ss);
        this.driver = new Driver(this.conf);
    }

    public void parse(String command) throws Exception {
        this.command = command;
        if (!command.trim().toLowerCase().startsWith("add")) {
            this.tree = this.parseAST(command);
        }
    }

    public QueryType getQueryType() {
        QueryType queryType = null;
        if (this.command.trim().toLowerCase().startsWith("add")) {
            queryType = QueryType.ADD;
        } else {
            String tok = this.tree.getText();
            if (tok.equals("TOK_CREATETABLE")) {
                queryType = QueryType.CREATE;
            } else if (tok.equals("TOK_LOAD")) {
                queryType = QueryType.LOAD;
            } else if (tok.equals("TOK_QUERY")) {
                queryType = QueryType.QUERY;
            } else if (tok.equals("TOK_DROPTABLE")) {
                queryType = QueryType.DROP;
            } else {
                this.log.warn("unkown query type");
            }
        }
        return queryType;
    }

    private ASTNode parseAST(String command) throws Exception {
        command = new VariableSubstitution().substitute(this.conf, command);
        this.tree = null;
        try {
            Context ctx = new Context((Configuration)this.conf);
            ctx.setTryCount(Integer.MAX_VALUE);
            ctx.setCmd(command);
            ctx.setHDFSCleanup(true);
            ParseDriver pd = new ParseDriver();
            this.tree = pd.parse(command, ctx);
            this.tree = ParseUtils.findRootNonNullToken((ASTNode)this.tree);
        }
        catch (Exception e) {
            this.log.error("parse error: ", (Throwable)e);
            throw e;
        }
        return this.tree;
    }

    public int compile() {
        if (this.command.trim().toLowerCase().startsWith("add")) {
            if (this.command.trim().matches("add\\s*FILE\\s*\\S*")) {
                return 0;
            }
            return 1;
        }
        if (this.command.trim().toLowerCase().startsWith("load")) {
            MaskString mask = new MaskString(this.command, HiveQLPlanner.removeQuotes(this.tree.getChild(0).getText()));
            return this.driver.compile(mask.hide());
        }
        return this.driver.compile(this.command);
    }

    public int execute() {
        int ret = 0;
        try {
            ret = this.driver.execute();
        }
        catch (CommandNeedRetryException e) {
            this.log.warn("Query execution failed: " + this.command, (Throwable)e);
        }
        return ret;
    }

    public PlanNode constructPlan() throws Exception {
        PlanNode plan = null;
        MapRedTask task = (MapRedTask)this.driver.getPlan().getRootTasks().get(0);
        MapredWork work = (MapredWork)task.getWork();
        for (Operator entry : work.getMapWork().getWorks()) {
            OperatorAnalyzer.analyzeOperator((Operator<? extends OperatorDesc>)entry);
        }
        if (work.getReduceWork() != null) {
            OperatorAnalyzer.analyzeOperator((Operator<? extends OperatorDesc>)work.getReduceWork().getReducer());
        }
        plan = OperatorAnalyzer.getPlan();
        return plan;
    }

    public CommonTree getASTree() {
        return this.tree;
    }
}

