/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.hive.test;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import gr.uoa.di.madgik.hive.HiveQLPlanner;
import gr.uoa.di.madgik.hive.analyzer.OperatorAnalyzer;
import gr.uoa.di.madgik.hive.plan.DataSourceNode;
import gr.uoa.di.madgik.hive.plan.Functionality;
import gr.uoa.di.madgik.hive.plan.OperatorNode;
import gr.uoa.di.madgik.hive.plan.PlanNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserTest {
    private static Logger log = LoggerFactory.getLogger((String)HiveParserTest.class.getName());

    public static String getSimpleLine() {
        String line = "";
        line = line + "CREATE TABLE u_data (\n\t\tuserid STRING,\n\t\tmovieid STRING,\n\t\trating STRING,\n\t\tunixtime STRING)\nROW FORMAT DELIMITED\nFIELDS TERMINATED BY '\\t'\nSTORED AS TEXTFILE;\n\n";
        line = line + "LOAD DATA LOCAL INPATH '/home/jgerbe/Desktop/u.data.10'\nOVERWRITE INTO TABLE u_data;\n\n";
        line = line + "add FILE /home/jgerbe/Desktop/test.jar;\n\n";
        line = line + "add FILE /home/jgerbe/Desktop/weekday_mapper.py;\n\n";
        line = line + "CREATE TABLE u_data_new (\n\t\tuserid2 INT,\n\t\tmovieid2 INT,\n\t\trating2 INT,\n\t\tweekday2 INT)\nROW FORMAT DELIMITED\nFIELDS TERMINATED BY '\\t';\n\n";
        line = line + "FROM u_data\nINSERT OVERWRITE TABLE u_data_new\nSELECT\n\t\tTRANSFORM(userid, movieid, rating, unixtime)\n\t\tUSING 'cat'\n\t\tAS uid, mid, rat, wd\nDISTRIBUTE BY 3;\n\n";
        line = line + "INSERT OVERWRITE LOCAL DIRECTORY '/home/jgerbe/Desktop/tmp/'\nSELECT *\nFROM u_data_new;\n\n";
        line = line + "DROP TABLE u_data;\n\n";
        line = line + "DROP TABLE u_data_new;\n\n";
        return line;
    }

    public static String getLine(int dist, String file) {
        String line = "";
        line = line + "CREATE TABLE wiki (\n\t\tproperty STRING,\n\t\ttype STRING,\n\t\tvalue STRING)\nROW FORMAT DELIMITED\nFIELDS TERMINATED BY '\\t'\nSTORED AS TEXTFILE;\n\n";
        line = line + "LOAD DATA LOCAL INPATH '" + file + "'\n" + "OVERWRITE INTO TABLE wiki;\n\n";
        line = line + "add FILE /home/jgerbe/Desktop/counter.py;\n\n";
        line = line + "CREATE TABLE wiki_new (\n\t\tproperty STRING,\n\t\tfreq STRING)\nROW FORMAT DELIMITED\nFIELDS TERMINATED BY '\\t';\n\n";
        line = line + "FROM wiki\nINSERT OVERWRITE TABLE wiki_new\nSELECT\n\t\tTRANSFORM(property, value)\n\t\tUSING 'python counter.py'\n\t\tAS prop, val";
        line = dist > 1 ? line + "\nDISTRIBUTE BY " + dist + ";\n\n" : line + ";\n\n";
        line = line + "INSERT OVERWRITE LOCAL DIRECTORY '/home/jgerbe/Desktop/tmp/'\nSELECT *\nFROM wiki_new;\n\n";
        line = line + "DROP TABLE wiki;\n\n";
        line = line + "DROP TABLE wiki_new;\n\n";
        return line;
    }

    public static void run(String[] args) throws Exception {
        HiveQLPlanner planner = new HiveQLPlanner();
        planner.processLine(args[0]);
        System.out.println(OperatorAnalyzer.optimizePlan(planner.getCreatedPlan()));
    }

    public static PlanNode createPlan() throws UnsupportedEncodingException {
        String queryString = new String("jdbc:postgresql://meteora.di.uoa.gr:5432/dellstore2?user=postgres&password=aplagiadb/SELECT+*+FROM+spdtrees");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("schema", "[id, sourceid, uri, payload]");
        args.put("delimiter", ",");
        args.put("filterMask", "[0, 1, 2, 3]");
        args.put("source", queryString);
        PlanNode node = new DataSourceNode("u_data", args);
        args = new HashMap();
        args.put("schema", "[id, sourceid, uri, payload]");
        args.put("scriptCmd", "java -jar script.py");
        args.put("CDATA:script.py", Base64.encode(new HiveQLPlanner().comressedContentOfFile(new File("/home/jgerbe/Desktop/script.py"))));
        ArrayList<PlanNode> children = new ArrayList<PlanNode>();
        children.add(node);
        node = new OperatorNode(Functionality.SCRIPT, args, children);
        children = new ArrayList();
        return node;
    }
}

