/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.predefined;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.DataSource;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.QueryBridge;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.QueryParser;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.utils.FileUtils;
import java.io.File;
import java.net.URI;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCDataSource
extends DataSource {
    private static Logger log = LoggerFactory.getLogger((String)JDBCDataSource.class.getName());
    private String query;
    private String[] columnNames;
    private ResultSet rs;

    public JDBCDataSource(String input, Map<String, String> inputParameters) throws Exception {
        super(input, inputParameters);
        this.query = this.input;
        QueryParser parser = new QueryParser(new URI(this.query));
        QueryBridge qb = new QueryBridge(parser.getDriverName(), parser.getConnectionString(), 20);
        this.rs = qb.executeQuery(parser.getQuery());
        this.columnNames = qb.getColumnNames();
        if (inputParameters != null) {
            this.filterMask = inputParameters.get("filterMask");
        }
        this.fieldDefs = JDBCDataSource.initializeSchema(this.columnNames, this.filterMask);
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(this.fieldDefs)}, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        log.info("Ininializing JDBC data source at: " + parser.getConnectionString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start;
        Thread.currentThread().setName(JDBCDataSource.class.getName());
        long firstInputStop = start = Calendar.getInstance().getTimeInMillis();
        long firstOutputStop = start;
        int rc = 0;
        try {
            while (this.rs.next()) {
                if (rc == 0) {
                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                }
                ArrayList<Object> fieldList = new ArrayList<Object>();
                for (FieldDefinition field : this.fieldDefs) {
                    if (field.getName().equals(FieldNaming.LocalFieldName.bytestream.name())) {
                        File localFile = null;
                        localFile = File.createTempFile("jdbcDataSource", ".tmp");
                        localFile.deleteOnExit();
                        FileUtils.fileFromInputStream(this.rs.getBinaryStream(field.getName()), localFile);
                        fieldList.add(new FileField(localFile));
                        continue;
                    }
                    fieldList.add(new StringField(this.rs.getString(field.getName())));
                }
                GenericRecord rec = new GenericRecord();
                rec.setFields(fieldList.toArray(new Field[fieldList.size()]));
                if (!this.writer.importRecord((Record)rec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        log.warn("Consumer has timed out");
                    }
                    break;
                }
                if (++rc % 10000 == 0) {
                    log.debug("Got " + rc + " records from source");
                }
                if (rc != 1) continue;
                firstOutputStop = Calendar.getInstance().getTimeInMillis();
            }
        }
        catch (Exception e) {
            log.error("Error during datasource retrieval. Closing", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception ee) {}
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        log.info("DATASOURCE OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    @Override
    public URI getLocator() {
        if (this.writer != null) {
            try {
                return this.writer.getLocator();
            }
            catch (GRS2WriterException e) {
                log.error("Could not retrieve locator", (Throwable)e);
            }
        }
        return null;
    }

    private static FieldDefinition[] initializeSchema(String[] columnNames, String filterMask) {
        ArrayList<Object> fieldDefsList = new ArrayList<Object>();
        if (filterMask == null) {
            filterMask = "[";
            for (String value : columnNames) {
                filterMask = filterMask + value + ", ";
            }
            filterMask = filterMask.substring(0, filterMask.length() - 2);
            filterMask = filterMask + "]";
        }
        if (filterMask.replaceAll("[\\[\\],\\s]", "").matches("\\d*")) {
            for (String ref : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                int index = Integer.parseInt(ref);
                if (index >= columnNames.length) {
                    log.warn("Filter mask out of range");
                    continue;
                }
                if (columnNames[index].equals((Object)FieldNaming.LocalFieldName.bytestream)) {
                    fieldDefsList.add(new FileFieldDefinition(columnNames[index]));
                    continue;
                }
                fieldDefsList.add(new StringFieldDefinition(columnNames[index]));
            }
        } else {
            for (String ref : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                if (ref.equals(FieldNaming.LocalFieldName.bytestream.name())) {
                    FileFieldDefinition fd = new FileFieldDefinition(ref);
                    fd.setDeleteOnDispose(true);
                    fieldDefsList.add(fd);
                    continue;
                }
                fieldDefsList.add(new StringFieldDefinition(ref));
            }
        }
        log.info("ResultSet schema that will be used: " + fieldDefsList);
        return fieldDefsList.toArray(new FieldDefinition[fieldDefsList.size()]);
    }
}

