/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.datafusion;

import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.gcube.search.datafusion.RRadaptor;
import org.gcube.search.datafusion.datatypes.Pair;
import org.gcube.search.datafusion.datatypes.PositionalRecordWrapper;
import org.gcube.search.datafusion.datatypes.RSFusedIterator;
import org.gcube.search.datafusion.datatypes.RankedRecord;
import org.gcube.search.datafusion.helpers.IndexHelper;
import org.gcube.search.datafusion.helpers.ResultSetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFusion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String query;
    private int count = -1;
    private Iterator<PositionalRecordWrapper> iter = null;
    private static transient RRadaptor rradaptor;
    private static List<String> snippetFields;
    private static String[] propertyFileSnippetFields;
    private static Boolean propertyFileInludePosition;
    private static final String SNIPPET_FIELDS_PROP = "snippet-fields";
    private static final String INCLUDE_POSITION_PROP = "include-position";
    private static final Logger LOGGER;

    public DataFusion(URI[] locators, String query) throws GRS2ReaderException {
        LOGGER.info("Initializing datafusion");
        this.iter = new RSFusedIterator(locators);
        this.query = query;
    }

    public DataFusion(URI[] locators, String query, Integer count) throws GRS2ReaderException {
        LOGGER.info("Initializing datafusion");
        this.iter = new RSFusedIterator(locators, locators.length * count);
        this.query = query;
        this.count = count;
    }

    public URI operate() throws Exception {
        while (!ResourceRegistry.isInitialBridgingComplete()) {
            LOGGER.info("registry not ready...sleeping");
            TimeUnit.SECONDS.sleep(10L);
        }
        LOGGER.info("in operate");
        return this.rerank();
    }

    public URI rerank() throws Exception {
        return DataFusion.rerankRecords(this.iter, this.query, this.count, snippetFields, propertyFileInludePosition);
    }

    public static URI rerankRecords(Iterator<PositionalRecordWrapper> iter, String query, int count, List<String> snippetFields, Boolean includePosition) throws Exception {
        long starttime = 0L;
        long endtime = 0L;
        starttime = System.currentTimeMillis();
        Directory index = IndexHelper.initializeIndex();
        endtime = System.currentTimeMillis();
        LOGGER.info(" ~> initializeIndex time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        HashSet<String> fields = new HashSet<String>();
        starttime = System.currentTimeMillis();
        Map<String, Long> recPositions = IndexHelper.feedLucene(index, iter, snippetFields, fields, count);
        endtime = System.currentTimeMillis();
        LOGGER.info(" ~> feedLucene time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        int cnt = count;
        if (cnt > recPositions.size() || cnt == -1) {
            cnt = recPositions.size();
        }
        LOGGER.info("number of records retrieved : " + recPositions.size() + " cnt : " + cnt);
        List<RankedRecord> rankedRecs = null;
        if (cnt == 0) {
            rankedRecs = new ArrayList<RankedRecord>();
        } else {
            starttime = System.currentTimeMillis();
            Map<String, Pair> recScores = IndexHelper.rankDocuments(index, query, cnt);
            endtime = System.currentTimeMillis();
            LOGGER.info(" ~> rankDocuments time : " + (double)(endtime - starttime) / 1000.0 + " secs");
            starttime = System.currentTimeMillis();
            rankedRecs = RankedRecord.recalculateScores(recPositions, recScores, includePosition);
            endtime = System.currentTimeMillis();
            LOGGER.info(" ~> recalculateScores time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        }
        starttime = System.currentTimeMillis();
        URI locator = ResultSetHelper.multiGetAndWrite(rankedRecs, index, fields);
        endtime = System.currentTimeMillis();
        LOGGER.info(" ~> writeRecords time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        LOGGER.info("gr2 locator : " + locator);
        return locator;
    }

    private static void initializeSnippetFields() {
        snippetFields = new ArrayList<String>();
        for (String field : propertyFileSnippetFields) {
            try {
                LOGGER.info("Getting fieldID for field " + field);
                String fieldID = rradaptor.getFieldIDFromName(field);
                LOGGER.info("fieldID : " + fieldID);
                snippetFields.add(fieldID);
            }
            catch (Exception e) {
                LOGGER.error("Error while getting " + field, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        snippetFields = null;
        propertyFileSnippetFields = null;
        propertyFileInludePosition = null;
        LOGGER = LoggerFactory.getLogger(DataFusion.class);
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = DataFusion.class.getResourceAsStream("/fusion.properties");
            prop.load(is);
            propertyFileSnippetFields = prop.getProperty(SNIPPET_FIELDS_PROP).split(",");
            if (prop.getProperty(INCLUDE_POSITION_PROP) != null) {
                propertyFileInludePosition = prop.getProperty(INCLUDE_POSITION_PROP).equalsIgnoreCase("true");
            }
            LOGGER.info("Fields read from property file : " + Arrays.asList(propertyFileSnippetFields));
            LOGGER.info("Include Position read from property file : " + Arrays.asList(propertyFileInludePosition));
        }
        catch (IOException ex) {
            LOGGER.error("Error reading the from propery file", (Throwable)ex);
        }
        catch (Exception e) {
            LOGGER.error("Error reading the from propery file", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error("error closing the property file stream", (Throwable)e);
                }
            }
        }
        LOGGER.info("Initializing gRS2");
        long starttime = System.currentTimeMillis();
        ResultSetHelper.initializeGRS2();
        long endtime = System.currentTimeMillis();
        LOGGER.info(" ~> initialize time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        LOGGER.info("Initializing ResourceRegistry");
        try {
            ResourceRegistry.startBridging();
            TimeUnit.SECONDS.sleep(1L);
            while (!ResourceRegistry.isInitialBridgingComplete()) {
                LOGGER.info("registry not ready...sleeping");
                TimeUnit.SECONDS.sleep(10L);
            }
            rradaptor = new RRadaptor();
        }
        catch (ResourceRegistryException e) {
            LOGGER.error("Resource Registry could not be initialized", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Resource Registry could not be initialized", (Throwable)e);
        }
        LOGGER.info("Initializing snippet Fields");
        DataFusion.initializeSnippetFields();
    }
}

