/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.datafusion.helpers;

import au.id.jericho.lib.html.Source;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.ObjectField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.URLField;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String objid = "ObjectID";
    public static final String QUERY_FIELD = "query_field";
    public static final String ID_FIELD = "ID_FIELD";
    public static final String SCORE_FIELD = "rank";
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordHelper.class);

    public static Float getRank(GenericRecord rec) {
        Float val = null;
        try {
            String payload = ((StringField)rec.getField(SCORE_FIELD)).getPayload().toString();
            val = Float.valueOf(Float.parseFloat(payload));
            LOGGER.info("payload : " + payload + " val : " + val);
        }
        catch (Exception e) {
            return null;
        }
        return val;
    }

    public static String getSnippetPayload(GenericRecord rec, String snippetField) throws GRS2RecordDefinitionException, GRS2BufferException {
        String payload = null;
        try {
            payload = ((StringField)rec.getField(snippetField)).getPayload();
        }
        catch (Exception e) {
            LOGGER.info("Could not get payload of field : " + snippetField);
        }
        return payload;
    }

    public static String getRecordContentFromObjID(GenericRecord rec) throws GRS2RecordDefinitionException, GRS2BufferException, MalformedURLException, IOException {
        String text = null;
        try {
            String payload = ((StringField)rec.getField(objid)).getPayload();
            LOGGER.info("Retrieving content from url : " + payload);
            Source source = new Source(new URL(payload));
            text = source.extractText();
        }
        catch (Exception e) {
            LOGGER.error("Record : " + rec.getID() + " does not have object id");
        }
        return text;
    }

    public static String getRecordID(GenericRecord rec) throws GRS2RecordDefinitionException, GRS2BufferException, MalformedURLException, IOException {
        String id = "0";
        try {
            id = ((StringField)rec.getField(objid)).getPayload();
        }
        catch (Exception e) {
            LOGGER.error("Record : " + rec.getID() + " does not have object id");
        }
        return id;
    }

    public static String getQuerySnippetFields(GenericRecord rec, List<String> snippetFields) throws GRS2RecordDefinitionException, GRS2BufferException, MalformedURLException, IOException {
        String payload = null;
        for (String field : snippetFields) {
            if (rec.getField(field) == null || (payload = RecordHelper.getQueryFieldContent(rec, field)) == null) continue;
            LOGGER.info("found snippet for field : " + field);
            break;
        }
        if (payload == null) {
            LOGGER.info("Snippet not found for record. trying to retrieve content");
            LOGGER.info("-------------------");
            LOGGER.info("tried the following snippet fields : " + snippetFields);
            LOGGER.info("fields in record : ");
            for (Field f : rec.getFields()) {
                LOGGER.info("\t" + f.getFieldDefinition().getName());
            }
            LOGGER.info("-------------------");
            payload = RecordHelper.getRecordContentFromObjID(rec);
        }
        return payload != null ? payload : "";
    }

    public static String getQueryFieldContent(GenericRecord rec, String snippetField) throws GRS2RecordDefinitionException, GRS2BufferException, MalformedURLException, IOException {
        String payload = RecordHelper.getSnippetPayload(rec, snippetField);
        return payload != null ? payload : null;
    }

    public static void rsRecToLucene(IndexWriter w, String id, GenericRecord rsRec, String queryField) throws Exception {
        Document doc = new Document();
        doc.add((IndexableField)new TextField(ID_FIELD, id, Field.Store.YES));
        doc.add((IndexableField)new TextField(QUERY_FIELD, queryField, Field.Store.YES));
        for (Field f : rsRec.getFields()) {
            String fieldName = f.getFieldDefinition().getName();
            String payload = RecordHelper.getFieldString(f);
            doc.add((IndexableField)new TextField(fieldName, payload, Field.Store.YES));
        }
        w.addDocument((Iterable)doc);
    }

    public static GenericRecord luceneToRSRecord(Document doc, Set<String> fieldsName, Float score) throws Exception {
        GenericRecord rec = new GenericRecord();
        ArrayList<StringField> fields = new ArrayList<StringField>();
        for (String fieldName : fieldsName) {
            String payload = null;
            payload = fieldName.equals(SCORE_FIELD) ? String.valueOf(score) : doc.get(fieldName);
            fields.add(new StringField(payload));
        }
        rec.setFields(fields.toArray(new Field[fields.size()]));
        return rec;
    }

    private static String getFieldString(Field f) throws Exception {
        String payload = null;
        if (f.getClass().equals(FileField.class)) {
            payload = ((FileField)f).getOriginalPayload().getName();
        } else if (f.getClass().equals(ObjectField.class)) {
            payload = ((ObjectField)f).getPayload().toString();
        } else if (f.getClass().equals(StringField.class)) {
            payload = ((StringField)f).getPayload().toString();
        } else if (f.getClass().equals(URLField.class)) {
            payload = ((URLField)f).getPayload().toString();
        } else {
            throw new Exception("Field : " + f.getClass() + " not of known class");
        }
        return payload;
    }
}

