/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.datafusion.helpers;

import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.search.datafusion.datatypes.RankedRecord;
import org.gcube.search.datafusion.helpers.RecordHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long RSTIMEOUT = 60L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetHelper.class);

    public static void initializeGRS2() {
        TCPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig(GHNContext.getContext().getHostname(), new ArrayList(), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public static URI multiGetAndWrite(final List<RankedRecord> recs, Directory index, Set<String> fields) throws Exception {
        RecordWriter<GenericRecord> rsWriter = ResultSetHelper.initRSWriterForFusedHits(fields);
        DirectoryReader reader = DirectoryReader.open((Directory)index);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(recs.size())));
        Runnable writerRun = new Runnable((IndexReader)reader, fields, rsWriter){
            final /* synthetic */ IndexReader val$reader;
            final /* synthetic */ Set val$fields;
            final /* synthetic */ RecordWriter val$rsWriter;
            {
                this.val$reader = indexReader;
                this.val$fields = set;
                this.val$rsWriter = recordWriter;
            }

            @Override
            public void run() {
                try {
                    int cnt = 0;
                    for (RankedRecord rec : recs) {
                        Integer docID = rec.getLuceneDocID();
                        Document doc = this.val$reader.document(docID.intValue());
                        GenericRecord rsRec = RecordHelper.luceneToRSRecord(doc, this.val$fields, RankedRecord.calcScore(rec));
                        while (!this.val$rsWriter.put((Record)rsRec, 60L, TimeUnit.SECONDS) && this.val$rsWriter.getStatus() == IBuffer.Status.Open) {
                        }
                        ++cnt;
                    }
                    LOGGER.info("Num of recs written " + cnt);
                    if (this.val$rsWriter.getStatus() != IBuffer.Status.Dispose) {
                        this.val$rsWriter.close();
                    }
                }
                catch (Exception e) {
                    try {
                        if (this.val$rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            this.val$rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while closing RS writer.", (Throwable)ex);
                    }
                    LOGGER.error("Error while writing the results : ", (Throwable)e);
                }
            }
        };
        new Thread(writerRun).start();
        LOGGER.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator();
    }

    public static URI multiGetAndWriteNoStream(List<RankedRecord> recs, Directory index, Set<String> fields) throws Exception {
        long starttime = 0L;
        long endtime = 0L;
        starttime = System.currentTimeMillis();
        List<GenericRecord> rerankedRecords = ResultSetHelper.multiget(recs, index, fields);
        endtime = System.currentTimeMillis();
        LOGGER.info(" ~> multiget time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        starttime = System.currentTimeMillis();
        URI locator = ResultSetHelper.writeRecords(rerankedRecords, fields);
        endtime = System.currentTimeMillis();
        LOGGER.info(" ~> writeRecords time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return locator;
    }

    private static List<GenericRecord> multiget(List<RankedRecord> recs, Directory index, Set<String> fieldsName) throws Exception {
        ArrayList<GenericRecord> rsRecs = new ArrayList<GenericRecord>();
        DirectoryReader reader = DirectoryReader.open((Directory)index);
        for (RankedRecord rec : recs) {
            Integer docID = rec.getLuceneDocID();
            Document doc = null;
            if (docID != null) {
                doc = reader.document(docID.intValue());
            }
            GenericRecord rsRec = RecordHelper.luceneToRSRecord(doc, fieldsName, RankedRecord.calcScore(rec));
            rsRecs.add(rsRec);
        }
        return rsRecs;
    }

    private static URI writeRecords(final List<GenericRecord> recs, Set<String> fields) throws Exception {
        final RecordWriter<GenericRecord> rsWriter = ResultSetHelper.initRSWriterForFusedHits(fields);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(recs.size())));
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    int cnt = 0;
                    LOGGER.info("NUm of recs to write " + recs.size());
                    for (GenericRecord rec : recs) {
                        while (!rsWriter.put((Record)rec, 60L, TimeUnit.SECONDS) && rsWriter.getStatus() == IBuffer.Status.Open) {
                        }
                        ++cnt;
                    }
                    LOGGER.info("NUm of recs written " + cnt);
                    if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                        rsWriter.close();
                    }
                }
                catch (GRS2WriterException e) {
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
            }
        };
        new Thread(writerRun).start();
        LOGGER.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator();
    }

    private static RecordWriter<GenericRecord> initRSWriterForFusedHits(Set<String> fields) throws Exception {
        LOGGER.info("Initializing gRS2 writer");
        LOGGER.info("(1/3) getting field definitions");
        FieldDefinition[] fieldDef = null;
        try {
            fieldDef = ResultSetHelper.createFieldDefinition(fields);
        }
        catch (Exception e) {
            LOGGER.error("Could not create field definition: ", (Throwable)e);
            throw new Exception(e);
        }
        LOGGER.info("(2/3) creating record definitions");
        RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
        LOGGER.info("(3/3) creating rsWriter");
        return new RecordWriter((IWriterProxy)new TCPWriterProxy(), definition);
    }

    private static FieldDefinition[] createFieldDefinition(Set<String> fields) throws Exception {
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        FieldDefinition[] fd = null;
        for (String field : fields) {
            fieldDef.add(new StringFieldDefinition(field));
        }
        fd = fieldDef.toArray(new FieldDefinition[fieldDef.size()]);
        return fd;
    }

    public static void printRecords(List<GenericRecord> recs, Set<String> fields) throws GRS2RecordDefinitionException, GRS2BufferException {
        for (GenericRecord rec : recs) {
            for (String field : fields) {
                LOGGER.info(((StringField)rec.getField(field)).getPayload());
            }
            LOGGER.info("");
            LOGGER.info("Record : " + rec.getID());
        }
    }

    public static List<String> getRSRecFields(GenericRecord rsRec) throws GRS2RecordDefinitionException {
        ArrayList<String> fields = new ArrayList<String>();
        for (Field f : rsRec.getFields()) {
            String fieldName = f.getFieldDefinition().getName();
            fields.add(fieldName);
        }
        return fields;
    }
}

