/**
 * 
 */
package org.gcube.resourcemanagement.updater;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

/**
 * @author Roberto Cirillo (ISTI-CNR) 2018
 *
 */
public class Utils {
	
	protected static Properties loadProperties(String filePath) throws IOException {
		//load properties
		InputStream input=null;
		Properties prop = new Properties();
		try {
			String propFileName = filePath;
			input = AccessPointUpdater.class.getClassLoader().getResourceAsStream(propFileName);
			if (input != null) {
				prop.load(input);
			} else {
				throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
			}
			
		} finally{
        	if(input!=null){
        		try {
        			input.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
        	}
        }
		return prop;
			
	}
	
	protected static Properties loadSystemCommands(Properties props) {		
		for (String name : props.stringPropertyNames()) {
			boolean isSystem=name.startsWith("/");
			if(isSystem) {
				AccessPointUpdater.getSysSoftware().add((String)name+" "+props.getProperty(name));
				props.remove(name);
			}
		}
		return props;
	}
	
	protected static void update(Resource resource) {
		System.out.println("resource updating "+resource.id());
		String currentScope=ScopeProvider.instance.get();
		RegistryPublisher rp=RegistryPublisherFactory.create();
		rp.vosUpdate(resource);
		System.out.println("resource updated ");
	}

	protected static ServiceEndpoint getResource(String scope, String category, String name) {
		ScopeProvider.instance.set(scope);
		System.out.println("find from "+scope+ " and Category: "+category+" the following name "+name);
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq '"+category+"'");
		query.addCondition("$resource/Profile/Name/text() eq '"+name+"'");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> se = client.submit(query);
		return se.get(0);
	}

	protected static List<ServiceEndpoint> getResources(String scope, String category, String name) {
		ScopeProvider.instance.set(scope);
		System.out.println("find from "+scope+ " and Category: "+category+" the following name "+name);
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq '"+category+"'");
		query.addCondition("$resource/Profile/Name/text() eq '"+name+"'");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> se = client.submit(query);
		return se;
	}

	
	protected static AccessPoint getAccessPoint(ServiceEndpoint endpoint, String accessPointName) {
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		Group<AccessPoint> accesspoints=endpoint.profile().accessPoints();
		for (AccessPoint point: accesspoints){
			if (point.name().equals(accessPointName)){
				System.out.println("AccessPoint found: "+point.name()+ " address: "+point.address());
				return point;
			}
		}
		return null;
	}

	protected static List<AccessPoint> getAccessPoints(List<ServiceEndpoint> endpoints, String accessPointName) {
		System.out.println("finding the following accessPoint "+accessPointName);
		List<AccessPoint> points=new ArrayList<AccessPoint>();
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		for(ServiceEndpoint endpoint: endpoints){
			Group<AccessPoint> accesspoints=endpoint.profile().accessPoints();
			for (AccessPoint point: accesspoints){
				if (point.name().equals(accessPointName)){
					System.out.println("AccessPoint found: "+point.name()+ " address: "+point.address());
					points.add(point);
				}
			}
		}
		return points;
	}

	protected static ServiceEndpoint getResourceFromHostField(String hostedOnField, List<ServiceEndpoint> resources) {
		System.out.println("resources found: "+resources.size());
		ServiceEndpoint resourceTarget=null;
		for(ServiceEndpoint resource: resources){
			String resourceHost=resource.profile().runtime().hostedOn();
			System.out.println("host field "+resourceHost);
			if(hostedOnField.equals(resourceHost)) {
				resourceTarget=resource;
				System.out.println("resource found: "+resourceTarget);
				break;
			}
				
		}
		return resourceTarget;
	}

}
