/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.updater;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resourcemanagement.updater.AccessPointUpdater;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties loadProperties(String filePath) throws IOException {
        InputStream input = null;
        Properties prop = new Properties();
        try {
            String propFileName = filePath;
            input = AccessPointUpdater.class.getClassLoader().getResourceAsStream(propFileName);
            if (input == null) {
                throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
            }
            prop.load(input);
            String user = prop.getProperty("user");
            String r = prop.getProperty("R");
            String result = "R version= " + r;
            System.out.println("result: " + result);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop;
    }

    protected static void update(Resource resource) {
        String currentScope = ScopeProvider.instance.get();
        System.out.println("update resource in scope " + currentScope);
        RegistryPublisher rp = RegistryPublisherFactory.create();
        rp.vosUpdate(resource);
    }

    protected static ServiceEndpoint getResource(String scope, String category, String name) {
        ScopeProvider.instance.set(scope);
        System.out.println("find from " + scope + " and Category: " + category + " the following name " + name);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List se = client.submit((Query)query);
        return (ServiceEndpoint)se.get(0);
    }

    protected static ServiceEndpoint.AccessPoint getAccessPoint(ServiceEndpoint endpoint, String accessPointName) {
        System.out.println("finding the following accessPoint " + accessPointName);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        Group accesspoints = endpoint.profile().accessPoints();
        for (ServiceEndpoint.AccessPoint point : accesspoints) {
            if (!point.name().equals(accessPointName)) continue;
            System.out.println("AccessPoint found: " + point.name() + " address: " + point.address());
            return point;
        }
        return null;
    }
}

