package org.gcube.common.resources.gcore;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCleaner {
	
	static Logger logger= LoggerFactory.getLogger(ResourceCleaner.class);
	
	public static Resource cleanScope(Resource resource, String toScope){
		System.out.println("removing scopes from resource: "+resource.id());
		List<String> toRemove= new ArrayList<String>();
		for (String scope :resource.scopes()){
			System.out.println("removing scope "+scope+" ");
//			if(!toScope.contains(scope))
				toRemove.add(scope);
			
		}
		for(String scope: toRemove)
			resource.removeScope(scope);
		return resource;
	}
	
	public static Resource cleanAllScopes(Resource resource){
		System.out.println("removing scopes from resource: "+resource.id());
		List<String> toRemove= new ArrayList<String>();
		int count=0;
		for (String scope :resource.scopes()){
			System.out.println("found scope "+scope+" ");
			toRemove.add(scope);
			
		}
		for(String scope: toRemove){
			System.out.println("removing scope "+scope+" ");
			resource.removeScope(scope);
			count++;
		}
		System.out.println("removed "+count+" scopes");
		return resource;
	}
	
	public static List<String> getAllScopes(Resource resource){
		System.out.println("getting scopes from resource: "+resource.id());
		List<String> scopes= new ArrayList<String>();
		int count=0;
		for (String scope :resource.scopes()){
			System.out.println("found scope "+scope+" ");
			scopes.add(scope);
			
		}
		return scopes;
	}

	public static Resource cleanId(Resource resource){
		System.out.println("reset id from resource: "+resource.id());
		resource.setId("");
		return resource;
	}
	
	public static Resource addScopes(Resource resource, List<String> toScopes){
		System.out.println("adding scopes to resource: "+resource.profile().toString());
		int count=0;
		for(String scope: toScopes){
			System.out.println("adding scope: "+scope);
			resource.addScope(scope);
			count++;
		}
		System.out.println("Added "+count+" scopes");
		return resource;
	}

	public static Resource removeScopes(Resource resource, List<String> scopes){
		System.out.println("removing scopes to resource: "+resource.profile().toString());
		int count=0;
		for(String scope: scopes){
			if(resource.scopes().asCollection().contains(scope)){
				System.out.println("removing scope: "+scope);
				resource.removeScope(scope);
				count++;
			}else{
				System.out.println("scope skipped: "+scope);
			}
		}
		System.out.println("removed "+count+" scopes");
		return resource;
	}

}
