package org.gcube.informationsystem.publisher;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.resources.gcore.Resource.Type;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.RemoveException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceDoesNotExistException;
import org.gcube.informationsystem.publisher.utils.RegistryStubs;

public abstract class AdvancedPublisherCommonUtils {
	
	protected RegistryStubs registry;

	
	/**
	 * Remove the input resource from IS and hence from all scope which the resource is defined
	 * @throws IllegalArgumentException if there are problems to contact the Registry service 
	 */
	public <T extends Resource> T removeFromAllScopes(T resource){
		RegistryStub stub=null;
		registry=new RegistryStubs();
		String currentScope=ScopeProvider.instance.get();
		ScopeGroup<String> scopes=resource.scopes();
		List<String> scopesToRemove=new LinkedList<String>(); 
		for(Iterator<String> it=scopes.iterator(); it.hasNext();){
			String scope=it.next();
			ScopeProvider.instance.set(scope);
			try{
				stub=registry.getStubs();
			}catch(RegistryNotFoundException e){
				throw new IllegalArgumentException(e.getCause());
			}
			try{
				stub.remove(resource.id(), resource.type().toString());
			}catch(ResourceDoesNotExistException e){
				// if the scope is a VRE scope probably the resource has already been deleted from VO scope
				// it must be removed from the resource
			}
			scopesToRemove.add(scope);
		}
		for(String scope : scopesToRemove){
			ResourceMediator.removeScope(resource, scope);
		}
		ScopeProvider.instance.set(currentScope);
		return resource;
	}
	
	
//	/**
//	 * Remove the resource defined by id and type parameters from IS and hence from all scope which the resource is defined
//	 * @throws IllegalArgumentException if there are problems to contact the Registry service 
//	 */
//	public void removeFromAllScopes(String id, Type type){
//		RegistryStub stub=null;
//		registry=new RegistryStubs();
//		
//		try{
//			stub=registry.getStubs();
//		}catch(RegistryNotFoundException e){
//			throw new IllegalArgumentException(e.getCause());
//		}
//		try{
//			stub.remove(id, type.toString());
//		}catch(ResourceDoesNotExistException e){
//			throw new IllegalArgumentException(e.getCause());
//		}catch(RemoveException e){
//			throw new IllegalArgumentException(e.getCause());
//		}
//
//	}


}
