/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.impl;

import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.federation.fhnmanager.api.FHNManager;
import org.gcube.resources.federation.fhnmanager.api.exception.ConnectorException;
import org.gcube.resources.federation.fhnmanager.api.exception.FHNManagerException;
import org.gcube.resources.federation.fhnmanager.api.type.Node;
import org.gcube.resources.federation.fhnmanager.api.type.NodeDefinition;
import org.gcube.resources.federation.fhnmanager.api.type.NodeTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusInfrastructure;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusInfrastructureTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceReference;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ServiceProfile;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.resources.federation.fhnmanager.impl.ConnectorFactory;
import org.gcube.resources.federation.fhnmanager.is.ISProxyImpl;
import org.gcube.resources.federation.fhnmanager.is.ISProxyInterface;
import org.gcube.resources.federation.fhnmanager.occopus.OccopusClient;
import org.gcube.resources.federation.fhnmanager.occopus.model.CreateInfraResponse;
import org.gcube.resources.federation.fhnmanager.occopus.model.GetInfraResponse;
import org.gcube.resources.federation.fhnmanager.utils.NodeHelper;
import org.gcube.resources.federation.fhnmanager.utils.Props;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.datamodel.cloud.OSTemplate;
import org.gcube.vomanagement.occi.datamodel.cloud.VM;
import org.gcube.vomanagement.occi.utils.ScriptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FHNManagerImpl
implements FHNManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FHNManagerImpl.class);
    static Props a = new Props();
    private static final String URL = a.getOccopusURL();
    private ConnectorFactory connectorFactory = new ConnectorFactory();
    private OccopusClient occpusClient;
    private ISProxyInterface isProxy = new ISProxyImpl();

    public FHNManagerImpl() {
        this.occpusClient = new OccopusClient(URL);
    }

    public String resourceTemplateName(String vmpId, String rtId) {
        String name = "";
        for (ResourceTemplate a : this.findResourceTemplate(vmpId)) {
            if (!a.getId().equals(rtId)) continue;
            name = String.valueOf(name) + "occi_" + a.getName();
        }
        return name;
    }

    public String buildOccopusDescription(OccopusInfrastructureTemplate it) {
        String builded = "infra_name: occi_infra_test\nuser_id: somebody@somewhere.com\nnodes:";
        String builded2 = "";
        String finalbuild = "";
        for (NodeDefinition b : it.getSetnd()) {
            builded2 = String.valueOf(builded2) + "\n -\n  name: " + this.resourceTemplateName(b.getVmproviderId(), b.getResourceTemplateId()).trim().replace(":", "") + "_" + b.getNodetemplateId() + "_" + this.isProxy.findVMProviderbyId(b.getVmproviderId()).getCredentials().getVo() + "\n" + "  type: " + this.resourceTemplateName(b.getVmproviderId(), b.getResourceTemplateId()).trim().replace(":", "") + "_" + b.getNodetemplateId() + "_" + this.isProxy.findVMProviderbyId(b.getVmproviderId()).getCredentials().getVo() + "\n" + "  scaling: " + "\n" + "   min: " + b.getScaling().getMin() + "\n" + "   max: " + b.getScaling().getMax();
        }
        finalbuild = String.valueOf(builded) + builded2;
        return finalbuild;
    }

    public OccopusInfrastructure createInfrastructureByTemplate(String infraTemplate) {
        try {
            this.isProxy.setD4ScienceOccopusAuth();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OccopusInfrastructureTemplate it = this.isProxy.returnInfraTemplate(infraTemplate);
        CreateInfraResponse cir = this.occpusClient.createInfrastructure(this.buildOccopusDescription(it));
        String infraId = cir.getInfraid();
        if (infraId == null) {
            LOGGER.error("A problem occurred during the infrastructure creation. Operation aborted");
            return null;
        }
        OccopusInfrastructure infra = new OccopusInfrastructure();
        infra.setId(infraId);
        infra.setInfrastructureTemplate(it.getId());
        LOGGER.info("Infrastructure created with id=" + infraId + " from template " + it.getId());
        this.isProxy.addInfra(infra);
        return infra;
    }

    public Node createNode(String vmProviderId, String serviceProfileId, String resourceTemplateId) {
        VMProvider vmp = this.isProxy.getVMProviderById(vmProviderId);
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.connect();
            NodeTemplate nt = this.isProxy.getNodeTemplate(serviceProfileId, vmProviderId);
            LOGGER.debug("NodeTemplate found: " + nt);
            String osTemplateId = nt.getOsTemplateId();
            LOGGER.debug("OSTemplateId found: " + osTemplateId);
            ResourceTemplate resourceTemplate = connector.getResourceTemplate(new URI(resourceTemplateId));
            LOGGER.debug("ResourceTemplate found: " + nt);
            OSTemplate osTemplate = connector.getOSTemplate(new URI(osTemplateId));
            LOGGER.debug("OSTemplate found: " + nt);
            ServiceProfile sp = this.isProxy.getServiceProfileById(serviceProfileId);
            String scriptNew = ScriptUtil.getScriptFromURL((URL)nt.getScript());
            System.out.println(scriptNew);
            String script2 = scriptNew.replace("export SMARTGEARS_TOKEN='token'", "export SMARTGEARS_TOKEN=" + SecurityTokenProvider.instance.get());
            System.out.println(script2);
            URI vmId = connector.createVM("vm" + UUID.randomUUID(), osTemplate, resourceTemplate, script2);
            VM vm = connector.getVM(vmId);
            Node node = NodeHelper.createNode((VM)vm, (VMProvider)vmp, (ServiceProfile)sp, (NodeTemplate)nt, (ResourceTemplate)resourceTemplate);
            this.isProxy.addNode(node);
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<Node> findNodes(String serviceProfileId, String vmProviderId) throws UnknownHostException {
        return this.isProxy.findNodes(serviceProfileId, vmProviderId);
    }

    public Set<VMProvider> findVMProviders(String serviceProfileId) throws FHNManagerException {
        return this.isProxy.findVMProvidersbyServiceProfile(serviceProfileId);
    }

    public VMProvider getVMProviderbyId(String vmProviderid) {
        return this.isProxy.findVMProviderbyId(vmProviderid);
    }

    public Set<ServiceProfile> allServiceProfiles() throws FHNManagerException {
        return this.isProxy.getAllServiceProfiles();
    }

    public Collection<ResourceTemplate> findResourceTemplate(String vmProviderid) {
        boolean success = false;
        if (vmProviderid == null) {
            HashSet<ResourceTemplate> listvmp = new HashSet<ResourceTemplate>();
            for (VMProvider vmp2 : this.findVMProviders(null)) {
                listvmp.addAll(this.findResourceTemplate(vmp2.getId()));
            }
            return listvmp;
        }
        VMProvider vmp = this.isProxy.getVMProviderById(vmProviderid);
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        HashSet<ResourceTemplate> list = new HashSet();
        try {
            connector.connect();
            list = connector.listResourceTemplates();
            success = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (success) {
            ResourceReference rr = new ResourceReference(vmProviderid);
            for (ResourceTemplate a : list) {
                a.setVmProvider(rr);
            }
        }
        return list;
    }

    public Node getNodeById(String nodeId) {
        return this.isProxy.getNodeById(nodeId);
    }

    public void startNode(String NodeId) throws FHNManagerException {
        Node n = this.isProxy.getNodeById(NodeId);
        VMProvider vmp = this.isProxy.getVMProviderById(n.getVmProvider().getRefId());
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.startVM(URI.create(NodeHelper.getVMId((String)n.getId())));
        }
        catch (CommunicationException e) {
            throw new ConnectorException("Exception received from the connector: " + e.getMessage());
        }
    }

    public void stopNode(String NodeId) throws FHNManagerException {
        Node n = this.isProxy.getNodeById(NodeId);
        VMProvider vmp = this.isProxy.getVMProviderById(n.getVmProvider().getRefId());
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            System.out.println(NodeHelper.getVMId((String)n.getId()));
            connector.stopVM(URI.create(NodeHelper.getVMId((String)n.getId())));
        }
        catch (CommunicationException e) {
            throw new ConnectorException("Exception received from the connector: " + e.getMessage());
        }
    }

    public void deleteNode(String NodeId) throws FHNManagerException {
        Node n = this.isProxy.getNodeById(NodeId);
        VMProvider vmp = this.isProxy.getVMProviderById(n.getVmProvider().getRefId());
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.destroyVM(URI.create(NodeHelper.getVMId((String)n.getId())));
            this.isProxy.deleteNode(n);
            if (!n.getHostname().equals("")) {
                this.isProxy.deleteHostingNode(n.getHostname());
            }
        }
        catch (CommunicationException e) {
            throw new ConnectorException("Exception received from the connector: " + e.getMessage());
        }
    }

    public void destroyInfrastructure(String infrastructureId) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(String.valueOf(URL) + "/infrastructures/" + infrastructureId);
        Response response = target.request().accept(new String[]{"application/json"}).delete();
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        this.isProxy.deleteInfrastructure(infrastructureId);
        System.out.println("Infrastructure " + infrastructureId + " correctly deleted");
    }

    public void getInfrastructures() {
        try {
            Client client = ClientBuilder.newClient();
            WebTarget target = client.target(String.valueOf(URL) + "/infrastructures");
            Response response = target.request().accept(new String[]{"application/json"}).get();
            String entity = (String)response.readEntity(String.class);
            if (response.getStatus() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
            }
            System.out.println(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OccopusInfrastructure getInfrastructureById(String infraId) {
        if (infraId == null) {
            LOGGER.error("A problem occurred during the infrastructure returning. Operation aborted");
            return null;
        }
        return this.isProxy.getInfrastructureById(infraId);
    }

    public void updateOccopusInfra() {
        for (OccopusInfrastructure a : this.isProxy.getAllInfrastructuresList()) {
            try {
                GetInfraResponse cir = this.occpusClient.getInfrastructure(a.getId());
                if (cir == null) {
                    return;
                }
                a.setInstanceSets(cir.getInstanceSets());
                this.isProxy.updateInfra(a);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void getOccopusInfrastructureById(String infraid) {
        try {
            Client client = ClientBuilder.newClient();
            WebTarget target = client.target(String.valueOf(URL) + "/infrastructures/" + infraid);
            Response response = target.request().accept(new String[]{"application/json"}).get();
            String entity = (String)response.readEntity(String.class);
            if (response.getStatus() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
            }
            System.out.println(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<OccopusInfrastructure> getAllInfrastructures() {
        LOGGER.info("OccopusInfra:");
        this.getInfrastructures();
        LOGGER.info("ISInfra:");
        return this.isProxy.getAllInfrastructures();
    }

    public static void main(String[] args) {
        FHNManagerImpl a = new FHNManagerImpl();
        ScopeProvider.instance.set("/gcube/devsec");
        OccopusInfrastructureTemplate b = a.isProxy.returnInfraTemplate("occopusInfraTemplate3ee7cda3-0171-42a7-8a42-38c89b6912c2");
        a.createInfrastructureByTemplate(b.getId());
    }
}

