/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.occopus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import org.gcube.resources.federation.fhnmanager.api.type.NodeTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.resources.federation.fhnmanager.impl.FHNManagerImpl;
import org.gcube.resources.federation.fhnmanager.is.ISProxyImpl;
import org.gcube.resources.federation.fhnmanager.utils.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccopusNodeDefinitionImporter {
    public static String node_def;
    public static String type;
    public static String endpoint;
    public static String os_tpl;
    public static String resource_tpl;
    public static String script;
    static Props a;
    private static final String NODES_STORAGE_PATH;
    private static final String NODES_STORAGE_FILE = "node_definitions_test.yaml";
    private static final Logger LOGGER;

    public void dumpNodes(String ag) throws IOException {
        File file = new File(NODES_STORAGE_PATH + File.separator + NODES_STORAGE_FILE);
        FileWriter writer = new FileWriter(file);
        writer.write(ag);
        LOGGER.debug("Nodes stored to " + file.getAbsolutePath());
        writer.close();
    }

    private void init() {
        File path = new File(NODES_STORAGE_PATH);
        path.mkdirs();
    }

    public void importer() throws IOException {
        this.init();
        ISProxyImpl isProxy = new ISProxyImpl();
        FHNManagerImpl b = new FHNManagerImpl();
        String ag = "";
        String af = "";
        for (VMProvider vmp : isProxy.getAllVMProviders()) {
            try {
                Collection resourceTemplates = b.findResourceTemplate(vmp.getId());
                for (NodeTemplate nt : isProxy.getVMProviderNodeTemplates(vmp.getId())) {
                    for (ResourceTemplate rt : resourceTemplates) {
                        ag = ag + "\n" + "\n" + this.formatNodeDefinition(rt, vmp, nt);
                        af = af + "\n" + "\n" + this.formatContext(nt);
                    }
                }
                try {
                    this.dumpNodes(ag);
                    this.loadNodeDefinition(NODES_STORAGE_PATH + File.separator + NODES_STORAGE_FILE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception aa) {}
        }
    }

    public String formatContext(NodeTemplate nt) throws IOException {
        File file = new File(a.getPathOccopusNodes() + File.separator + nt.getId() + ".yaml");
        FileWriter writer = new FileWriter(file);
        String context = "#cloud-config\nsystem_info:\n default_user:\n  name: d4science\n  sudo: ALL=(ALL) NOPASSWD:ALL\nruncmd:\n - curl -L " + nt.getScript() + " | sudo /bin/bash -" + "\n";
        try {
            writer.write(context);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug("Context stored to " + file.getAbsolutePath());
        return nt.getId() + ".yaml";
    }

    public String setPublicNet(VMProvider vmp) {
        if (vmp.getEndpoint().equals("https://nova2.ui.savba.sk:8787") || vmp.getEndpoint().equals("https://fc-one.i3m.upv.es:11443")) {
            return "/network/public";
        }
        return "";
    }

    public String formatNodeDefinition(ResourceTemplate rtt, VMProvider vmp, NodeTemplate nt) throws IOException {
        String nodeDefinition = "'node_def:occi_" + rtt.getName().trim().replace(":", "") + "_" + nt.getId() + "_" + vmp.getCredentials().getVo() + "':" + "\n -\n" + "  resource:" + "\n" + "   type: occi \n" + "   endpoint: " + vmp.getEndpoint() + "\n" + "   os_tpl: " + nt.getOsTemplateId() + "\n" + "   resource_tpl: " + rtt.getId() + "\n" + "   link: " + "\n" + "    -" + "\n" + "     " + this.setPublicNet(vmp) + "\n" + "  contextualisation:" + "\n" + "   type: cloudinit" + "\n" + "   context_template: !text_import" + "\n" + "    url: file://" + this.formatContext(nt) + "\n";
        System.out.println(nodeDefinition);
        return nodeDefinition;
    }

    public void loadNodeDefinition(String nodedef) {
        try {
            String line;
            StringBuilder importoccopus = new StringBuilder();
            importoccopus.append("virtualenv occopus  ");
            importoccopus.append("&&");
            importoccopus.append("source " + a.getOccopusDIR() + " activate ");
            importoccopus.append("&&");
            importoccopus.append("occopus-import " + nodedef);
            String[] command = new String[]{"/bin/bash", "-c", importoccopus.toString()};
            System.out.println(command);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            System.out.println("Process started !");
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
            proc.destroy();
            System.out.println("Process ended !");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        a = new Props();
        NODES_STORAGE_PATH = a.getPathOccopusNodes();
        LOGGER = LoggerFactory.getLogger(OccopusNodeDefinitionImporter.class);
    }
}

